/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.missingvalues;

import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.doublematrix.calculation.general.missingvalues.ImputeBPCA;
import org.ujmp.core.doublematrix.calculation.general.missingvalues.ImputeEM;
import org.ujmp.core.doublematrix.calculation.general.missingvalues.ImputeKNN;
import org.ujmp.core.doublematrix.calculation.general.missingvalues.ImputeLS;
import org.ujmp.core.doublematrix.calculation.general.missingvalues.ImputeMean;
import org.ujmp.core.doublematrix.calculation.general.missingvalues.ImputeRegression;
import org.ujmp.core.doublematrix.calculation.general.missingvalues.ImputeZero;

public class Impute
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -8899889992449926887L;
    private Matrix imp = null;
    private ImputationMethod method = null;
    private Object[] parameters = null;

    public Impute(Matrix matrix, ImputationMethod method, Object ... parameters) {
        super(matrix);
        this.method = method;
        this.parameters = parameters;
    }

    public double getDouble(long ... coordinates) {
        if (this.imp == null) {
            try {
                Calculation calc = null;
                switch (this.method) {
                    case Zero: {
                        calc = new ImputeZero(this.getSource());
                        break;
                    }
                    case RowMean: {
                        calc = new ImputeMean(0, this.getSource());
                        break;
                    }
                    case ColumnMean: {
                        calc = new ImputeMean(1, this.getSource());
                        break;
                    }
                    case BPCA: {
                        calc = new ImputeBPCA(this.getSource());
                        break;
                    }
                    case KNN: {
                        calc = new ImputeKNN(this.getSource(), this.parameters);
                        break;
                    }
                    case EM: {
                        calc = new ImputeEM(this.getSource());
                        break;
                    }
                    case Regression: {
                        calc = new ImputeRegression(this.getSource());
                        break;
                    }
                    case EMimputeGene: {
                        calc = new ImputeLS(this.getSource(), this.method);
                        break;
                    }
                    case EMimputeArray: {
                        calc = new ImputeLS(this.getSource(), this.method);
                        break;
                    }
                    case LSimputeGene: {
                        calc = new ImputeLS(this.getSource(), this.method);
                        break;
                    }
                    case LSimputeArray: {
                        calc = new ImputeLS(this.getSource(), this.method);
                        break;
                    }
                    case LSimputeCombined: {
                        calc = new ImputeLS(this.getSource(), this.method);
                        break;
                    }
                    case LSimputeAdaptive: {
                        calc = new ImputeLS(this.getSource(), this.method);
                    }
                }
                this.imp = calc.calcNew();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.imp.getAsDouble(coordinates);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImputationMethod {
        Zero,
        RowMean,
        ColumnMean,
        Regression,
        KNN,
        EM,
        BPCA,
        EMimputeGene,
        EMimputeArray,
        LSimputeGene,
        LSimputeArray,
        LSimputeCombined,
        LSimputeAdaptive;

    }
}

