/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TIterator;
import gnu.trove.TObjectByteHashMap;
import gnu.trove.TObjectHash;
import java.util.ConcurrentModificationException;

public class TObjectByteIterator
extends TIterator {
    private final TObjectByteHashMap _map;

    public TObjectByteIterator(TObjectByteHashMap map) {
        super(map);
        this._map = map;
    }

    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] set = this._map._set;
        int i = this._index;
        while (i-- > 0 && (set[i] == TObjectHash.FREE || set[i] == TObjectHash.REMOVED)) {
        }
        return i;
    }

    public void advance() {
        this.moveToNextIndex();
    }

    public Object key() {
        return this._map._set[this._index];
    }

    public byte value() {
        return this._map._values[this._index];
    }

    public byte setValue(byte val) {
        byte old = this.value();
        this._map._values[this._index] = val;
        return old;
    }
}

