/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.io.expr.res;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.data.expr.Util;
import org.genepattern.io.expr.IExpressionDataWriter;

public class ResWriter
implements IExpressionDataWriter {
    @Override
    public String checkFileExtension(String filename) {
        if (!((String)filename).toLowerCase().endsWith(".res")) {
            filename = (String)filename + ".res";
        }
        return filename;
    }

    @Override
    public void write(IExpressionData data, OutputStream os) throws IOException {
        if (!Util.containsData(data, "calls")) {
            throw new IOException("Can't write in res format. Data does not have calls.");
        }
        PrintWriter out = new PrintWriter(os);
        int rows = data.getRowCount();
        int columns = data.getColumnCount();
        out.print("Description");
        out.print("\t");
        out.print("Accession");
        out.print("\t");
        out.print(data.getColumnName(0));
        for (int j = 1; j < columns; ++j) {
            out.print("\t\t");
            out.print(data.getColumnName(j));
        }
        out.print("\n");
        out.print("\t");
        String columnDescription = data.getColumnMetadata(0, "description");
        if (columnDescription == null) {
            columnDescription = "";
        }
        out.print(columnDescription);
        for (int j = 1; j < columns; ++j) {
            out.print("\t\t");
            columnDescription = data.getColumnMetadata(j, "description");
            if (columnDescription == null) {
                columnDescription = "";
            }
            out.print(columnDescription);
        }
        out.print("\n");
        out.print(rows);
        for (int i = 0; i < rows; ++i) {
            out.print("\n");
            String rowDescription = data.getRowMetadata(i, "description");
            if (rowDescription == null) {
                rowDescription = "";
            }
            out.print(rowDescription);
            out.print("\t");
            out.print(data.getRowName(i));
            for (int j = 0; j < columns; ++j) {
                out.print("\t");
                out.print(data.getValueAsString(i, j));
                out.print("\t");
                out.print(data.getData(i, j, "calls"));
            }
        }
        out.flush();
    }
}

