/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.data.matrix;

import org.genepattern.data.expr.ExpressionData;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.data.matrix.DoubleMatrix2D;

public class IExpressionDataUtil {
    private IExpressionDataUtil() {
    }

    public static IExpressionData sliceView(final IExpressionData dataset, int[] _rowIndices, int[] _columnIndices) {
        int i;
        if (dataset instanceof ExpressionData) {
            return ((ExpressionData)dataset).slice(_rowIndices, _columnIndices);
        }
        if (_rowIndices == null) {
            _rowIndices = new int[dataset.getRowCount()];
            i = dataset.getRowCount();
            while (--i >= 0) {
                _rowIndices[i] = i;
            }
        }
        if (_columnIndices == null) {
            _columnIndices = new int[dataset.getColumnCount()];
            i = dataset.getColumnCount();
            while (--i >= 0) {
                _columnIndices[i] = i;
            }
        }
        final int[] rowIndices = _rowIndices;
        final int[] columnIndices = _columnIndices;
        return new IExpressionData(){

            @Override
            public String getValueAsString(int row, int column) {
                return dataset.getValueAsString(rowIndices[row], columnIndices[column]);
            }

            @Override
            public double getValue(int row, int column) {
                return dataset.getValue(rowIndices[row], columnIndices[column]);
            }

            @Override
            public String getRowName(int row) {
                return dataset.getRowName(rowIndices[row]);
            }

            @Override
            public int getRowCount() {
                return rowIndices.length;
            }

            @Override
            public int getColumnCount() {
                return columnIndices.length;
            }

            @Override
            public String getColumnName(int column) {
                return dataset.getColumnName(columnIndices[column]);
            }

            @Override
            public String getRowMetadata(int row, String name) {
                return dataset.getColumnMetadata(rowIndices[row], name);
            }

            @Override
            public String getColumnMetadata(int column, String name) {
                return dataset.getColumnMetadata(columnIndices[column], name);
            }

            @Override
            public int getRowIndex(String rowName) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getColumnIndex(String columnName) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object getData(int row, int column, String name) {
                return dataset.getData(rowIndices[row], columnIndices[column], name);
            }

            @Override
            public String getDataName(int index) {
                return dataset.getDataName(index);
            }

            @Override
            public int getDataCount() {
                return dataset.getDataCount();
            }
        };
    }

    public static IExpressionData createRandomData(int rows, int columns) {
        double[][] data = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                data[i][j] = Math.random() * 300.0 + 1.0;
            }
        }
        DoubleMatrix2D matrix = new DoubleMatrix2D(data);
        ExpressionData d = new ExpressionData(matrix, null, null);
        return d;
    }
}

