/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing.fields;

import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.genome.swing.windows.GTextAreaWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GStringsInputFieldPlusChooser
extends JPanel
implements GFieldPlusChooser {
    private final JTextField tfEntry = new JTextField(40);
    private final JButton bEntry = new JButton(GuiHelper.ICON_ELLIPSIS);
    private final GTextAreaWindow fWindow;
    private static final String PARSE_DELIMS = ",\t\n";

    public GStringsInputFieldPlusChooser(String text) {
        this.fWindow = new GTextAreaWindow(text);
        this.init();
    }

    public GStringsInputFieldPlusChooser() {
        this.fWindow = new GTextAreaWindow();
        this.init();
    }

    private void init() {
        this.jbInit();
        this.bEntry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = GStringsInputFieldPlusChooser.this.fWindow.show();
                if (text != null) {
                    GStringsInputFieldPlusChooser.this.format(text);
                }
            }
        });
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.tfEntry.setEditable(true);
        this.add((Component)this.tfEntry, "Center");
        this.add((Component)this.bEntry, "East");
    }

    private void format(String text) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(text, PARSE_DELIMS);
        while (tok.hasMoreTokens()) {
            buf.append(tok.nextToken()).append(',');
        }
        this.tfEntry.setText(buf.toString());
    }

    public String getText() {
        return this.tfEntry.getText();
    }

    public void setText(String text) {
        this.tfEntry.setText(text);
    }

    public JTextField getTextField() {
        return this.tfEntry;
    }

    @Override
    public Object getValue() {
        return this.getText();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void setValue(Object obj) {
        if (obj == null) {
            this.setText(null);
        } else {
            this.setText(obj.toString());
        }
    }
}

