/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.io.FtpResultInputStream;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.MSigDBSpecies;
import edu.mit.broad.genome.objects.MSigDBVersion;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.AbstractParser;
import edu.mit.broad.genome.parsers.ParserException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class GmtParser
extends AbstractParser {
    public GmtParser() {
        super(GeneSetMatrix.class);
    }

    @Override
    public void export(PersistentObject gmpob, File file) throws Exception {
        try (PrintWriter pw = this.startExport(gmpob, file);){
            GeneSetMatrix gm = (GeneSetMatrix)gmpob;
            for (int i = 0; i < gm.getNumGeneSets(); ++i) {
                GeneSet gset = gm.getGeneSet(i);
                StringBuilder buf = new StringBuilder(gset.getName()).append('\t');
                String ne = gset.getNameEnglish();
                if (this.isNullorNa(ne)) {
                    ne = "na";
                }
                buf.append(ne).append('\t');
                for (int f = 0; f < gset.getNumMembers(); ++f) {
                    buf.append(gset.getMember(f));
                    if (f >= gset.getNumMembers() - 1) continue;
                    buf.append('\t');
                }
                buf.append('\n');
                pw.print(buf.toString());
            }
            this.doneExport();
        }
    }

    @Override
    public List parse(String sourcepath, InputStream is) throws Exception {
        MSigDBVersion msigDBVersion;
        this.startImport(sourcepath);
        if (is instanceof FtpResultInputStream) {
            String versionStr = NamingConventions.extractVersionFromFileName(sourcepath, ".symbols.gmt");
            MSigDBSpecies msigDBSpecies = versionStr.contains("Mm") ? MSigDBSpecies.Mouse : MSigDBSpecies.Human;
            msigDBVersion = new MSigDBVersion(msigDBSpecies, versionStr);
        } else {
            msigDBVersion = MSigDBVersion.createUnknownTrackingVersion(sourcepath);
        }
        try {
            List list;
            try (BufferedReader bin = new BufferedReader(new InputStreamReader(is));){
                String currLine = this.nextLine(bin);
                int row = 0;
                ArrayList<GeneSet> gsets = new ArrayList<GeneSet>();
                while (currLine != null) {
                    StringTokenizer tok = new StringTokenizer(currLine, "\t");
                    int cnt = tok.countTokens();
                    if (cnt <= 1) {
                        throw new ParserException("Empty gene line: " + currLine + " at row: " + row);
                    }
                    String gsetName = tok.nextToken().trim().toUpperCase();
                    String gsetname_english = tok.nextToken().trim();
                    ArrayList<String> geneNames = new ArrayList<String>();
                    while (tok.hasMoreTokens()) {
                        String geneName = tok.nextToken().trim();
                        if (this.isNull(geneName)) continue;
                        geneNames.add(geneName);
                    }
                    String fname = sourcepath.concat("#").concat(gsetName);
                    GeneSet gset = new GeneSet(fname, gsetname_english, geneNames, true, msigDBVersion);
                    gsets.add(gset);
                    ++row;
                    currLine = this.nextLine(bin);
                }
                DefaultGeneSetMatrix geneSetMatrix = new DefaultGeneSetMatrix(sourcepath, gsets, msigDBVersion);
                list = GmtParser.unmodlist(geneSetMatrix);
            }
            return list;
        }
        finally {
            this.doneImport();
        }
    }
}

