/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.alg.AlgMap;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.VectorSplitter;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.Template;
import java.util.Map;

public class Metrics {
    private static final int MIN_NUM_FOR_VAR = 3;
    public static Metric[] METRICS_FOR_GSEA = new Metric[]{new Signal2Noise(), new tTest(), new Cosine(), new Euclidean(), new Manhattan(), new Pearson(), new Spearman(), new ClassRatio(), new ClassDiff(), new ClassLog2Ratio()};
    public static Metric NONE_METRIC = new None();

    private Metrics() {
    }

    public static Metric lookupMetric(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Cannot lookup for null object");
        }
        if (obj instanceof Metric) {
            return (Metric)obj;
        }
        String lookupName = obj.toString();
        if ("Manhatten".equalsIgnoreCase(lookupName)) {
            lookupName = "Manhattan";
        }
        for (int i = 0; i < METRICS_FOR_GSEA.length; ++i) {
            if (!METRICS_FOR_GSEA[i].getName().equalsIgnoreCase(lookupName)) continue;
            return METRICS_FOR_GSEA[i];
        }
        if ("None".equalsIgnoreCase(lookupName)) {
            return NONE_METRIC;
        }
        throw new RuntimeException("Cannot lookup Metric for: " + lookupName + "; unsupported Metric.");
    }

    public static class ClassDiff
    extends AbstractMetric {
        public ClassDiff() {
            super(CATEGORICAL, "Diff_of_Classes");
        }

        @Override
        public double getScore(Vector profile, Template template, Map<String, Boolean> params) {
            Vector[] vs = this.fSplitter.splitBiphasic_nansafe(profile, template);
            int coiIndex = template.getClassOfInterestIndex();
            boolean useMean = AlgMap.isMean(params);
            if (vs == null) {
                return 0.0;
            }
            if (coiIndex == 0) {
                return XMath.meanOrMedianDiff(vs[0], vs[1], useMean);
            }
            return XMath.meanOrMedianDiff(vs[1], vs[0], useMean);
        }
    }

    public static class ClassLog2Ratio
    extends AbstractMetric {
        public ClassLog2Ratio() {
            super(CATEGORICAL, "log2_Ratio_of_Classes");
        }

        @Override
        public double getScore(Vector profile, Template template, Map<String, Boolean> params) {
            Vector[] vs = this.fSplitter.splitBiphasic_nansafe(profile, template);
            int coiIndex = template.getClassOfInterestIndex();
            boolean useMean = AlgMap.isMean(params);
            if (vs == null) {
                return 0.0;
            }
            if (coiIndex == 0) {
                return XMath.log2(XMath.meanOrMedianRatio(vs[0], vs[1], useMean));
            }
            return XMath.log2(XMath.meanOrMedianRatio(vs[1], vs[0], useMean));
        }
    }

    public static class ClassRatio
    extends AbstractMetric {
        public ClassRatio() {
            super(CATEGORICAL, "Ratio_of_Classes");
        }

        @Override
        public double getScore(Vector profile, Template template, Map<String, Boolean> params) {
            Vector[] vs = this.fSplitter.splitBiphasic_nansafe(profile, template);
            int coiIndex = template.getClassOfInterestIndex();
            boolean useMean = AlgMap.isMean(params);
            if (vs == null) {
                return 0.0;
            }
            if (coiIndex == 0) {
                return XMath.meanOrMedianRatio(vs[0], vs[1], useMean);
            }
            return XMath.meanOrMedianRatio(vs[1], vs[0], useMean);
        }
    }

    public static class tTest
    extends AbstractMetric {
        public static final String NAME = "tTest";

        public tTest() {
            super(CATEGORICAL, NAME, 3);
        }

        @Override
        public double getScore(Vector profile, Template template, Map<String, Boolean> params) {
            boolean usemedian = AlgMap.isMedian(params);
            boolean usebiased = AlgMap.isBiased(params);
            boolean fixlow = AlgMap.isFixLowVar(params);
            Vector[] vs = this.fSplitter.splitBiphasic_nansafe(profile, template);
            if (vs == null) {
                return 0.0;
            }
            int coiIndex = template.getClassOfInterestIndex();
            if (coiIndex == 0) {
                return XMath.tTest(vs[0], vs[1], usebiased, usemedian, fixlow);
            }
            return XMath.tTest(vs[1], vs[0], usebiased, usemedian, fixlow);
        }
    }

    public static class Signal2Noise
    extends AbstractMetric {
        public static final String NAME = "Signal2Noise";

        public Signal2Noise() {
            super(CATEGORICAL, NAME, 3);
        }

        @Override
        public double getScore(Vector profile, Template template, Map<String, Boolean> params) {
            boolean usebiased = AlgMap.isBiased(params);
            boolean fixlow = AlgMap.isFixLowVar(params);
            boolean usemedian = AlgMap.isMedian(params);
            Vector[] vs = this.fSplitter.splitBiphasic_nansafe(profile, template);
            if (vs == null) {
                return 0.0;
            }
            int coiIndex = template.getClassOfInterestIndex();
            if (coiIndex == 0) {
                return XMath.s2n(vs[0], vs[1], usebiased, usemedian, fixlow);
            }
            return XMath.s2n(vs[1], vs[0], usebiased, usemedian, fixlow);
        }
    }

    public static class Cosine
    extends AbstractMetric {
        public Cosine() {
            super(CONTINUOUS, "Cosine");
        }

        @Override
        public double getScore(Vector profile, Template template, Map<String, Boolean> params) {
            return XMath.cosine(template.synchProfile(profile), template.toVector());
        }
    }

    public static class Spearman
    extends AbstractMetric {
        public Spearman() {
            super(CONTINUOUS, "Spearman");
        }

        @Override
        public double getScore(Vector profile, Template template, Map<String, Boolean> params) {
            return XMath.spearman(template.synchProfile(profile), template.toVector());
        }
    }

    public static class Pearson
    extends AbstractMetric {
        public Pearson() {
            super(CONTINUOUS, "Pearson");
        }

        @Override
        public double getScore(Vector profile, Template template, Map<String, Boolean> params) {
            return XMath.pearson(template.synchProfile(profile), template.toVector());
        }
    }

    public static class Manhattan
    extends AbstractMetric {
        static final String NAME = "Manhattan";
        static final String TYPO_NAME = "Manhatten";

        public Manhattan() {
            super(CONTINUOUS, NAME);
        }

        @Override
        public double getScore(Vector profile, Template template, Map<String, Boolean> params) {
            return XMath.manhattan(template.synchProfile(profile), template.toVector());
        }
    }

    public static class Euclidean
    extends AbstractMetric {
        public Euclidean() {
            super(CONTINUOUS, "Euclidean");
        }

        @Override
        public double getScore(Vector profile, Template template, Map<String, Boolean> params) {
            return XMath.euclidean(template.synchProfile(profile), template.toVector());
        }
    }

    public static class None
    extends AbstractMetric {
        static final String NAME = "None";

        public None() {
            super(CAT_AND_CONT, NAME);
        }

        @Override
        public double getScore(Vector profile, Template template, Map<String, Boolean> params) {
            return profile.getElement(0);
        }
    }

    public static abstract class AbstractMetric
    implements Metric {
        protected VectorSplitter fSplitter;
        private final Metric.Type fType;
        private final String fName;
        private final int fMinNumSamplesNeededPerClassForCalculation;

        public AbstractMetric(Metric.Type type, String name) {
            this.fType = type;
            this.fName = name;
            this.fMinNumSamplesNeededPerClassForCalculation = 1;
            this.fSplitter = new VectorSplitter(1);
        }

        public AbstractMetric(Metric.Type type, String name, int minNumSamplesNeededPerClassForCalculation) {
            this.fType = type;
            this.fName = name;
            this.fMinNumSamplesNeededPerClassForCalculation = minNumSamplesNeededPerClassForCalculation;
            this.fSplitter = new VectorSplitter(1);
        }

        @Override
        public boolean isCategorical() {
            return this.fType.equals(CATEGORICAL) || this.fType.equals(CAT_AND_CONT);
        }

        @Override
        public boolean isContinuous() {
            return this.fType.equals(CONTINUOUS) || this.fType.equals(CAT_AND_CONT);
        }

        @Override
        public String getName() {
            return this.fName;
        }

        public String toString() {
            return this.getName();
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Metric) {
                return this.getName().equalsIgnoreCase(((Metric)obj).getName());
            }
            return false;
        }

        @Override
        public int getMinNumSamplesNeededPerClassForCalculation() {
            return this.fMinNumSamplesNeededPerClassForCalculation;
        }
    }
}

