/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ConcurrentModificationException;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.ujmp.core.Matrix;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.interfaces.CanBeUpdated;
import org.ujmp.gui.plot.PlotBackground;
import org.ujmp.gui.plot.PlotSettings;
import org.ujmp.gui.plot.RunningAveragePlot;
import org.ujmp.gui.plot.Selection;
import org.ujmp.gui.plot.Traces;
import org.ujmp.gui.plot.XAxis;
import org.ujmp.gui.plot.XGrid;
import org.ujmp.gui.plot.YAxis;
import org.ujmp.gui.plot.YGrid;
import org.ujmp.gui.plot.ZeroAxis;
import org.ujmp.gui.util.UIDefaults;
import org.ujmp.gui.util.UpdateListener;

public class MatrixPlot
extends JPanel
implements TableCellRenderer,
CanBeUpdated,
ListSelectionListener {
    private static final long serialVersionUID = -3845070497558608841L;
    private EventListenerList listenerList = null;
    private PlotSettings plotSettings = new PlotSettings();
    private XAxis xAxis = new XAxis(this.plotSettings);
    private YAxis yAxis = new YAxis(this.plotSettings);
    private ZeroAxis zeroAxis = new ZeroAxis(this.plotSettings);
    private XGrid xGrid = new XGrid(this.plotSettings);
    private YGrid yGrid = new YGrid(this.plotSettings);
    private Traces traces = null;
    private PlotBackground plotBackground = new PlotBackground(this.plotSettings);
    private Selection selection = null;
    private RunningAveragePlot runningAveragePlot = null;

    public MatrixPlot(Matrix m) {
        this((MatrixGUIObject)m.getGUIObject(), false);
    }

    public MatrixPlot(MatrixGUIObject m, boolean registerListeners) {
        this();
        this.plotSettings.setMatrixGUIObject(m);
        if (registerListeners) {
            m.getRowSelectionModel().addListSelectionListener(this);
        }
    }

    public MatrixPlot() {
        this.traces = new Traces(this.plotSettings);
        this.selection = new Selection(this.plotSettings);
        this.runningAveragePlot = new RunningAveragePlot(this.plotSettings);
        this.setPreferredSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(50, 50));
    }

    public void addUpdateListener(UpdateListener l) {
        this.getListenerList().add(UpdateListener.class, l);
    }

    public void removeUpdateListener(UpdateListener l) {
        this.getListenerList().remove(UpdateListener.class, l);
    }

    public EventListenerList getListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    public void fireUpdated() {
        if (this.listenerList != null) {
            for (Object o : this.listenerList.getListenerList()) {
                if (!(o instanceof UpdateListener)) continue;
                ((UpdateListener)o).updated();
            }
        }
    }

    public void paintComponent(Graphics g) {
        try {
            super.paintComponent(g);
            MatrixGUIObject guiObject = this.plotSettings.getMatrixGUIObject();
            Graphics2D g2d = (Graphics2D)g;
            g2d.addRenderingHints(UIDefaults.AALIAS);
            if (guiObject == null) {
                return;
            }
            this.plotSettings.setHeight(this.getHeight());
            this.plotSettings.setWidth(this.getWidth());
            this.plotSettings.setMinXValue(0.0);
            this.plotSettings.setMaxXValue(guiObject.getRowCount() - 1);
            this.plotSettings.setMinYValue(-1.0);
            this.plotSettings.setMaxYValue(100.0);
            if (this.plotSettings.isShowPlotBackGround()) {
                this.plotBackground.paintComponent(g);
            }
            if (this.plotSettings.isShowXGrid()) {
                this.xGrid.paintComponent(g);
            }
            if (this.plotSettings.isShowYGrid()) {
                this.yGrid.paintComponent(g);
            }
            if (this.plotSettings.isShowXAxis()) {
                this.xAxis.paintComponent(g);
            }
            if (this.plotSettings.isShowYAxis()) {
                this.yAxis.paintComponent(g);
            }
            if (this.plotSettings.isShowZeroAxis()) {
                this.zeroAxis.paintComponent(g);
            }
            if (this.plotSettings.isShowSelection()) {
                this.selection.paintComponent(g);
            }
            if (this.plotSettings.isShowRunningAverage()) {
                this.runningAveragePlot.paintComponent(g);
            }
            this.traces.paintComponent(g);
        }
        catch (ConcurrentModificationException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof MatrixGUIObject) {
            this.plotSettings.setMatrixGUIObject((MatrixGUIObject)value);
        } else if (value instanceof Matrix) {
            this.plotSettings.setMatrixGUIObject((MatrixGUIObject)((Matrix)value).getGUIObject());
        }
        if (isSelected) {
            this.plotSettings.setPlotBackGroundColor(table.getSelectionBackground());
        } else {
            this.plotSettings.setPlotBackGroundColor(new Color(216, 213, 196));
        }
        return this;
    }

    public PlotSettings getPlotSettings() {
        return this.plotSettings;
    }

    public void valueChanged(ListSelectionEvent e) {
        this.fireUpdated();
    }
}

