/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.math.RandomSeedGenerator;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtools.api.Tool;

public class RandomSeedGenerators {
    private static final Logger klog = LoggerFactory.getLogger(RandomSeedGenerators.class);

    public static RandomSeedGenerator lookup(String seedString, Tool tool) {
        if (StringUtils.isBlank((CharSequence)seedString)) {
            throw new IllegalArgumentException("Random seed should not be blank; must be a long integer value or the string 'timestamp'");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)seedString, (CharSequence)"timestamp")) {
            if (tool == null) {
                return new Timestamp();
            }
            return new Timestamp(tool.getReport().getTimestamp());
        }
        try {
            long seed = Long.parseLong(seedString);
            return new Custom(seed);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid random seed: must be a long integer value or the string 'timestamp'");
        }
    }

    public static RandomSeedGenerator create(Object obj, Tool tool) {
        Long seed;
        if (obj == null || tool == null) {
            throw new IllegalArgumentException("Cannot create generator for empty/blank/null tool or seed object");
        }
        if (obj instanceof Long) {
            seed = (Long)obj;
        } else {
            String s = obj.toString();
            if (StringUtils.isBlank((CharSequence)s)) {
                throw new IllegalArgumentException("Random seed should not be blank; must be a long integer value or the string 'timestamp'");
            }
            if (s.equalsIgnoreCase("timestamp")) {
                return new Timestamp(tool.getReport().getTimestamp());
            }
            try {
                seed = Long.parseLong(s);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid random seed: must be a long integer value or the string 'timestamp'");
            }
        }
        if (klog.isDebugEnabled()) {
            klog.debug("Creating a new seed with long: {}", (Object)obj.toString());
        }
        return new Custom(seed);
    }

    public static class Timestamp
    implements RandomSeedGenerator {
        private Random fRandom;
        private final long timestamp;

        public Timestamp() {
            this(System.currentTimeMillis());
        }

        public Timestamp(long timestamp) {
            this.timestamp = timestamp;
            this.fRandom = new Random(timestamp);
        }

        public String toString() {
            return "timestamp";
        }

        @Override
        public Random getRandom() {
            return this.fRandom;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    public static class Custom
    extends Standard {
        public Custom(long seed) {
            super(seed);
        }
    }

    public static class Standard
    implements RandomSeedGenerator {
        private long fSeed;
        private Random fRandom;

        private Standard(long seed) {
            this.fSeed = seed;
            this.fRandom = new Random(this.fSeed);
        }

        public Standard() {
            this(149L);
        }

        public String toString() {
            return "" + this.fSeed;
        }

        @Override
        public Random getRandom() {
            return this.fRandom;
        }
    }
}

