/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.text;

import java.util.Arrays;
import java.util.Collection;
import org.ujmp.core.listmatrix.DefaultListMatrix;
import org.ujmp.core.text.TextBlock;
import org.ujmp.core.text.TextSentence;
import org.ujmp.core.text.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTextBlock
extends DefaultListMatrix<TextSentence>
implements TextBlock {
    private static final long serialVersionUID = -8988613694606138950L;
    private static int textBlockId = 1;

    public DefaultTextBlock(TextSentence ... textSentences) {
        this((Collection<TextSentence>)Arrays.asList(textSentences));
    }

    public DefaultTextBlock(Collection<TextSentence> textSentences) {
        this.setMetaData("Id", "TextBlock" + textBlockId++);
        this.addAll(textSentences);
    }

    public DefaultTextBlock(String text) {
        this(TextUtil.convertToTextBlockToSentences(text));
    }

    @Override
    public String toJson() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append("  \"Type\": \"Text\",\n");
        sb.append("  \"Id\": ");
        sb.append("\"");
        sb.append(this.getMetaData("_id"));
        sb.append("\",\n");
        sb.append("  \"ArticleUrl\": ");
        sb.append("\"");
        sb.append(this.getMetaData("article_url"));
        sb.append("\",\n");
        sb.append("  \"Sentences\":\n");
        sb.append("  [\n");
        int i = 0;
        for (TextSentence sentence : this) {
            sb.append(sentence.toJson());
            if (i++ >= this.size() - 1) continue;
            sb.append(",\n");
        }
        sb.append("\n  ]\n");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean setTag(String token, String tag) {
        boolean tokenFound = false;
        for (TextSentence sentence : this) {
            boolean tmp = sentence.setTag(token, tag);
            if (tokenFound && tmp) {
                throw new RuntimeException("multiple matching tokens found");
            }
            tokenFound = tmp;
        }
        return tokenFound;
    }
}

