/*
 * Decompiled with CFR 0.152.
 */
package xtools.chip2chip;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.math.StringMatrix;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.reports.RichDataframe;
import edu.mit.broad.genome.reports.api.ReportIndexState;
import edu.mit.broad.genome.reports.api.ToolReport;
import edu.mit.broad.genome.reports.pages.HtmlReportIndexPage;
import edu.mit.broad.genome.reports.web.LinkedFactory;
import edu.mit.broad.vdb.map.Chip2ChipMapper;
import edu.mit.broad.vdb.map.MGeneSetMatrix;
import edu.mit.broad.vdb.map.MappingEtiology;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import xtools.api.AbstractTool;
import xtools.api.ReportBlocks;
import xtools.api.ToolCategory;
import xtools.api.param.BooleanParam;
import xtools.api.param.ChipOptParam;
import xtools.api.param.GeneSetMatrixFormatParam;
import xtools.api.param.GeneSetMatrixMultiChooserParam;
import xtools.api.param.Param;
import xtools.api.param.StringInputParam;

public class Chip2Chip
extends AbstractTool {
    private final GeneSetMatrixMultiChooserParam fGeneSetMatrixParam = new GeneSetMatrixMultiChooserParam("gmx", "Gene sets database (symbols only)", "Gene sets database (symbols only)", true);
    private final BooleanParam fShowEtiology = new BooleanParam("show_etiology", "Output verbose mapping details", "Show the etiology for the features", true, false);
    private final GeneSetMatrixFormatParam fGmFormatParam = new GeneSetMatrixFormatParam(DataFormat.GMT_FORMAT, false);
    private final ChipOptParam fChipTargetParam = new ChipOptParam("chip_target", "Target chip", "The destination chip - into which mappings are converted", true);
    private final StringInputParam fAltDelimParam = new StringInputParam("altDelim", "Alternate delimiter", "Optional alternate delimiter character for gene set names instead of comma", null, false, new char[]{';'}, Param.ADVANCED);
    private final BooleanParam fMakeZippedReportParam = AbstractTool.createZipReportParam(false);

    public static String createHeader() {
        StringBuffer buf = new StringBuffer();
        buf.append("<div id=\"footer\" style=\"width: 905; height: 35\">\n").append("<h3 style=\"text-align: left\"><font color=\"#808080\">Chip2Chip Report").append("</font></h3>\n").append("</div>");
        return buf.toString();
    }

    private static void doMapping(Chip2ChipMapper mapper, GeneSetMatrix gm_to_map, boolean showEtiology, GeneSetMatrixFormatParam fGmFormatParam, ToolReport report) throws Exception {
        ReportBlocks.SimpleBlockListing list_etiology = null;
        StringDataframe summaryTable = null;
        RichDataframe summaryTableRich = null;
        MGeneSetMatrix mgm = mapper.map(gm_to_map, showEtiology);
        if (showEtiology) {
            list_etiology = new ReportBlocks.SimpleBlockListing("Mapping details", report);
            MappingEtiology[] mes = mgm.getEtiologies();
            File[] files = new File[mes.length];
            for (int m = 0; m < mes.length; ++m) {
                String desc = "Mapping details for " + gm_to_map.getGeneSetName(m) + " by " + mapper.getName();
                files[m] = report.savePageTxt(gm_to_map.getGeneSetName(m) + "_" + mapper.getName() + "_etiology", desc, mes[m].getStory(), true, false);
            }
            String[] colNames = new String[]{"#SIZE BEFORE MAPPING", "#SIZE AFTER MAPPING", "#SOURCE MEMBERS THAT HAD ONE OR MORE MATCHES", "DETAILS"};
            String[] rowNames = new String[gm_to_map.getNumGeneSets()];
            StringMatrix sm = new StringMatrix(rowNames.length, colNames.length);
            TIntObjectHashMap cell_id_linkMap = new TIntObjectHashMap();
            for (int r = 0; r < gm_to_map.getNumGeneSets(); ++r) {
                rowNames[r] = gm_to_map.getGeneSetName(r);
                sm.setElement(r, 0, gm_to_map.getGeneSet(r).getNumMembers());
                sm.setElement(r, 1, mgm.getMappedGeneSet(r).getMappedGeneSet(true).getNumMembers());
                sm.setElement(r, 2, mgm.getMappedGeneSet(r).getEtiology().getTotalNumOfSourceMembersActuallyMapped());
                sm.setElement(r, 3, "Details >>");
                cell_id_linkMap.put(sm.getElementPos(r, 3), (Object)new LinkedFactory.SimpleLinkedFile("Details>>", files[r]));
            }
            summaryTable = new StringDataframe(mapper.getName(), sm, rowNames, colNames);
            summaryTableRich = new RichDataframe(summaryTable, null, null, cell_id_linkMap);
        }
        GeneSetMatrix mapped_gm = Chip2ChipMapper.createCombinedGeneSetMatrix(NamingConventions.removeExtension(gm_to_map.getName()) + "_mapped_to_" + mapper.getTargetChip().getName(), mgm);
        File gm_file = report.savePage(mapped_gm, fGmFormatParam);
        ReportBlocks.SimpleBlockListing list = new ReportBlocks.SimpleBlockListing("The following " + gm_to_map.getNumGeneSets() + " gene sets were mapped. <br>The results are in this gmt file", report);
        list.add(gm_file.getName(), gm_file);
        list.close();
        if (list_etiology != null) {
            list_etiology.close();
        }
        HtmlReportIndexPage htmlPageHtml = report.getIndexPage();
        if (showEtiology) {
            File tsvFile = report.savePageTsv(summaryTable);
            htmlPageHtml.addTable(summaryTableRich, tsvFile.getName(), true);
        }
        report.getIndexPage().setAddBrowseFooter(false);
    }

    public Chip2Chip(Properties properties) {
        super.init(properties, "");
    }

    public Chip2Chip(Properties properties, String paramFilePath) {
        super.init(properties, paramFilePath);
    }

    public Chip2Chip(String[] args) {
        super.init(args);
    }

    public Chip2Chip() {
        this.declareParams();
    }

    @Override
    public String getName() {
        return "Chip2Chip";
    }

    @Override
    public void execute() throws Exception {
        ReportIndexState state = new ReportIndexState(true, false, true, Chip2Chip.createHeader());
        this.startExec(state);
        if (this.fAltDelimParam.isSpecified() && StringUtils.isNotBlank((CharSequence)this.fAltDelimParam.getValue().toString())) {
            this.fGeneSetMatrixParam.setAlternateDelimiter(this.fAltDelimParam.getValue().toString());
        }
        GeneSetMatrix gm = this.fGeneSetMatrixParam.getGeneSetMatrixCombo();
        Chip2ChipMapper mapper = new Chip2ChipMapper(this.fChipTargetParam.getChip());
        Chip2Chip.doMapping(mapper, gm, this.fShowEtiology.isTrue(), this.fGmFormatParam, this.fReport);
        if (this.fMakeZippedReportParam.isTrue()) {
            this.fReport.closeReport(true);
            this.fReport.zipReport();
        }
        this.doneExec();
    }

    @Override
    public String getDesc() {
        return "Map probe sets between chip platforms";
    }

    @Override
    public void declareParams() {
        this.fParamSet.addParam(this.fGeneSetMatrixParam);
        this.fParamSet.addParam(this.fGmFormatParam);
        this.fParamSet.addParam(this.fShowEtiology);
        this.fParamSet.addParam(this.fChipTargetParam);
        this.fParamSet.addParam(this.fAltDelimParam);
        this.fParamSet.addParam(this.fMakeZippedReportParam);
    }

    @Override
    public ToolCategory getCategory() {
        return ToolCategory.MAPPING_TOOLS;
    }

    public static void main(String[] args) {
        Chip2Chip tool = new Chip2Chip(args);
        Chip2Chip.tool_main(tool);
    }
}

