/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.collections.map;

import java.util.Map;
import java.util.Set;
import org.ujmp.core.collections.map.AbstractMap;
import org.ujmp.core.util.CompressionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GZIPCompressionMap
extends AbstractMap<String, byte[]> {
    private static final long serialVersionUID = -2554468174079653400L;
    private final Map<String, byte[]> map;

    public GZIPCompressionMap(Map<String, byte[]> map) {
        this.map = map;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public byte[] get(Object key) {
        try {
            byte[] data = this.map.get(key);
            return data == null ? null : CompressionUtil.gzipDecompress(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public byte[] put(String key, byte[] value) {
        byte[] oldValue = this.get(key);
        this.map.put(key, CompressionUtil.gzipCompress(value));
        return oldValue;
    }

    @Override
    public byte[] remove(Object key) {
        byte[] oldValue = this.get(key);
        this.map.remove(key);
        return oldValue;
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

