/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.terrain;

import javax.vecmath.Tuple2f;
import javax.vecmath.Vector2f;
import org.tigr.microarray.mev.cluster.algorithm.impl.terrain.InterfaceToObjects;
import org.tigr.microarray.mev.cluster.algorithm.impl.terrain.RectDT;
import org.tigr.microarray.mev.cluster.algorithm.impl.util.IntArray;

public class QuadTreeT {
    public SNode[] m_arrNodes;
    private InterfaceToObjects m_rInterface;
    private static final int c_iMaxQuadTreeTDepth = 15;
    public static final int LEFT_UP = 1;
    public static final int RIGHT_UP = 2;
    public static final int LEFT_DOWN = 3;
    public static final int RIGHT_DOWN = 4;

    private int GetLinearSize(int n) {
        return (int)((Math.pow(4.0, n) - 1.0) / 3.0 + 0.5);
    }

    private void Clear() {
        int n = this.m_arrNodes.length;
        for (int i = 0; i < n; ++i) {
            this.m_arrNodes[i].Destroy();
        }
    }

    private void SetNode(int n, int[] nArray) {
        if (nArray.length <= 0) {
            return;
        }
        int n2 = nArray.length;
        Vector2f vector2f = new Vector2f();
        Vector2f vector2f2 = new Vector2f();
        Vector2f vector2f3 = new Vector2f();
        Vector2f vector2f4 = new Vector2f();
        RectDT rectDT = new RectDT();
        rectDT.MakeEmpty();
        for (int i = 0; i < n2; ++i) {
            this.m_rInterface.GetObjectGeom(nArray[i], vector2f4);
            vector2f3.x = vector2f4.x;
            vector2f3.y = vector2f4.y;
            rectDT.IncludePoint(vector2f3);
            vector2f.add((Tuple2f)vector2f3);
        }
        vector2f2.set((Tuple2f)vector2f);
        vector2f2.scale(1.0f / (float)n2);
        Vector2f vector2f5 = new Vector2f((rectDT.m_Right + rectDT.m_Left) / 2.0f, (rectDT.m_Bottom + rectDT.m_Top) / 2.0f);
        this.m_arrNodes[n].m_ptMid.set((Tuple2f)vector2f2);
        this.m_arrNodes[n].m_ptAvg.set((Tuple2f)vector2f2);
        this.m_arrNodes[n].m_Rect.set(rectDT);
        this.m_arrNodes[n].m_iPointNumBehind = n2;
        int n3 = this.GetChild(n, 1);
        if (n3 < 0 || n2 == 1) {
            this.m_arrNodes[n].SetLeaf();
            this.m_arrNodes[n].m_arrPointsIds = nArray;
            return;
        }
        IntArray intArray = new IntArray();
        IntArray intArray2 = new IntArray();
        IntArray intArray3 = new IntArray();
        IntArray intArray4 = new IntArray();
        for (int i = 0; i < n2; ++i) {
            this.m_rInterface.GetObjectGeom(nArray[i], vector2f4);
            vector2f3.set((Tuple2f)vector2f4);
            if (vector2f3.x <= vector2f5.x) {
                if (vector2f3.y <= vector2f5.y) {
                    intArray.add(nArray[i]);
                    continue;
                }
                intArray3.add(nArray[i]);
                continue;
            }
            if (vector2f3.y <= vector2f5.y) {
                intArray2.add(nArray[i]);
                continue;
            }
            intArray4.add(nArray[i]);
        }
        this.SetNode(n3, intArray.toArray());
        intArray = null;
        n3 = this.GetChild(n, 2);
        this.SetNode(n3, intArray2.toArray());
        intArray2 = null;
        n3 = this.GetChild(n, 3);
        this.SetNode(n3, intArray3.toArray());
        intArray3 = null;
        n3 = this.GetChild(n, 4);
        this.SetNode(n3, intArray4.toArray());
        intArray4 = null;
    }

    QuadTreeT(int n, InterfaceToObjects interfaceToObjects) {
        if (n > 15) {
            throw new IllegalArgumentException("The tree depth can't be more than 15");
        }
        this.m_rInterface = interfaceToObjects;
        int n2 = this.GetLinearSize(n);
        this.m_arrNodes = new SNode[n2];
        for (int i = 0; i < this.m_arrNodes.length; ++i) {
            this.m_arrNodes[i] = new SNode();
        }
    }

    void Initialize() {
        this.Clear();
        int[] nArray = this.m_rInterface.GetAllObjectsIds();
        this.SetNode(0, nArray);
    }

    int GetParent(int n) {
        return n > 0 ? n >> 2 : 0;
    }

    int GetChild(int n, int n2) {
        int n3 = (n << 2) + n2;
        if (n3 < 0 || n3 >= this.m_arrNodes.length) {
            n3 = -1;
        }
        return n3;
    }

    public static class SNode {
        Vector2f m_ptMid = new Vector2f();
        Vector2f m_ptAvg = new Vector2f();
        public RectDT m_Rect = new RectDT();
        int m_iPointNumBehind;
        int[] m_arrPointsIds;

        public SNode() {
            this.Destroy();
        }

        public void Destroy() {
            this.m_arrPointsIds = null;
            this.m_ptMid.set(Float.MAX_VALUE, Float.MAX_VALUE);
            this.m_iPointNumBehind = 0;
        }

        public void Init(Vector2f vector2f) {
            this.Destroy();
            this.m_ptMid.set((Tuple2f)vector2f);
        }

        public void Init(int[] nArray) {
            this.Destroy();
            this.m_arrPointsIds = nArray;
        }

        public boolean IsLeaf() {
            return this.m_ptMid.x == Float.MAX_VALUE && this.m_ptMid.y == Float.MAX_VALUE;
        }

        public void SetLeaf() {
            this.m_ptMid.set(Float.MAX_VALUE, Float.MAX_VALUE);
        }
    }
}

