/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.filematrix;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.ujmp.core.filematrix.FileOrDirectoryMatrix;
import org.ujmp.core.filematrix.ZipEntryMatrix;
import org.ujmp.core.listmatrix.AbstractListMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFileMatrix
extends AbstractListMatrix<ZipEntryMatrix>
implements FileOrDirectoryMatrix {
    private static final long serialVersionUID = -6214617583866869896L;
    private final ZipFile zipFile;
    private final List<ZipEntryMatrix> list = new ArrayList<ZipEntryMatrix>();

    public ZipFileMatrix(File file) throws ZipException, IOException {
        this.zipFile = new ZipFile(file, Charset.forName("Cp437"));
        this.setLabel(this.zipFile.getName());
        this.setMetaData("Comment", this.zipFile.getComment());
    }

    @Override
    public ZipEntryMatrix get(int index) {
        this.ensureData();
        return this.list.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureData() {
        if (this.list.isEmpty()) {
            List<ZipEntryMatrix> list = this.list;
            synchronized (list) {
                if (this.list.isEmpty()) {
                    Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry zipEntry = enumeration.nextElement();
                        this.list.add(new ZipEntryMatrix(this.zipFile, zipEntry));
                    }
                }
            }
        }
    }

    @Override
    public boolean addToList(ZipEntryMatrix t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToList(int index, ZipEntryMatrix element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ZipEntryMatrix removeFromList(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeFromList(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ZipEntryMatrix setToList(int index, ZipEntryMatrix element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        this.ensureData();
        return this.list.size();
    }
}

