/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects.strucs;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.math.DatasetModed;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.strucs.FdrStruc;

public class SkewCorrectedFdrStruc
implements FdrStruc {
    private String name;
    private float nominalP;
    private float realScore;
    private float realScoreNorm;
    private float fdr;
    private int totRealCnt;
    private int totRndCnt;
    private int moreRealThan;
    public int numSetsUsed;
    private float numr;
    private float denr;
    private int moreRndThan;
    public int totRndCnt_used;

    public SkewCorrectedFdrStruc(String name, float real_score_of_name, RankedList all_real_scores_norm_sorted, Vector rnd_scores_of_name_only, DatasetModed all_rnd_scores_norm_by_col_pos, DatasetModed all_rnd_scores_norm_by_col_neg, boolean doPos) {
        if (rnd_scores_of_name_only == null) {
            throw new IllegalArgumentException("Param rnd_scores_of_name_only cannot be null");
        }
        if (all_rnd_scores_norm_by_col_pos == null) {
            throw new IllegalArgumentException("Param all_rnd_scores_norm_by_col_pos cannot be null");
        }
        if (all_rnd_scores_norm_by_col_neg == null) {
            throw new IllegalArgumentException("Param all_rnd_scores_norm_by_col_neg cannot be null");
        }
        if (all_rnd_scores_norm_by_col_pos.getNumCol() != all_rnd_scores_norm_by_col_neg.getNumCol()) {
            throw new MismatchedSizeException("num_cols pos", all_rnd_scores_norm_by_col_pos.getNumCol(), "num cols neg", all_rnd_scores_norm_by_col_neg.getNumCol());
        }
        if (rnd_scores_of_name_only.getSize() != all_rnd_scores_norm_by_col_pos.getNumCol()) {
            throw new MismatchedSizeException("calc_all", rnd_scores_of_name_only.getSize(), "num_col", all_rnd_scores_norm_by_col_pos.getNumCol());
        }
        if (rnd_scores_of_name_only.getSize() != all_rnd_scores_norm_by_col_neg.getNumCol()) {
            throw new MismatchedSizeException("calc_all", rnd_scores_of_name_only.getSize(), "num_col", all_rnd_scores_norm_by_col_neg.getNumCol());
        }
        float real_score_norm_of_name = all_real_scores_norm_sorted.getScore(name);
        boolean pos = XMath.isPositive(real_score_of_name);
        float nominalP = pos ? (float)XMath.getPValue(real_score_of_name, rnd_scores_of_name_only) : (float)XMath.getPValueLessThan(real_score_of_name, rnd_scores_of_name_only);
        int moreRealThan = all_real_scores_norm_sorted.getRank(name) + 1;
        int totalRealCnt = all_real_scores_norm_sorted.getSize();
        float ncols = all_rnd_scores_norm_by_col_pos.getNumCol();
        float col_mean_sum = 0.0f;
        int totalRndCnt_used = 0;
        int moreRndThan = 0;
        int ncols_actual = 0;
        int c = 0;
        while ((float)c < ncols) {
            float moreOrLessThan;
            float size;
            Vector rndColNorm_sorted;
            if (pos) {
                rndColNorm_sorted = all_rnd_scores_norm_by_col_pos.getColumn_sorted(c);
                size = rndColNorm_sorted.getSize();
                moreOrLessThan = XMath.getMoreThanCount(real_score_norm_of_name, rndColNorm_sorted);
            } else {
                rndColNorm_sorted = all_rnd_scores_norm_by_col_neg.getColumn_sorted(c);
                size = rndColNorm_sorted.getSize();
                moreOrLessThan = XMath.getLessThanCount(real_score_norm_of_name, rndColNorm_sorted);
            }
            totalRndCnt_used = (int)((float)totalRndCnt_used + size);
            moreRndThan = (int)((float)moreRndThan + moreOrLessThan);
            if (size != 0.0f) {
                float col_mean = moreOrLessThan / size;
                if (Float.isNaN(col_mean)) {
                    System.out.println("col_mean: " + col_mean + " moreOrLessThan: " + moreOrLessThan + " size: " + size + " pos: " + pos);
                    throw new IllegalArgumentException();
                }
                col_mean_sum += col_mean;
                ++ncols_actual;
            }
            ++c;
        }
        float numr = col_mean_sum / (float)ncols_actual;
        float numSets = pos ? (float)all_real_scores_norm_sorted.getSize(ScoreMode.POS_ONLY) : (float)all_real_scores_norm_sorted.getSize(ScoreMode.NEG_ONLY);
        float denr = (float)moreRealThan / numSets;
        float fdrcalc = numr / denr;
        if (!doPos || !pos) {
            if (doPos && !pos) {
                fdrcalc = 1.0f;
            } else if (pos) {
                fdrcalc = 1.0f;
            }
        }
        this.init(name, real_score_of_name, real_score_norm_of_name, nominalP, (int)numSets, moreRealThan, moreRndThan, totalRealCnt, totalRndCnt_used, all_rnd_scores_norm_by_col_pos.getDim_orig(), fdrcalc, numr, denr);
    }

    private void init(String name, float real_score, float real_score_norm, float nominalP, int numSetsUsed, int moreRealThan, int moreRndThan, int totRealCnt, int totRndCnt_used, int totRndCnt, float fdr, float numr, float denr) {
        this.name = name;
        this.realScore = real_score;
        this.realScoreNorm = real_score_norm;
        this.moreRealThan = moreRealThan;
        this.nominalP = nominalP;
        this.totRealCnt = totRealCnt;
        this.totRndCnt = totRndCnt;
        this.fdr = fdr;
        this.moreRndThan = moreRndThan;
        this.totRndCnt_used = totRndCnt_used;
        this.numSetsUsed = numSetsUsed;
        this.denr = denr;
        this.numr = numr;
    }

    @Override
    public float getRealScore() {
        return this.realScore;
    }

    @Override
    public float getFdr() {
        return this.fdr;
    }
}

