/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.CoordinateIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCalculation
implements Calculation {
    private static final long serialVersionUID = -36063772015381070L;
    private final Matrix[] sources;
    private int dimension = -1;
    private MapMatrix<String, Object> annotation = null;

    public AbstractCalculation(Matrix ... sources) {
        this.sources = sources;
        this.annotation = sources.length == 0 ? null : sources[0].getMetaData();
    }

    public AbstractCalculation(int dimension, Matrix ... sources) {
        this.sources = sources;
        this.annotation = sources.length == 0 ? null : sources[0].getMetaData();
        this.dimension = dimension;
    }

    @Override
    public void setMetaData(MapMatrix<String, Object> annotation) {
        this.annotation = annotation;
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        return new CoordinateIterator(this.getSize());
    }

    @Override
    public boolean containsCoordinates(long ... coordinates) {
        return Coordinates.isSmallerThan(coordinates, this.getSize());
    }

    @Override
    public MapMatrix<String, Object> getMetaData() {
        return this.annotation;
    }

    @Override
    public final Matrix getSource() {
        return this.sources[0];
    }

    @Override
    public final Matrix[] getSources() {
        return this.sources;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public long[] getSize() {
        return this.getSource().getSize();
    }

    @Override
    public long getRowCount() {
        return this.getSource().getRowCount();
    }

    @Override
    public long getColumnCount() {
        return this.getSource().getColumnCount();
    }

    @Override
    public final Matrix calc(Calculation.Ret returnType) {
        switch (returnType) {
            case ORIG: {
                return this.calcOrig();
            }
            case LINK: {
                return this.calcLink();
            }
        }
        return this.calcNew();
    }
}

