/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jdbc.map;

import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.ujmp.core.interfaces.Erasable;
import org.ujmp.core.mapmatrix.AbstractMapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.jdbc.autoclose.AutoOpenCloseConnection;
import org.ujmp.jdbc.util.JDBCKeySet;
import org.ujmp.jdbc.util.SQLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCMapMatrix<K, V>
extends AbstractMapMatrix<K, V>
implements Closeable,
Erasable,
Flushable {
    private static final long serialVersionUID = 4744307432617930795L;
    private boolean tableExists;
    private transient Connection connection;
    private transient ResultSet resultSet = null;
    private transient PreparedStatement truncateTableStatement = null;
    private transient PreparedStatement insertStatement = null;
    private transient PreparedStatement updateStatement = null;
    private transient PreparedStatement deleteStatement = null;
    private transient PreparedStatement selectByKeyStatement = null;
    private transient PreparedStatement containsKeyStatement = null;
    private transient PreparedStatement containsValueStatement = null;
    private transient PreparedStatement keyStatement = null;
    private transient PreparedStatement dropTableStatement = null;
    private transient PreparedStatement countStatement = null;

    private JDBCMapMatrix(String url, String username, String password, String tableName, String keyColumnName, String valueColumnName) throws SQLException {
        this(new AutoOpenCloseConnection(url, username, password), tableName, keyColumnName, valueColumnName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JDBCMapMatrix(Connection connection, String tableName, String keyColumnName, String valueColumnName) throws SQLException {
        this.connection = connection;
        String url = connection.getMetaData().getURL();
        this.setMetaData("URL", url);
        this.setMetaData("SQLDialect", (Object)SQLUtil.getSQLDialect(url));
        this.setMetaData("DatabaseName", SQLUtil.getDatabaseName(url));
        this.setMetaData("TableName", tableName == null ? "ujmp_map_" + UUID.randomUUID() : tableName);
        this.setLabel(this.getTableName());
        this.tableExists = SQLUtil.tableExists(connection, this.getTableName());
        if (!this.tableExists) {
            if (keyColumnName == null || keyColumnName.isEmpty()) {
                this.setMetaData("KeyColumnName", "id");
                this.setColumnLabel(0L, "id");
            } else {
                this.setMetaData("KeyColumnName", keyColumnName);
                this.setColumnLabel(0L, keyColumnName);
            }
            if (valueColumnName == null || valueColumnName.isEmpty()) {
                this.setMetaData("ValueColumnName", "data");
                this.setColumnLabel(1L, "data");
            } else {
                this.setMetaData("ValueColumnName", valueColumnName);
                this.setColumnLabel(1L, valueColumnName);
            }
            this.createTable(this.getTableName(), this.getKeyColumnName(), this.getValueColumnName());
            return;
        } else {
            if (keyColumnName == null || keyColumnName.isEmpty()) {
                List<String> keyColumnNames = SQLUtil.getPrimaryKeyColumnNames(connection, this.getTableName());
                if (keyColumnNames.size() != 1) throw new RuntimeException("cannot determine id column");
                this.setMetaData("KeyColumnName", keyColumnNames.get(0));
                this.setColumnLabel(0L, keyColumnNames.get(0));
            } else {
                this.setMetaData("KeyColumnName", keyColumnName);
                this.setColumnLabel(0L, keyColumnName);
            }
            if (valueColumnName == null || valueColumnName.isEmpty()) {
                List<String> columnNames = SQLUtil.getColumnNames(connection, this.getTableName());
                columnNames.remove(keyColumnName);
                if (columnNames.size() == 1) {
                    this.setMetaData("ValueColumnName", columnNames.get(0));
                    this.setColumnLabel(1L, columnNames.get(0));
                    return;
                } else {
                    List<String> keyColumnNames = SQLUtil.getPrimaryKeyColumnNames(connection, this.getTableName());
                    columnNames.removeAll(keyColumnNames);
                    if (columnNames.size() != 1) throw new RuntimeException("cannot determine data column");
                    this.setMetaData("ValueColumnName", columnNames.get(0));
                    this.setColumnLabel(1L, columnNames.get(0));
                }
                return;
            } else {
                this.setMetaData("ValueColumnName", valueColumnName);
                this.setColumnLabel(1L, valueColumnName);
            }
        }
    }

    public final Connection getConnection() {
        return this.connection;
    }

    public final String getURL() {
        return this.getMetaDataString("URL");
    }

    public final String getTableName() {
        return this.getMetaDataString("TableName");
    }

    public final String getDatabaseName() {
        return this.getMetaDataString("DatabaseName");
    }

    public final Class<?> getKeyClass() {
        return (Class)this.getMetaData("KeyClass");
    }

    public final Class<?> getValueClass() {
        return (Class)this.getMetaData("ValueClass");
    }

    public final String getKeyColumnName() {
        return this.getMetaDataString("KeyColumnName");
    }

    public final String getValueColumnName() {
        return this.getMetaDataString("ValueColumnName");
    }

    public final SQLUtil.SQLDialect getSQLDialect() {
        Object sqlDialect = this.getMetaData("SQLDialect");
        if (sqlDialect instanceof SQLUtil.SQLDialect) {
            return (SQLUtil.SQLDialect)((Object)this.getMetaData("SQLDialect"));
        }
        return null;
    }

    @Override
    protected final synchronized void clearMap() {
        if (!this.tableExists) {
            return;
        }
        try {
            if (this.truncateTableStatement == null || this.truncateTableStatement.isClosed()) {
                this.truncateTableStatement = SQLUtil.getTruncateTableStatement(this.connection, this.getSQLDialect(), this.getTableName());
                if (this.resultSet != null && !this.resultSet.isClosed()) {
                    this.resultSet.close();
                }
                this.truncateTableStatement.executeUpdate();
                this.truncateTableStatement.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final synchronized Set<K> keySet() {
        if (!this.tableExists) {
            return Collections.emptySet();
        }
        try {
            if (this.keyStatement == null || this.keyStatement.isClosed()) {
                this.keyStatement = SQLUtil.getSelectIdsStatement(this.connection, this.getSQLDialect(), this.getTableName(), this.getKeyColumnName());
            }
            if (this.resultSet != null && !this.resultSet.isClosed()) {
                this.resultSet.close();
            }
            this.resultSet = this.keyStatement.executeQuery();
            return new JDBCKeySet(this, this.resultSet, this.getKeyClass());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected final synchronized V removeFromMap(Object key) {
        if (key == null) {
            throw new RuntimeException("key cannot be null");
        }
        if (!this.tableExists) {
            return null;
        }
        try {
            V oldValue = this.get(key);
            if (oldValue != null) {
                if (this.deleteStatement == null || this.deleteStatement.isClosed()) {
                    this.deleteStatement = SQLUtil.getDeleteIdStatement(this.connection, this.getSQLDialect(), this.getTableName(), this.getKeyColumnName());
                }
                this.deleteStatement.setObject(1, key);
                this.deleteStatement.executeUpdate();
            }
            return oldValue;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final synchronized void close() throws IOException {
        try {
            if (this.connection == null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public final synchronized void erase() throws IOException {
        if (!this.tableExists) {
            return;
        }
        try {
            if (this.dropTableStatement == null || this.dropTableStatement.isClosed()) {
                this.dropTableStatement = SQLUtil.getDropTableStatement(this.connection, this.getSQLDialect(), this.getTableName());
                this.dropTableStatement.executeUpdate();
                this.dropTableStatement.close();
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected final synchronized V putIntoMap(K key, V value) {
        if (key == null) {
            throw new RuntimeException("key cannot be null");
        }
        if (this.getKeyClass() == null) {
            this.setMetaData("KeyClass", key.getClass());
        }
        if (this.getValueClass() == null && value != null) {
            this.setMetaData("ValueClass", value.getClass());
        }
        try {
            V oldValue = this.get(key);
            if (oldValue == null) {
                if (this.insertStatement == null || this.insertStatement.isClosed()) {
                    this.insertStatement = SQLUtil.getInsertKeyValueStatement(this.connection, this.getSQLDialect(), this.getTableName(), this.getKeyColumnName(), this.getValueColumnName());
                }
                this.insertStatement.setObject(1, key);
                this.insertStatement.setObject(2, value);
                this.insertStatement.executeUpdate();
            } else if (!oldValue.equals(value)) {
                if (this.updateStatement == null || this.updateStatement.isClosed()) {
                    this.updateStatement = SQLUtil.getUpdateKeyValueStatement(this.connection, this.getSQLDialect(), this.getTableName(), this.getKeyColumnName(), this.getValueColumnName());
                }
                this.updateStatement.setObject(1, value);
                this.updateStatement.setObject(2, key);
                this.updateStatement.executeUpdate();
            }
            return oldValue;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final synchronized V get(Object key) {
        if (key == null) {
            throw new RuntimeException("key cannot be null");
        }
        if (!this.tableExists) {
            return null;
        }
        if (this.getKeyClass() == null && key != null) {
            this.setMetaData("KeyClass", key.getClass());
        }
        try {
            if (this.selectByKeyStatement == null || this.selectByKeyStatement.isClosed()) {
                this.selectByKeyStatement = SQLUtil.getValueForKeyStatement(this.connection, this.getSQLDialect(), this.getTableName(), this.getKeyColumnName(), this.getValueColumnName());
            }
            this.selectByKeyStatement.setObject(1, key);
            if (this.resultSet != null && !this.resultSet.isClosed()) {
                this.resultSet.close();
            }
            this.resultSet = this.selectByKeyStatement.executeQuery();
            Object value = null;
            if (this.resultSet.next()) {
                value = SQLUtil.getObject(this.resultSet, 1, this.getValueClass());
            }
            this.resultSet.close();
            if (this.getValueClass() == null && value != null) {
                this.setMetaData("ValueClass", value.getClass());
            }
            return (V)value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final synchronized boolean containsKey(Object key) {
        if (key == null) {
            throw new RuntimeException("key cannot be null");
        }
        if (!this.tableExists) {
            return false;
        }
        try {
            if (this.containsKeyStatement == null || this.containsKeyStatement.isClosed()) {
                this.containsKeyStatement = SQLUtil.getExistsStatement(this.connection, this.getSQLDialect(), this.getTableName(), this.getKeyColumnName());
            }
            this.containsKeyStatement.setObject(1, key);
            if (this.resultSet != null && !this.resultSet.isClosed()) {
                this.resultSet.close();
            }
            this.resultSet = this.containsKeyStatement.executeQuery();
            boolean containsKey = false;
            if (this.resultSet.next()) {
                containsKey = MathUtil.getBoolean(this.resultSet.getObject(1));
            }
            this.resultSet.close();
            return containsKey;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final synchronized boolean containsValue(Object value) {
        if (value == null) {
            throw new RuntimeException("value cannot be null");
        }
        if (!this.tableExists) {
            return false;
        }
        try {
            if (this.containsValueStatement == null || this.containsValueStatement.isClosed()) {
                this.containsValueStatement = SQLUtil.getExistsStatement(this.connection, this.getSQLDialect(), this.getTableName(), this.getValueColumnName());
            }
            this.containsValueStatement.setObject(1, value);
            if (this.resultSet != null && !this.resultSet.isClosed()) {
                this.resultSet.close();
            }
            this.resultSet = this.containsValueStatement.executeQuery();
            boolean containsValue = false;
            if (this.resultSet.next()) {
                containsValue = MathUtil.getBoolean(this.resultSet.getObject(1));
            }
            this.resultSet.close();
            return containsValue;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void beforeWriteObject(ObjectOutputStream os) throws IOException {
        try {
            os.writeObject((Object)this.getSQLDialect());
            os.writeUTF(this.getDatabaseName());
            os.writeUTF(this.getTableName());
            os.writeUTF(this.getKeyColumnName());
            os.writeUTF(this.getValueColumnName());
            os.writeUTF(this.connection.getMetaData().getURL());
            if (this.connection.getMetaData().getUserName() != null) {
                os.writeBoolean(true);
                os.writeUTF(this.connection.getMetaData().getUserName());
            } else {
                os.writeBoolean(false);
            }
            if (this.connection.getClientInfo("Password") != null) {
                os.writeBoolean(true);
                os.writeUTF(this.connection.getClientInfo("Password"));
            } else {
                os.writeBoolean(false);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    protected void beforeReadObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.setMetaData("SQLDialect", (Object)((SQLUtil.SQLDialect)((Object)is.readObject())));
        this.setMetaData("DatabaseName", is.readUTF());
        this.setMetaData("TableName", is.readUTF());
        this.setMetaData("KeyColumnName", is.readUTF());
        this.setMetaData("ValueColumnName", is.readUTF());
        String url = is.readUTF();
        this.setMetaData("URL", url);
        boolean containsUsername = is.readBoolean();
        String username = null;
        if (containsUsername) {
            username = is.readUTF();
        }
        boolean containsPassword = is.readBoolean();
        String password = null;
        if (containsPassword) {
            password = is.readUTF();
        }
        this.connection = new AutoOpenCloseConnection(url, username, password);
    }

    @Override
    public synchronized void flush() throws IOException {
        try {
            switch (this.getSQLDialect()) {
                case H2: {
                    break;
                }
                case HSQLDB: {
                    break;
                }
            }
            this.getConnection().commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final synchronized int size() {
        try {
            if (!this.tableExists) {
                return 0;
            }
            if (this.countStatement == null || this.countStatement.isClosed()) {
                this.countStatement = SQLUtil.getCountStatement(this.connection, this.getSQLDialect(), this.getTableName());
            }
            ResultSet rs = this.countStatement.executeQuery();
            int size = -1;
            if (!rs.next()) {
                throw new RuntimeException("cannot count entries");
            }
            size = rs.getInt(1);
            rs.close();
            return size;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private final synchronized void createTable(String tableName, String keyColumnName, String valueColumnName) throws SQLException {
        SQLUtil.createKeyValueStringTable(this.getConnection(), this.getSQLDialect(), tableName, keyColumnName, valueColumnName);
        this.tableExists = true;
    }

    public static <K, V> JDBCMapMatrix<K, V> connectToMySQL(String serverName, int port, String username, String password, String databaseName, String tableName, String columnForKeys, String columnForValues) throws SQLException {
        return new JDBCMapMatrix<K, V>("jdbc:mysql://" + serverName + ":" + port + "/" + databaseName, username, password, tableName, columnForKeys, columnForValues);
    }

    public static <K, V> JDBCMapMatrix<K, V> connectToMySQL(String serverName, int port, String userName, String password, String databaseName, String tableName) throws SQLException {
        return new JDBCMapMatrix<K, V>("jdbc:mysql://" + serverName + ":" + port + "/" + databaseName, userName, password, tableName, null, null);
    }

    public static <K, V> JDBCMapMatrix<K, V> connectToHSQLDB() throws SQLException, IOException {
        return new JDBCMapMatrix<K, V>("jdbc:hsqldb:file:/" + File.createTempFile("ujmp", "hsqldb.temp"), null, null, null, null, null);
    }

    public static <K, V> JDBCMapMatrix<K, V> connectToSQLite() throws SQLException, IOException {
        return new JDBCMapMatrix<K, V>("jdbc:sqlite:" + File.createTempFile("ujmp", "sqlite.temp"), null, null, null, null, null);
    }

    public static <K, V> JDBCMapMatrix<K, V> connectToDerby() throws SQLException, IOException {
        return new JDBCMapMatrix<K, V>("jdbc:derby:" + new File(System.getProperty("java.io.tmpdir") + File.separator + "ujmp" + System.nanoTime() + "derby.temp"), null, null, null, null, null);
    }

    public static <K, V> JDBCMapMatrix<K, V> connectToHSQLDB(File file) throws SQLException {
        return new JDBCMapMatrix<K, V>("jdbc:hsqldb:file:/" + file.getAbsolutePath(), null, null, null, null, null);
    }

    public static <K, V> JDBCMapMatrix<K, V> connectToH2() throws SQLException, IOException {
        return new JDBCMapMatrix<K, V>("jdbc:h2:" + File.createTempFile("ujmp", "h2.temp"), null, null, null, null, null);
    }

    public static <K, V> JDBCMapMatrix<K, V> connectToH2(File file) throws SQLException {
        return new JDBCMapMatrix<K, V>("jdbc:h2:" + file.getAbsolutePath(), null, null, null, null, null);
    }

    public static <K, V> JDBCMapMatrix<K, V> connectToH2(File file, String tableName) throws SQLException {
        return new JDBCMapMatrix<K, V>("jdbc:h2:" + file.getAbsolutePath(), null, null, tableName, null, null);
    }

    public static <K, V> JDBCMapMatrix<K, V> connectToDerby(File folderName) throws SQLException {
        return new JDBCMapMatrix<K, V>("jdbc:derby:" + folderName.getAbsolutePath() + "/", null, null, null, null, null);
    }

    public static <K, V> JDBCMapMatrix<K, V> connectToDerby(File folderName, String tableName) throws SQLException {
        return new JDBCMapMatrix<K, V>("jdbc:derby:" + folderName.getAbsolutePath() + "/", null, null, tableName, null, null);
    }

    public static <K, V> JDBCMapMatrix<K, V> connectToSQLite(File file) throws SQLException {
        return new JDBCMapMatrix<K, V>("jdbc:sqlite:" + file.getAbsolutePath(), null, null, null, null, null);
    }

    public static <K, V> JDBCMapMatrix<K, V> connectToSQLite(File file, String tableName) throws SQLException {
        return new JDBCMapMatrix<K, V>("jdbc:sqlite:" + file.getAbsolutePath(), null, null, tableName, null, null);
    }

    public static <K, V> JDBCMapMatrix<K, V> connectToHSQLDB(File file, String tableName) throws SQLException {
        return new JDBCMapMatrix<K, V>("jdbc:hsqldb:file:/" + file.getAbsolutePath(), null, null, tableName, null, null);
    }

    public static <K, V> JDBCMapMatrix<K, V> connectToHSQLDB(File file, String userName, String password, String tableName) throws SQLException {
        return new JDBCMapMatrix<K, V>("jdbc:hsqldb:file:/" + file.getAbsolutePath(), userName, password, tableName, null, null);
    }

    public static <K, V> JDBCMapMatrix<K, V> connectToHSQLDB(File file, String userName, String password, String tableName, String keyColumnName, String valueColumnName) throws SQLException {
        return new JDBCMapMatrix<K, V>("jdbc:hsqldb:file:/" + file.getAbsolutePath(), userName, password, tableName, keyColumnName, valueColumnName);
    }

    public static <K, V> JDBCMapMatrix<K, V> connect(String url, String userName, String password, String tableName, String keyColumnName, String valueColumnName) throws SQLException {
        return new JDBCMapMatrix<K, V>(url, userName, password, tableName, keyColumnName, valueColumnName);
    }

    public static <K, V> JDBCMapMatrix<K, V> connect(String url, String userName, String password, String tableName) throws SQLException {
        return new JDBCMapMatrix<K, V>(url, userName, password, tableName, null, null);
    }

    public static <K, V> JDBCMapMatrix<K, V> connect(Connection connection, String tableName, String keyColumnName, String valueColumnName) throws SQLException {
        return new JDBCMapMatrix<K, V>(connection, tableName, keyColumnName, valueColumnName);
    }
}

