/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.ui;

import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import xtools.api.ui.GeneSetMatrixChooserWindow;

public class GeneSetMatrixChooserUI
extends JPanel
implements GFieldPlusChooser {
    protected JTextField tfEntry = new JTextField(40);
    protected JButton bEntry = new JButton(GuiHelper.ICON_ELLIPSIS);
    protected GeneSetMatrixChooserWindow fWindow;

    public GeneSetMatrixChooserUI(boolean addDefaultActionListener) {
        if (addDefaultActionListener) {
            this.init();
        } else {
            this.jbInit();
        }
    }

    public void setCustomActionListener(ActionListener customActionListener) {
        this.bEntry.addActionListener(customActionListener);
    }

    private void init() {
        this.jbInit();
        this.bEntry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] sels = GeneSetMatrixChooserUI.this._window().show();
                GeneSetMatrixChooserUI.this.format(sels);
            }
        });
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.tfEntry.setEditable(true);
        this.add((Component)this.tfEntry, "Center");
        this.add((Component)this.bEntry, "East");
    }

    private void format(Object[] sels) {
        if (sels == null) {
            this.tfEntry.setText("");
            return;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < sels.length; ++i) {
            if (sels[i] == null) continue;
            buf.append(sels[i].toString().trim());
            if (i == sels.length - 1) continue;
            buf.append(',');
        }
        this.tfEntry.setText(buf.toString());
    }

    public String getText() {
        return this.tfEntry.getText();
    }

    public void setText(String text) {
        this.tfEntry.setText(text);
    }

    public JTextField getTextField() {
        return this.tfEntry;
    }

    @Override
    public Object getValue() {
        return this.getText();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public GeneSetMatrixChooserWindow getJListWindow() {
        return this._window();
    }

    private GeneSetMatrixChooserWindow _window() {
        if (this.fWindow == null) {
            this.fWindow = new GeneSetMatrixChooserWindow();
        }
        return this.fWindow;
    }

    @Override
    public void setValue(Object obj) {
        if (obj == null) {
            this.setText(null);
        } else {
            this.setText(obj.toString());
        }
    }
}

