/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.math.Matrix;

public class APMMatrix
extends Matrix {
    public static final String PRESENT_STR = "P";
    public static final String ABSENT_STR = "A";
    public static final String MISSING_STR = "M";
    public static final float PRESENT = 1.0f;
    public static final float ABSENT = 0.0f;
    public static final float MISSING = Float.NaN;

    public APMMatrix(int nrows, int ncols) {
        super(nrows, ncols);
    }

    public char getElement_char(int row, int col) {
        float f = this.getElement(row, col);
        if (f == 1.0f) {
            return PRESENT_STR.toCharArray()[0];
        }
        if (f == 0.0f) {
            return ABSENT_STR.toCharArray()[0];
        }
        if (Float.isNaN(f)) {
            return MISSING_STR.toCharArray()[0];
        }
        throw new IllegalStateException("Unknown value: " + f + " at row: " + row + " col: " + col);
    }

    public static float valueOf(String s) {
        if (s == null) {
            throw new NullPointerException("Null value of param not allowed");
        }
        if (s.equalsIgnoreCase(PRESENT_STR)) {
            return 1.0f;
        }
        if (s.equalsIgnoreCase(ABSENT_STR)) {
            return 0.0f;
        }
        if (s.equalsIgnoreCase(MISSING_STR)) {
            return Float.NaN;
        }
        if (s.equals("0")) {
            return Float.NaN;
        }
        throw new IllegalArgumentException("Unknown AP call value >" + s + "<");
    }
}

