/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSetMatrixHelper;
import edu.mit.broad.genome.parsers.AuxUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractGeneSetMatrix
extends AbstractObject
implements GeneSetMatrix {
    private List fGeneSets;
    private Set fGeneSetNames_nonaux = null;
    private Map fNameGeneSetMap;

    protected AbstractGeneSetMatrix() {
    }

    protected void initMatrix(String name, GeneSet[] gsets) {
        super.initialize(name);
        if (gsets == null) {
            throw new IllegalArgumentException("Param gsets cannot be null");
        }
        HashSet<String> names = new HashSet<String>();
        Errors errors = new Errors();
        this.fGeneSets = new ArrayList(gsets.length);
        for (int i = 0; i < gsets.length; ++i) {
            if (gsets[i] == null) {
                throw new IllegalArgumentException("Null GeneSet not allowed at index: " + i + " total len: " + gsets.length);
            }
            if (names.contains(gsets[i].getName())) {
                errors.add("GeneSets should have unique names. The lookup is case INsensitive. Found duplicate name: " + gsets[i].getName());
            } else {
                names.add(gsets[i].getName());
            }
            this.fGeneSets.add(gsets[i]);
        }
        errors.barfIfNotEmptyRuntime();
    }

    @Override
    public boolean containsSet(String gsetName) {
        if (this.fGeneSetNames_nonaux == null) {
            this.fGeneSetNames_nonaux = new THashSet();
            for (int i = 0; i < this.getNumGeneSets(); ++i) {
                this.fGeneSetNames_nonaux.add(AuxUtils.getAuxNameOnlyNoHash(this.getGeneSet(i).getName()));
            }
        }
        if (this.fGeneSetNames_nonaux.contains(gsetName)) {
            return true;
        }
        return this.fGeneSetNames_nonaux.contains(AuxUtils.getAuxNameOnlyNoHash(gsetName));
    }

    @Override
    public String getQuickInfo() {
        StringBuffer buf = new StringBuffer().append(this.getNumGeneSets()).append(" gene sets");
        return buf.toString();
    }

    @Override
    public int getNumGeneSets() {
        return this.fGeneSets.size();
    }

    @Override
    public GeneSet getGeneSet(int i) {
        return (GeneSet)this.fGeneSets.get(i);
    }

    @Override
    public GeneSet getGeneSet(String gsetnameF) {
        String gsetname = gsetnameF.replace('|', '/');
        gsetname = AuxUtils.getAuxNameOnlyNoHash(gsetnameF);
        gsetname = gsetname.toUpperCase();
        if (this.fNameGeneSetMap == null) {
            this.fNameGeneSetMap = new HashMap(this.getNumGeneSets());
            for (int i = 0; i < this.getNumGeneSets(); ++i) {
                GeneSet gset = this.getGeneSet(i);
                this.fNameGeneSetMap.put(gset.getName().toUpperCase(), gset);
                this.fNameGeneSetMap.put(AuxUtils.getAuxNameOnlyNoHash(gset.getName()).toUpperCase(), gset);
            }
        }
        Object obj = this.fNameGeneSetMap.get(gsetname);
        Object tryharder = null;
        if (obj == null) {
            tryharder = gsetname;
            if (gsetname.indexOf("#") == -1) {
                tryharder = this.getName() + "#" + gsetname;
            }
            obj = this.fNameGeneSetMap.get(tryharder);
        }
        if (obj == null) {
            tryharder = gsetname;
            if (gsetname.indexOf("#") == -1) {
                tryharder = this.getName() + "#" + gsetname;
            }
            if ((obj = this.fNameGeneSetMap.get(tryharder = ((String)tryharder).replace('\\', '/'))) == null) {
                tryharder = gsetname;
                if (gsetname.indexOf("#") == -1) {
                    tryharder = this.getName() + "#" + gsetname;
                }
                tryharder = ((String)tryharder).replace('/', '\\');
                obj = this.fNameGeneSetMap.get(tryharder);
            }
            if (obj == null) {
                tryharder = gsetname.replace('|', '/');
                if (gsetname.indexOf("#") == -1) {
                    tryharder = this.getName() + "#" + gsetname;
                }
                tryharder = ((String)tryharder).replace('/', '\\');
                obj = this.fNameGeneSetMap.get(tryharder);
            }
        }
        if (obj == null) {
            StringBuffer buf = new StringBuffer("In GeneSetMatrix: " + this.getName() + " no GeneSet found with name: " + gsetname);
            buf.append("\nAvailable GeneSets are: \n");
            for (Object key : this.fNameGeneSetMap.keySet()) {
                buf.append(key.toString()).append('\n');
            }
            buf.append("Also tried looking for gset: ").append((String)tryharder);
            throw new IllegalArgumentException(buf.toString());
        }
        return (GeneSet)obj;
    }

    @Override
    public GeneSet[] getGeneSets() {
        return this.fGeneSets.toArray(new GeneSet[this.fGeneSets.size()]);
    }

    @Override
    public List getGeneSetsL() {
        return Collections.unmodifiableList(this.fGeneSets);
    }

    @Override
    public int getMaxGeneSetSize() {
        return GeneSetMatrixHelper.getMaxMemberCount(this.fGeneSets);
    }

    @Override
    public String[] getAllMemberNamesOnlyOnce() {
        return GeneSetMatrixHelper.getAllMemberNames(this.fGeneSets);
    }

    @Override
    public Set getAllMemberNamesOnlyOnceS() {
        return GeneSetMatrixHelper.getAllMemberNamesS(this.fGeneSets);
    }

    @Override
    public String[] getAllMemberNames() {
        return GeneSetMatrixHelper.getAllMemberNameOccurrences(this.fGeneSets);
    }

    @Override
    public String getGeneSetName(int g) {
        return this.getGeneSet(g).getName();
    }
}

