/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;

public abstract class CompressionUtil {
    public static byte[] zipCompress(byte[] input) {
        return CompressionUtil.zipCompress(input, -1);
    }

    public static byte[] zipCompress(byte[] input, int level) {
        Deflater compressor = new Deflater();
        compressor.setLevel(level);
        compressor.setInput(input);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    public static byte[] zipDecompress(byte[] input) throws IOException {
        Inflater inflator = new Inflater();
        inflator.setInput(input);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[1024];
        try {
            try {
                int count;
                while ((count = inflator.inflate(buf)) > 0) {
                    bos.write(buf, 0, count);
                }
                if (count != 0 || !inflator.finished()) {
                    throw new RuntimeException("bad zip data, size:" + input.length);
                }
                Object var6_6 = null;
                inflator.end();
            }
            catch (DataFormatException t) {
                throw new RuntimeException(t);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            inflator.end();
            throw throwable;
        }
        return bos.toByteArray();
    }

    public static byte[] gzipCompress(byte[] input) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            GZIPOutputStream os = new GZIPOutputStream(bos);
            os.write(input);
            os.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bos.toByteArray();
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[1024];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static byte[] gzipDecompress(byte[] input) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(input));
            CompressionUtil.copy(is, out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }
}

