/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.tui;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.reports.api.ToolReport;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.xbench.actions.XDCAction;
import edu.mit.broad.xbench.core.JObjectsList;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.tui.ExecState;
import edu.mit.broad.xbench.tui.SingleToolLauncherAction;
import gnu.trove.TIntObjectHashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtools.api.Tool;
import xtools.api.param.ParamSet;

public class TaskManager {
    private static final Logger klog = LoggerFactory.getLogger(TaskManager.class);
    private static final String[] COL_HEADERS = new String[]{" ", "Name", "Status"};
    private static final int COL_NUM = 0;
    private static final int COL_NAME = 1;
    private static final int COL_STATUS = 2;
    private final Model fModel;
    private JTable fTaskTable;
    private boolean fOnClickShowResultsInBrowserOnly;
    private static TaskManager kInstance;
    private final List<ToolRunnable> fToolRunnables = new ArrayList<ToolRunnable>();
    private static final Icon RESULTS_ICON;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TaskManager getInstance() {
        if (kInstance != null) return kInstance;
        Class<TaskManager> clazz = TaskManager.class;
        synchronized (TaskManager.class) {
            if (kInstance != null) return kInstance;
            kInstance = new TaskManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return kInstance;
        }
    }

    private TaskManager() {
        this.fModel = new Model();
    }

    public void setOnClickShowResultsInBrowserOnly(boolean value) {
        this.fOnClickShowResultsInBrowserOnly = value;
    }

    public Tool run(Tool tool, ParamSet pset, int priority) throws Exception {
        Tool clonedTool;
        if (tool == null) {
            throw new IllegalArgumentException("Param tool cannot be null");
        }
        if (pset == null) {
            throw new IllegalArgumentException("Param pset cannot be null");
        }
        try {
            clonedTool = TaskManager.createTool(tool, pset);
        }
        catch (Exception t) {
            ToolRunnable pstate = ToolRunnable.createParamErrorToolState(tool, pset, t);
            this.fToolRunnables.add(pstate);
            kInstance.updateTable();
            throw t;
        }
        ToolRunnable trunnable = new ToolRunnable(clonedTool);
        this.fToolRunnables.add(trunnable);
        kInstance.updateTable();
        Thread t = new Thread(trunnable);
        t.setPriority(priority);
        trunnable.owner_thread = t;
        t.start();
        klog.debug("Started executing Tool: {} priority: {}", (Object)clonedTool.getClass().getName(), (Object)priority);
        return clonedTool;
    }

    public static Tool createTool(Tool tool, ParamSet pset) throws Exception {
        String toolName = tool.getClass().getName();
        Class<?> toolClass = Class.forName(toolName);
        klog.debug("toolClass: {} pset: {}", toolClass, (Object)pset);
        Class[] initArgsClass = new Class[]{Properties.class};
        Constructor<?> initArgsConstructor = toolClass.getConstructor(initArgsClass);
        klog.debug("{}", initArgsConstructor);
        Properties prp = pset.toProperties();
        prp.remove("help");
        Properties[] initArgs = new Properties[]{prp};
        System.out.println(">> " + prp);
        return (Tool)initArgsConstructor.newInstance(initArgs);
    }

    public static Tool createTool(String toolName) throws Exception {
        Class<?> toolClass = Class.forName(toolName);
        Class[] initArgsClass = new Class[]{};
        Constructor<?> initArgsConstructor = toolClass.getConstructor(initArgsClass);
        return (Tool)initArgsConstructor.newInstance(new Object[0]);
    }

    private void updateTable() {
        this.fModel.fireTableStructureChanged();
        this.fTaskTable.repaint();
        this.fTaskTable.revalidate();
        this.setColNumWidth(this.fTaskTable);
    }

    public JTable createTable() {
        this.fTaskTable = new JTable(this.fModel);
        this.fTaskTable.setRowSelectionAllowed(false);
        this.fTaskTable.setColumnSelectionAllowed(false);
        this.fTaskTable.setSelectionMode(0);
        this.fTaskTable.setShowVerticalLines(true);
        this.fTaskTable.setGridColor(Color.black);
        this.fTaskTable.setAutoResizeMode(2);
        this.fTaskTable.getTableHeader().setReorderingAllowed(false);
        this.fTaskTable.setDefaultRenderer(Object.class, new Renderer());
        Editor ed = new Editor();
        this.fTaskTable.setDefaultEditor(Object.class, ed);
        this.setColNumWidth(this.fTaskTable);
        return this.fTaskTable;
    }

    private void setColNumWidth(JTable table) {
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setMinWidth(0);
        column.setMaxWidth(20);
        column.setPreferredWidth(20);
    }

    static {
        RESULTS_ICON = JarResources.getIcon("Results.gif");
    }

    private class Editor
    extends AbstractCellEditor
    implements TableCellEditor {
        private Object currVal;

        private Editor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currVal = value;
            if (value instanceof Component) {
                return (Component)value;
            }
            this.currVal = new JLabel(value.toString());
            return (JLabel)this.currVal;
        }

        @Override
        public Object getCellEditorValue() {
            return this.currVal;
        }
    }

    private class ToolRunnableStateAction
    extends XDCAction {
        private final ToolRunnable trunnable;
        private final ToolRunnableStateAction fTrsaInstance;
        private boolean fDoBrowser;

        private ToolRunnableStateAction(ToolRunnable trunnable, boolean doBrowser) {
            super("ToolStateAction", "Tool State", "Details on the Tools State", null);
            this.fTrsaInstance = this;
            this.trunnable = trunnable;
            this.fDoBrowser = doBrowser;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            block18: {
                if (this.fOnlyDoubleClick) {
                    return;
                }
                klog.debug("running ToolRunnableStateAction");
                if (this.trunnable.state == ExecState.WAITING) {
                    Application.getWindowManager().showMessage("Waiting for: " + this.trunnable.tool.getClass().getName());
                } else if (this.trunnable.state == ExecState.PARAM_ERROR) {
                    kInstance.updateTable();
                    Application.getWindowManager().showError("One or more parameter(s) were not specified", this.trunnable.throwable);
                } else if (this.trunnable.state == ExecState.EXEC_ERROR) {
                    kInstance.updateTable();
                    Application.getWindowManager().showError("Tool execution error", this.trunnable.throwable);
                } else if (this.trunnable.state == ExecState.RUNNING || this.trunnable.state == ExecState.PAUSED) {
                    kInstance.updateTable();
                } else if (this.trunnable.state == ExecState.SUCCESS || this.trunnable.state == ExecState.SUCCESS_WARN || this.trunnable.state == ExecState.KILLED) {
                    kInstance.updateTable();
                    Report report = this.trunnable.tool.getReport();
                    if (report == null) {
                        this.fTrsaInstance.setEnabled(false);
                        Application.getWindowManager().showMessage("No report data produced");
                    } else if (this.fDoBrowser) {
                        try {
                            URL url = report.getReportIndex().toURL();
                            if (url != null) {
                                Desktop.getDesktop().browse(url.toURI());
                                break block18;
                            }
                            Application.getWindowManager().showMessage("No report produced");
                        }
                        catch (Throwable t) {
                            Application.getWindowManager().showError(t);
                        }
                    } else {
                        JObjectsList jol = new JObjectsList(report.getFilesProduced());
                        JObjectsList.displayInWindow("Results for: " + this.trunnable.tool.getClass().getName(), RESULTS_ICON, jol);
                    }
                } else {
                    kInstance.updateTable();
                    Application.getWindowManager().showMessage("No actions defined for this state " + this.trunnable.state + " " + this.trunnable.tool.getClass().getName());
                }
            }
        }
    }

    static class ToolRunnable
    implements Runnable {
        private Tool tool;
        private ParamSet pset;
        private ExecState state;
        private Throwable throwable;
        private Thread owner_thread;
        private boolean wasKilled;

        private ToolRunnable(Tool p) {
            if (p == null) {
                throw new IllegalArgumentException("Param p cannot be null");
            }
            this.tool = p;
            this.pset = p.getParamSet();
            this.state = ExecState.WAITING;
            this.throwable = null;
        }

        private static ToolRunnable createParamErrorToolState(Tool p, ParamSet pset, Throwable throwable) {
            if (pset == null) {
                throw new IllegalArgumentException("Param pset cannot be null");
            }
            ToolRunnable ps = new ToolRunnable(p);
            ps.state = ExecState.PARAM_ERROR;
            ps.throwable = throwable;
            ps.pset = pset;
            return ps;
        }

        @Override
        public void run() {
            try {
                this.state = ExecState.RUNNING;
                kInstance.updateTable();
                this.tool.execute();
                ToolReport report = (ToolReport)this.tool.getReport();
                this.state = report == null ? ExecState.EXEC_ERROR : (this.wasKilled ? ExecState.KILLED : (report.getToolWarnings().isEmpty() ? ExecState.SUCCESS : ExecState.SUCCESS_WARN));
            }
            catch (Throwable t) {
                this.state = ExecState.EXEC_ERROR;
                this.throwable = t;
                klog.error("Tool exec error", t);
                if (this.tool != null && this.tool.getReport() != null) {
                    this.tool.getReport().setErroredOut();
                }
            }
            finally {
                kInstance.updateTable();
            }
        }
    }

    private class Renderer
    extends DefaultTableCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Component) {
                return (Component)value;
            }
            return this;
        }
    }

    private class Model
    extends AbstractTableModel {
        private TIntObjectHashMap fRowToolButtonMap;
        private TIntObjectHashMap fRowReportButtonMap;
        private final Icon LHS_TOOL_ICON = JarResources.getIcon("dirty_ov.gif");

        private Model() {
            this.fRowToolButtonMap = new TIntObjectHashMap();
            this.fRowReportButtonMap = new TIntObjectHashMap();
        }

        @Override
        public int getRowCount() {
            return TaskManager.this.fToolRunnables.size();
        }

        @Override
        public int getColumnCount() {
            return COL_HEADERS.length;
        }

        public Class getColumnClass(int col) {
            return Object.class;
        }

        @Override
        public String getColumnName(int col) {
            return COL_HEADERS[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }

        @Override
        public Object getValueAt(int row, int col) {
            ToolRunnable trunnable = (ToolRunnable)TaskManager.this.fToolRunnables.get(row);
            if (col == 0) {
                return new Integer(row + 1);
            }
            if (col == 1) {
                JButton but;
                if (this.fRowToolButtonMap.get(row) == null) {
                    but = new JButton();
                    but.setBorderPainted(false);
                    but.setFocusPainted(false);
                    this.fRowToolButtonMap.put(row, (Object)but);
                } else {
                    but = (JButton)this.fRowToolButtonMap.get(row);
                }
                Tool tool = trunnable.tool;
                SingleToolLauncherAction action = new SingleToolLauncherAction(tool, trunnable.pset, null);
                but.setAction(action);
                but.setIcon(this.LHS_TOOL_ICON);
                return but;
            }
            if (col == 2) {
                JButton but;
                if (this.fRowReportButtonMap.get(row) == null) {
                    but = new JButton();
                    but.setBorderPainted(false);
                    but.setFocusPainted(false);
                    this.fRowReportButtonMap.put(row, (Object)but);
                } else {
                    but = (JButton)this.fRowReportButtonMap.get(row);
                }
                ToolRunnableStateAction action = new ToolRunnableStateAction(trunnable, TaskManager.this.fOnClickShowResultsInBrowserOnly);
                but.setAction(action);
                if (trunnable.state == ExecState.SUCCESS) {
                    Report report = trunnable.tool.getReport();
                    if (report == null) {
                        but.setText("No Report Produced");
                    } else {
                        int len = report.getNumPagesMade();
                        if (len == 0) {
                            but.setText("0 Result Objects");
                        } else {
                            but.setForeground(Color.GREEN);
                            but.setText("<html><body><font color=green>Success</font></body></html>");
                            but.setIcon(GuiHelper.ICON_ELLIPSIS);
                            but.setVerticalTextPosition(1);
                            but.setToolTipText(but.getText());
                        }
                    }
                } else {
                    but.setText(((ToolRunnable)trunnable).state.name);
                }
                but.setHorizontalAlignment(0);
                but.setForeground(((ToolRunnable)trunnable).state.color);
                but.setBorderPainted(false);
                return but;
            }
            return "Bad col: " + col;
        }
    }
}

