/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.core.api;

import com.jidesoft.dialog.ButtonPanel;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.xbench.actions.ext.BrowserAction;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.core.api.DialogDescriptor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xapps.gsea.GseaWebResources;

public class DialogDescriptorJide
implements DialogDescriptor {
    private static final Logger klog = LoggerFactory.getLogger(DialogDescriptorJide.class);
    private JPanel fMainPanel;
    private int fChoosenOption = -1;
    private boolean fModal = true;
    private JDialog fDialog;
    private String fTitle;
    private boolean showLicenseButton = false;
    private Action fHelpAction_opt;
    private JButton bCancel;
    private JButton[] fCustomButtons;
    private boolean fAddCancelButton = true;
    JPanel botPanel;
    private JButton bOk;
    private ButtonPanel buttonPanel;

    public DialogDescriptorJide(String title, Component inputComp, Action help_action_opt) {
        this.init(help_action_opt);
        this.jbInit(title, inputComp);
    }

    public DialogDescriptorJide(String title, Component inputComp, Action help_action_opt, boolean showLicenseButton) {
        this.showLicenseButton = showLicenseButton;
        this.init(help_action_opt);
        this.jbInit(title, inputComp);
    }

    protected DialogDescriptorJide() {
    }

    private void init(Action help_action_opt) {
        this.fHelpAction_opt = help_action_opt;
    }

    protected void jbInit(String title, Component inputComp) {
        this.fTitle = title;
        this.fMainPanel = new JPanel(new BorderLayout(10, 10));
        this.fMainPanel.add(inputComp, "Center");
        this.bCancel = new JButton("Cancel");
    }

    protected void _jbInit_jit_buttons() {
        if (this.botPanel == null) {
            this.botPanel = new JPanel(new BorderLayout(3, 3));
            this.botPanel.add((Component)this.createButtonPanel(), "Center");
            this.botPanel.add(Box.createVerticalStrut(10), "South");
            this.fMainPanel.add((Component)this.botPanel, "Last");
            this.fMainPanel.setPreferredSize(DD_SIZE);
        }
    }

    @Override
    public int show() {
        this._jbInit_jit_buttons();
        this.fChoosenOption = 2;
        this.fDialog = new JDialog(Application.getWindowManager().getRootFrame(), this.fTitle, this.fModal);
        this.fDialog.setModal(this.fModal);
        this.fMainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.fDialog.setContentPane(this.fMainPanel);
        this.fDialog.setResizable(true);
        this.fDialog.pack();
        GuiHelper.centerComponent(this.fDialog);
        this.fDialog.setVisible(true);
        this.fDialog.requestFocus();
        return this.fChoosenOption;
    }

    @Override
    public void enableDoubleClickableJList(final JList jl) {
        jl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                Object[] objs = jl.getSelectedValues();
                if (objs == null) {
                    return;
                }
                if (me.getClickCount() == 2) {
                    me.consume();
                    DialogDescriptorJide.this.fChoosenOption = 0;
                    if (DialogDescriptorJide.this.fDialog != null) {
                        DialogDescriptorJide.this.fDialog.dispose();
                    }
                }
            }
        });
    }

    public void setButtons(JButton[] boptions) {
        this.fCustomButtons = boptions;
    }

    @Override
    public void setOnlyShowCloseOption() {
        this.fCustomButtons = new JButton[0];
        this.bCancel.setText("Close");
        this.fAddCancelButton = true;
    }

    private ButtonPanel createButtonPanel() {
        this.buttonPanel = new ButtonPanel();
        if (this.fCustomButtons != null) {
            for (int i = 0; i < this.fCustomButtons.length; ++i) {
                this.buttonPanel.addButton((AbstractButton)this.fCustomButtons[i]);
            }
            if (this.fAddCancelButton) {
                this.bCancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DialogDescriptorJide.this.fChoosenOption = 2;
                        DialogDescriptorJide.this.fDialog.setVisible(false);
                        DialogDescriptorJide.this.fDialog.dispose();
                    }
                });
                this.buttonPanel.addButton((AbstractButton)this.bCancel, (Object)"CANCEL");
            }
        } else {
            this.bOk = new JButton("OK");
            this.buttonPanel.addButton((AbstractButton)this.bOk, (Object)"AFFIRMATIVE");
            this.buttonPanel.addButton((AbstractButton)this.bCancel, (Object)"CANCEL");
            if (this.fHelpAction_opt != null) {
                klog.debug("Making help action button: {}", (Object)this.fHelpAction_opt);
                this.fChoosenOption = 2;
                JButton bHelp = new JButton("Help");
                bHelp.setAction(this.fHelpAction_opt);
                this.buttonPanel.addButton((AbstractButton)bHelp, (Object)"HELP");
            } else {
                klog.debug("Not making help action button: {}", (Object)this.fHelpAction_opt);
            }
            if (this.showLicenseButton) {
                JButton bLicense = new JButton("MSigDB License", GuiHelper.ICON_HELP16);
                bLicense.addActionListener(new BrowserAction("MSigDB License", "MSigDB License Terms", GuiHelper.ICON_HELP16, GseaWebResources.getGseaBaseURL() + "/license_terms_list.jsp"));
                this.buttonPanel.addButton((AbstractButton)bLicense, (Object)"ALTERNATIVE");
            }
            this.bOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogDescriptorJide.this.fChoosenOption = 0;
                }
            });
            this.bOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogDescriptorJide.this.fChoosenOption = 0;
                    DialogDescriptorJide.this.fDialog.setVisible(false);
                    DialogDescriptorJide.this.fDialog.dispose();
                }
            });
            this.bCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogDescriptorJide.this.fChoosenOption = 2;
                    DialogDescriptorJide.this.fDialog.setVisible(false);
                    DialogDescriptorJide.this.fDialog.dispose();
                }
            });
        }
        return this.buttonPanel;
    }
}

