/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.math.Vector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class ParseUtils {
    public static final String DEFAULT_DELIMS = " \t\n,;:";

    public static String getLastToken(String s, String delimiters) {
        StringTokenizer tok = new StringTokenizer(s, delimiters);
        while (tok.hasMoreTokens()) {
            s = tok.nextToken();
        }
        return s;
    }

    public static float[] string2floats(String s) throws NumberFormatException, IllegalArgumentException {
        if (null == s) {
            throw new NullPointerException("Cannot work on null String");
        }
        StringTokenizer tok = new StringTokenizer(s, DEFAULT_DELIMS);
        return ParseUtils._doFloatParse(tok);
    }

    public static int[] string2ints(String s, String delims) throws NumberFormatException, IllegalArgumentException {
        if (null == s) {
            throw new NullPointerException("Cannot work on null String");
        }
        StringTokenizer tok = new StringTokenizer(s, delims);
        return ParseUtils._doIntParse(tok);
    }

    public static int[] string2ints(String s, char delim) throws NumberFormatException, IllegalArgumentException {
        return ParseUtils.string2ints(s, Character.toString(delim));
    }

    public static float[] string2floats(String s, String delims) throws NumberFormatException, IllegalArgumentException {
        if (null == s) {
            throw new NullPointerException("Cannot work on null String");
        }
        StringTokenizer tok = new StringTokenizer(s, delims);
        return ParseUtils._doFloatParse(tok);
    }

    public static Vector string2Vector(String s, char delim) {
        return new Vector(ParseUtils.string2floats(s, Character.toString(delim)));
    }

    private static int[] _doIntParse(StringTokenizer tok) throws NumberFormatException {
        int[] ret = new int[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            String curr = tok.nextToken();
            ret[i] = Integer.parseInt(curr);
            ++i;
        }
        return ret;
    }

    private static float[] _doFloatParse(StringTokenizer tok) throws NumberFormatException {
        float[] ret = new float[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            String curr = tok.nextToken();
            ret[i] = Float.parseFloat(curr);
            ++i;
        }
        return ret;
    }

    public static String[] string2strings(String s, String delim) throws IllegalArgumentException {
        if (null == s) {
            throw new NullPointerException("Cannot parse on null String");
        }
        StringTokenizer tok = new StringTokenizer(s, delim);
        String[] ret = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            ret[i] = tok.nextToken().trim();
            ++i;
        }
        return ret;
    }

    public static List<String> string2stringsList(String s, String delim) throws IllegalArgumentException {
        if (null == s) {
            throw new NullPointerException("Cannot work on null String");
        }
        StringTokenizer tok = new StringTokenizer(s, delim);
        ArrayList<String> ret = new ArrayList<String>(tok.countTokens());
        while (tok.hasMoreTokens()) {
            ret.add(tok.nextToken().trim());
        }
        return ret;
    }

    public static Set<String> string2stringsSet(String s, String delim) throws IllegalArgumentException {
        HashSet<String> ret = new HashSet<String>();
        if (null == s) {
            return ret;
        }
        StringTokenizer tok = new StringTokenizer(s, delim);
        while (tok.hasMoreTokens()) {
            String elem = tok.nextToken().trim();
            if (elem == null) continue;
            ret.add(elem);
        }
        return ret;
    }

    public static char getDelim(String aStr) {
        char[] theDelims = new char[]{'\t', ' ', ',', '\n'};
        char theDelim = '\u0000';
        int curInd = -1;
        for (int ind = 0; curInd == -1 && ind < theDelims.length; ++ind) {
            theDelim = theDelims[ind];
            curInd = aStr.indexOf(theDelim, 0);
        }
        if (curInd == -1) {
            theDelim = '\u0000';
        }
        return theDelim;
    }

    public static int splitIntegers(String aStr, char aDelim, int[] aInts) throws Exception {
        int curInd = 0;
        int prevInd = 0;
        int i = 0;
        int theLength = aStr.length();
        while (curInd < theLength) {
            curInd = aStr.indexOf(aDelim, prevInd);
            if (curInd < 0) {
                curInd = theLength;
            }
            String subStr = aStr.substring(prevInd, curInd).trim();
            aInts[i] = Integer.valueOf(subStr);
            prevInd = curInd + 1;
            if (++i != aInts.length) continue;
            break;
        }
        return i;
    }

    public static List<String> getUniqueTokens(StringTokenizer tok) {
        ArrayList<String> uniqs = new ArrayList<String>();
        while (tok.hasMoreElements()) {
            String t = tok.nextToken().trim();
            if (uniqs.contains(t)) continue;
            uniqs.add(t);
        }
        return uniqs;
    }

    public static List<String> readFfn(File aFile) throws IOException {
        BufferedReader buf = new BufferedReader(new FileReader(aFile));
        ArrayList<String> lines = new ArrayList<String>();
        String line = ParseUtils.nextLine(buf);
        while (line != null) {
            if (!lines.contains(line)) {
                lines.add(line);
            }
            line = ParseUtils.nextLine(buf);
        }
        buf.close();
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readKeyVal(String filepath) throws IOException {
        URI uri = new File(filepath).toURI();
        URL url = uri.toURL();
        try (BufferedReader buf = new BufferedReader(new InputStreamReader(url.openStream()));){
            Properties prp = new Properties();
            String line = ParseUtils.nextLine(buf);
            int lineNum = 0;
            while (line != null) {
                String key;
                StringTokenizer tok = new StringTokenizer(line, "\t");
                String val = null;
                if (tok.countTokens() == 2) {
                    key = tok.nextToken().trim();
                    val = tok.nextToken().trim();
                } else if (tok.countTokens() == 1) {
                    key = tok.nextToken().trim();
                } else {
                    throw new IOException("Bad line format: " + line + " # tokens: " + tok.countTokens() + " line: " + lineNum);
                }
                if (val == null || val.length() == 0) {
                    throw new RuntimeException("Value must exist. Missing on line: " + lineNum + " val: " + val);
                }
                if (key.length() == 0) {
                    throw new RuntimeException("Empty key on line: " + lineNum);
                }
                prp.setProperty(key, val);
                line = ParseUtils.nextLine(buf);
                ++lineNum;
            }
            if (lineNum == 0) {
                throw new IllegalArgumentException("Empty input stream!! ");
            }
            Properties properties = prp;
            return properties;
        }
    }

    public static int countLines(File file, boolean ignoreblanklines) throws IOException {
        return ParseUtils.countLines(ParseUtils._buf(file), ignoreblanklines);
    }

    public static int countLines(BufferedReader buf, boolean ignoreblanklines) throws IOException {
        int numberOfLines = 0;
        if (!ignoreblanklines) {
            while (buf.readLine() != null) {
                ++numberOfLines;
            }
        } else {
            String currLine = buf.readLine();
            while (currLine != null) {
                if (currLine.trim().length() > 0) {
                    ++numberOfLines;
                }
                currLine = buf.readLine();
            }
        }
        buf.close();
        return numberOfLines;
    }

    public static String nextLine(BufferedReader buf) throws IOException {
        String currLine = buf.readLine();
        if (currLine == null) {
            return null;
        }
        currLine = currLine.trim();
        while (currLine != null && (currLine.length() == 0 || currLine.startsWith("#"))) {
            currLine = buf.readLine();
            if (currLine == null) continue;
            currLine = currLine.trim();
        }
        return currLine;
    }

    private static BufferedReader _buf(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter file cannot be null");
        }
        return new BufferedReader(new FileReader(file));
    }
}

