/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.alg.fdr.FdrAlgs;
import edu.mit.broad.genome.alg.gsea.EdbAlgs;
import edu.mit.broad.genome.alg.gsea.Norms;
import edu.mit.broad.genome.alg.gsea.PValueCalculator;
import edu.mit.broad.genome.math.DatasetModed;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentScoreImpl;
import edu.mit.broad.genome.objects.strucs.SkewCorrectedFdrStruc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PValueCalculatorImpls {
    private static final Logger klog = LoggerFactory.getLogger(PValueCalculatorImpls.class);

    private static EnrichmentResult[] _calcGseaMethod(String normName, EnrichmentResult[] results) {
        LabelledVector realESS = EdbAlgs.createRealES(results);
        Dataset rndESS = EdbAlgs.createRndESDataset(results);
        klog.debug("Norm mode: {}", (Object)normName);
        Norms.Struc struc = Norms.normalize(normName, realESS, rndESS);
        return PValueCalculatorImpls._calcGseaMethod(realESS, struc.normReal, rndESS, struc.normRnd, results);
    }

    private static EnrichmentResult[] _calcGseaMethod(LabelledVector realESS, LabelledVector realNESS, Dataset rndESS_full, Dataset rndNESS_full, EnrichmentResult[] prev_results) {
        klog.debug("Started calcFdrs_skewed");
        Dataset rndNESS = new DatasetGenerators().extractRows(rndNESS_full, realESS.getLabels());
        DatasetModed all_rnd_scores_norm_moded_pos = new DatasetModed(rndNESS, ScoreMode.POS_ONLY, SortMode.REAL, Order.DESCENDING);
        DatasetModed all_rnd_scores_norm_moded_neg = new DatasetModed(rndNESS, ScoreMode.NEG_ONLY, SortMode.REAL, Order.ASCENDING);
        FdrAlgs.FdrMap fdrMap = FdrAlgs.calcFdrs_skewed(realESS, rndESS_full, realNESS, all_rnd_scores_norm_moded_pos, all_rnd_scores_norm_moded_neg, SortMode.REAL);
        klog.debug("done fdrMap");
        EnrichmentResult[] results = new EnrichmentResult[prev_results.length];
        klog.debug("Started core calcFdrs in _calcGseaMethod for results: {}", (Object)prev_results.length);
        for (int r = 0; r < prev_results.length; ++r) {
            String gsetName = prev_results[r].getGeneSetName();
            SkewCorrectedFdrStruc fdrStruc = fdrMap.getFdr(gsetName);
            float es = realESS.getScore(gsetName);
            float nes = realNESS.getScore(gsetName);
            Vector es_rnd_for_this_set = rndESS_full.getRow(gsetName);
            float np = XMath.getPValueTwoTailed_pos_neg_seperate(es, es_rnd_for_this_set);
            float fwer = XMath.getFWERTwoTailed(nes, rndNESS_full.getMatrix());
            float fdr_value = fdrStruc.getFdr();
            if (Float.isNaN(fdr_value)) {
                // empty if block
            }
            if (!XMath.isSameSign(nes, es)) {
                fdr_value = 1.0f;
            }
            if (fdr_value > 1.0f) {
                fdr_value = 1.0f;
            }
            EnrichmentScoreImpl es_new = new EnrichmentScoreImpl(prev_results[r].getScore(), nes, np, fdr_value, fwer);
            results[r] = new EnrichmentResult(prev_results[r].getRankedList(), prev_results[r].getTemplate(), prev_results[r].getGeneSet(), prev_results[r].getChip(), es_new, prev_results[r].getRndESS(), fdrStruc);
            if (r % 25 != 0) continue;
            klog.debug("Done loop: {} / {}", (Object)r, (Object)prev_results.length);
        }
        klog.debug("Done core calcFdrs in _calcGseaMethod for results: {}", (Object)prev_results.length);
        return results;
    }

    public static class GseaImpl
    implements PValueCalculator {
        private String fNormName;

        public GseaImpl(String normName) {
            this.fNormName = normName;
        }

        @Override
        public EnrichmentResult[] calcNPValuesAndFDR(EnrichmentResult[] results) {
            return PValueCalculatorImpls._calcGseaMethod(this.fNormName, results);
        }
    }
}

