/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.core.api;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.xbench.core.ApplicationDialog;
import edu.mit.broad.xbench.core.Window;
import edu.mit.broad.xbench.core.WrappedComponent;
import edu.mit.broad.xbench.core.api.DialogDescriptor;
import edu.mit.broad.xbench.core.api.DialogDescriptorJide;
import edu.mit.broad.xbench.core.api.WindowManager;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWindowManager
implements WindowManager {
    private JFrame fRootFrame;
    private static final Logger klog = LoggerFactory.getLogger(AbstractWindowManager.class);

    public AbstractWindowManager(JFrame rootFrame) {
        if (rootFrame == null) {
            throw new IllegalArgumentException("Param rootFrame cannot be null");
        }
        this.fRootFrame = rootFrame;
    }

    @Override
    public Dimension getExpectedWindowSize() {
        return new Dimension(10, 10);
    }

    @Override
    public Window openWindow(WrappedComponent wc, Dimension dim) {
        return this.openWindow(wc);
    }

    @Override
    public JFrame getRootFrame() {
        return this.fRootFrame;
    }

    @Override
    public void showError(String msg, Throwable t) {
        klog.error(msg, t);
        ApplicationDialog.showError(msg, t);
    }

    @Override
    public void showError(String msg) {
        ApplicationDialog.showError(msg);
    }

    @Override
    public void showError(Errors errors) {
        klog.error(errors.getErrors(false));
        ApplicationDialog.showError(errors);
    }

    @Override
    public void showError(Throwable t) {
        this.showError("Error", t);
    }

    @Override
    public void showError(String msg, Throwable t, JButton[] customRemedyOptions) {
        klog.error(msg);
        ApplicationDialog.showError(msg, t);
        klog.debug("TO DO the customRemedyOptions: {}", (Object)customRemedyOptions.toString());
    }

    @Override
    public boolean showConfirm(String msg) {
        klog.info(msg);
        return ApplicationDialog.showConfirm("Please confirm this action", msg);
    }

    @Override
    public boolean showConfirm(String title, String msg) {
        klog.info(msg);
        return ApplicationDialog.showConfirm(title, msg);
    }

    @Override
    public void showMessage(String msg) {
        klog.info(msg);
        ApplicationDialog.showMessage(msg);
    }

    @Override
    public void showMessage(String title, String msg) {
        klog.info(msg);
        ApplicationDialog.showMessage(title, msg);
    }

    @Override
    public DialogDescriptor createDialogDescriptor(String title, Component comp, Action help_action_opt, boolean showLicenseButton) {
        return new DialogDescriptorJide(title, comp, help_action_opt, showLicenseButton);
    }

    @Override
    public DialogDescriptor createDialogDescriptor(String title, Component comp, Action help_action_opt) {
        return new DialogDescriptorJide(title, comp, help_action_opt);
    }

    @Override
    public DialogDescriptor createDialogDescriptor(String title, Component comp) {
        return new DialogDescriptorJide(title, comp, null);
    }
}

