/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.math.AddressedVector;
import edu.mit.broad.genome.math.DoubleElement;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.DefaultRankedList;
import edu.mit.broad.genome.objects.LabelledVector;
import edu.mit.broad.genome.objects.RankedList;
import java.util.ArrayList;
import java.util.List;

public class RankedListGenerators {
    private RankedListGenerators() {
    }

    public static RankedList createBySorting(RankedList rl, SortMode sort, Order order) {
        LabelledVector lv = new LabelledVector(rl);
        return lv.sort(sort, order);
    }

    public static RankedList createBySorting(String name, String[] names, float[] scores, SortMode sort, Order order) {
        LabelledVector lv = new LabelledVector(name, names, scores);
        return lv.sort(sort, order);
    }

    public static RankedList sortByVectorAndGetRankedList(Vector iv, SortMode sort, Order order, List<String> names) {
        DoubleElement[] dels = RankedListGenerators._sort(new AddressedVector(iv), sort, order);
        Vector v = new Vector(dels.length);
        ArrayList<String> clonedLabels = new ArrayList<String>();
        for (int i = 0; i < dels.length; ++i) {
            v.setElement(i, (float)dels[i].fValue);
            clonedLabels.add(names.get(dels[i].fIndex));
        }
        return new DefaultRankedList(null, clonedLabels, v);
    }

    private static DoubleElement[] _sort(AddressedVector av, SortMode sort, Order order) {
        DoubleElement[] dels = new DoubleElement[av.getSize()];
        for (int i = 0; i < av.getSize(); ++i) {
            dels[i] = new DoubleElement(av.getAddress(i), av.getScore(i));
        }
        return DoubleElement.sort(sort, order, dels);
    }
}

