/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.impl;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.genericmatrix.impl.DefaultSparseGenericMatrix;
import org.ujmp.core.objectmatrix.SparseObjectMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSparseObjectMatrix
extends DefaultSparseGenericMatrix<Object>
implements SparseObjectMatrix {
    private static final long serialVersionUID = -1130331544425728230L;

    public DefaultSparseObjectMatrix(Matrix m) {
        super(m, -1);
    }

    public DefaultSparseObjectMatrix(Matrix m, int maximumNumberOfEntries) {
        super(m, maximumNumberOfEntries);
    }

    public DefaultSparseObjectMatrix(long ... size) {
        super(size);
    }

    @Override
    public final ValueType getValueType() {
        return ValueType.OBJECT;
    }

    public static DefaultSparseObjectMatrix fromNonZeros(Matrix nonZeros) {
        Matrix max = nonZeros.max(Calculation.Ret.NEW, 0);
        long valueCount = nonZeros.getRowCount();
        long rowCount = max.getAsLong(0L, 0L);
        long columnCount = max.getAsLong(0L, 1L);
        DefaultSparseObjectMatrix m = new DefaultSparseObjectMatrix(rowCount, columnCount);
        int r = 0;
        while ((long)r < valueCount) {
            long[] c = new long[]{nonZeros.getAsLong(r, 0L), nonZeros.getAsLong(r, 1L)};
            Coordinates co = Coordinates.wrap(c);
            Object val = nonZeros.getAsObject(r, 2L);
            m.values.put(co, val);
            ++r;
        }
        return m;
    }
}

