/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.tui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.swing.fields.GDirFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtools.api.param.Param;
import xtools.api.param.ParamSet;
import xtools.api.param.ReportDirParam;
import xtools.api.param.ReportLabelParam;

public class ParamSetDisplay {
    private Logger log = LoggerFactory.getLogger(ParamSetDisplay.class);
    private ParamSet fParamSet;
    private String fTitle;
    private Icon fIcon;
    private JPanel fBasePanel;
    private boolean fShowBasic;
    private boolean fShowAdvanced;
    private JButton bBasic;
    private JButton bAdvanced;
    private static final Color LIGHT_GREEN = Color.decode("#EAFFEA");
    private static final int DEFAULT_INITIAL_DELAY = ToolTipManager.sharedInstance().getInitialDelay();
    private MouseMotionListener fMouseListener;

    public ParamSetDisplay(String title, Icon icon, ParamSet pset, MouseMotionListener ml) {
        if (pset == null) {
            throw new IllegalArgumentException("Null pset param not allowed");
        }
        this.fTitle = title;
        this.fIcon = icon;
        this.fParamSet = pset;
        this.fMouseListener = ml;
        this.fShowBasic = pset.getNumParams() <= 10;
        this.fShowAdvanced = false;
        this.jbInit();
    }

    private void jbInit() {
        this.fBasePanel = new JPanel(new GridBagLayout());
        this.fBasePanel.addMouseMotionListener(this.fMouseListener);
        this.bBasic = new JButton();
        this.bBasic.setSize(10, 10);
        this.bAdvanced = new JButton();
        this.bAdvanced.setSize(10, 10);
        this.buildPanel();
        this.bBasic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParamSetDisplay.this.fShowBasic = !ParamSetDisplay.this.fShowBasic;
                ParamSetDisplay.this.buildPanel();
            }
        });
        this.bAdvanced.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParamSetDisplay.this.fShowAdvanced = !ParamSetDisplay.this.fShowAdvanced;
                ParamSetDisplay.this.buildPanel();
            }
        });
    }

    private Param[] _getAllReqd() {
        int i;
        Param[] reqd = this.fParamSet.getParams(Param.REQUIRED, true);
        Param[] ps_reqd = this.fParamSet.getParams(Param.PSEUDO_REQUIRED, true);
        Param[] all_reqd = new Param[reqd.length + ps_reqd.length];
        Param save_output = null;
        int cnt = 0;
        for (i = 0; i < reqd.length; ++i) {
            if (reqd[i] instanceof ReportDirParam) {
                save_output = reqd[i];
                continue;
            }
            all_reqd[cnt++] = reqd[i];
        }
        for (i = 0; i < ps_reqd.length; ++i) {
            all_reqd[cnt++] = ps_reqd[i];
        }
        if (save_output != null) {
            all_reqd[cnt] = save_output;
        }
        return all_reqd;
    }

    private Param[] _orderBasic(Param[] params) {
        int i;
        ArrayList<Param> list = new ArrayList<Param>();
        for (i = 0; i < params.length; ++i) {
            if (!(params[i] instanceof ReportLabelParam)) continue;
            list.add(params[i]);
        }
        for (i = 0; i < params.length; ++i) {
            if (params[i] instanceof ReportLabelParam) continue;
            list.add(params[i]);
        }
        return list.toArray(new Param[list.size()]);
    }

    protected Color getHeaderBackground() {
        return GuiHelper.COLOR_LIGHT_BLUE;
    }

    private void buildPanel() {
        this.fBasePanel.removeAll();
        JPanel gradientPanel = GuiHelper.createGradientHeader(this.getHeaderBackground(), this.fTitle, this.fIcon);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.fill = 2;
        gbc1.weightx = 0.5;
        this.fBasePanel.add((Component)gradientPanel, gbc1);
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.gridy = 1;
        gbc2.fill = 2;
        gbc2.weightx = 0.5;
        this.fBasePanel.add((Component)this.createReqdParamsPanel(this._getAllReqd()), gbc2);
        Param[] basics = this.fParamSet.getParams(Param.BASIC, true);
        basics = this._orderBasic(basics);
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.gridx = 0;
        gbc3.gridy = 2;
        gbc3.fill = 2;
        gbc3.weightx = 0.5;
        this.fBasePanel.add((Component)this.createBasicParamsPanel(basics), gbc3);
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.gridx = 0;
        gbc4.gridy = 3;
        gbc4.fill = 1;
        gbc4.weightx = 0.5;
        gbc4.weighty = 1.0;
        this.fBasePanel.add((Component)this.createAdvancedParamsPanel(this.fParamSet.getParams(Param.ADVANCED, true)), gbc4);
        this.fBasePanel.revalidate();
        this.fBasePanel.repaint();
    }

    private JPanel createReqdParamsPanel(Param[] params) {
        StringBuffer colStr = ParamSetDisplay._createColStr();
        StringBuffer rowStr = ParamSetDisplay._createRowStr(params);
        PanelBuilder builder = ParamSetDisplay._createPanelBuilder(colStr, rowStr);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator("Required fields", cc.xyw(1, 1, 4));
        int rowcnt = 3;
        for (int i = 0; i < params.length; ++i) {
            GFieldPlusChooser chooser = params[i].getSelectionComponent();
            if (params[i].isFileBased() && chooser instanceof GDirFieldPlusChooser) {
                ((GDirFieldPlusChooser)chooser).getTextField().setBackground(LIGHT_GREEN);
            }
            JLabel label = new JLabel(params[i].getHtmlLabel_v2());
            ParamSetDisplay.enableToolTips(label, params[i]);
            builder.add((Component)label, cc.xy(1, rowcnt));
            builder.add((Component)chooser.getComponent(), cc.xy(3, rowcnt));
            rowcnt += 2;
        }
        return builder.getPanel();
    }

    private JPanel createBasicParamsPanel(Param[] params) {
        int sepwidth;
        StringBuffer colStr = ParamSetDisplay._createColStr();
        StringBuffer rowStr = ParamSetDisplay._createRowStr(params);
        PanelBuilder builder = ParamSetDisplay._createPanelBuilder(colStr, rowStr);
        CellConstraints cc = new CellConstraints();
        if (this.fShowBasic) {
            this.bBasic.setText("Hide");
            sepwidth = 3;
        } else {
            this.bBasic.setText("Show");
            sepwidth = 3;
        }
        if (params.length == 0) {
            builder.addSeparator("Basic fields - none available", cc.xyw(1, 1, sepwidth));
            return builder.getPanel();
        }
        builder.add((Component)this.bBasic, cc.xy(5, 1));
        builder.addSeparator("Basic fields", cc.xyw(1, 1, sepwidth));
        if (this.fShowBasic) {
            int rowcnt = 3;
            for (int i = 0; i < params.length; ++i) {
                GFieldPlusChooser chooser = params[i].getSelectionComponent();
                if (params[i] instanceof ReportLabelParam) {
                    chooser.getComponent().setBackground(GuiHelper.COLOR_LIGHT_YELLOW);
                }
                JLabel label = new JLabel(params[i].getHtmlLabel_v2());
                ParamSetDisplay.enableToolTips(label, params[i]);
                builder.add((Component)label, cc.xy(1, rowcnt));
                builder.add((Component)chooser.getComponent(), cc.xy(3, rowcnt));
                rowcnt += 2;
            }
        }
        return builder.getPanel();
    }

    private static void enableToolTips(JLabel label, Param param) {
        label.setToolTipText(param.getDesc());
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ToolTipManager.sharedInstance().setInitialDelay(0);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToolTipManager.sharedInstance().setInitialDelay(DEFAULT_INITIAL_DELAY);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ToolTipManager.sharedInstance().setInitialDelay(0);
            }
        });
    }

    private JPanel createAdvancedParamsPanel(Param[] params) {
        int sepwidth;
        StringBuffer colStr = ParamSetDisplay._createColStr();
        StringBuffer rowStr = ParamSetDisplay._createRowStr(params);
        PanelBuilder builder = ParamSetDisplay._createPanelBuilder(colStr, rowStr);
        CellConstraints cc = new CellConstraints();
        if (this.fShowAdvanced) {
            this.bAdvanced.setText("Hide");
            sepwidth = 3;
        } else {
            this.bAdvanced.setText("Show");
            sepwidth = 3;
        }
        if (params.length == 0) {
            builder.addSeparator("Advanced fields - none available", cc.xyw(1, 1, sepwidth));
            return builder.getPanel();
        }
        builder.addSeparator("Advanced fields", cc.xyw(1, 1, sepwidth));
        builder.add((Component)this.bAdvanced, cc.xy(5, 1));
        if (this.fShowAdvanced) {
            int rowcnt = 3;
            for (int i = 0; i < params.length; ++i) {
                GFieldPlusChooser chooser = params[i].getSelectionComponent();
                JLabel label = new JLabel(params[i].getHtmlLabel_v2());
                ParamSetDisplay.enableToolTips(label, params[i]);
                builder.add((Component)label, cc.xy(1, rowcnt));
                builder.add((Component)chooser.getComponent(), cc.xy(3, rowcnt));
                rowcnt += 2;
            }
        }
        return builder.getPanel();
    }

    public void addMouseMotionListener(MouseMotionListener l) {
    }

    public Component getAsComponent() {
        return this.fBasePanel;
    }

    public void reset() {
        this.log.debug("Resetting params to defaults");
        for (int i = 0; i < this.fParamSet.getNumParams(); ++i) {
            Param param = this.fParamSet.getParam(i);
            Object def = param.getDefault();
            if (def instanceof Object[]) {
                Object[] obj = (Object[])def;
                StringBuffer buf = new StringBuffer();
                for (int j = 0; j < obj.length; ++j) {
                    buf.append(obj[j].toString());
                    if (j == obj.length - 1) continue;
                    buf.append(',');
                }
                param.getSelectionComponent().setValue(buf.toString());
                continue;
            }
            param.getSelectionComponent().setValue(def);
        }
        this.buildPanel();
    }

    private static StringBuffer _createColStr() {
        return new StringBuffer("130dlu,      4dlu,        225dlu,   4dlu,  40dlu");
    }

    private static StringBuffer _createRowStr(Param[] params) {
        StringBuffer rowStr = new StringBuffer();
        rowStr.append("pref, 5dlu,");
        for (int i = 0; i < params.length; ++i) {
            rowStr.append("pref, 3dlu");
            if (params.length == i - 1) continue;
            rowStr.append(",");
        }
        return rowStr;
    }

    private static PanelBuilder _createPanelBuilder(StringBuffer colStr, StringBuffer rowStr) {
        FormLayout layout = new FormLayout(colStr.toString(), rowStr.toString());
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        return builder;
    }
}

