/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.export.exporter;

import java.io.IOException;
import java.io.Writer;
import org.ujmp.core.Matrix;
import org.ujmp.core.export.exporter.AbstractMatrixWriterExporter;
import org.ujmp.core.export.format.MatrixRScriptExportFormat;

public class DefaultMatrixWriterRScriptExporter
extends AbstractMatrixWriterExporter
implements MatrixRScriptExportFormat {
    public DefaultMatrixWriterRScriptExporter(Matrix matrix, Writer writer) {
        super(matrix, writer);
    }

    public void asRScript(String variableName) throws IOException {
        String EOL = System.getProperty("line.separator");
        Writer writer = this.getWriter();
        Matrix matrix = this.getMatrix();
        long nrow = matrix.getRowCount();
        long ncol = matrix.getColumnCount();
        writer.append(variableName);
        writer.append(" <- ");
        writer.append("matrix(c(");
        int c = 0;
        while ((long)c < ncol) {
            writer.append("c(");
            int r = 0;
            while ((long)r < nrow) {
                writer.append(String.valueOf(matrix.getAsDouble(r, c)));
                if ((long)(r + 1) < nrow) {
                    writer.append(",");
                }
                ++r;
            }
            writer.append(")");
            if ((long)(c + 1) < ncol) {
                writer.append(",");
            }
            ++c;
        }
        writer.append("),ncol=" + ncol + ",nrow=" + nrow + ")" + EOL);
    }
}

