/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.xchoosers;

import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateDerivative;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.parsers.ParserFactory;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateSelection {
    private Object fMainTemplate_or_mainTemplateFile;
    protected Set fTemplateNamesOrPaths;
    private Logger log = LoggerFactory.getLogger(TemplateSelection.class);

    protected TemplateSelection() {
    }

    public TemplateSelection(Object mainTemplate_or_mainTemplateFile) {
        if (mainTemplate_or_mainTemplateFile == null) {
            throw new IllegalArgumentException("Param mainTemplate_or_mainTemplateFile cannot be null");
        }
        this.fMainTemplate_or_mainTemplateFile = mainTemplate_or_mainTemplateFile;
    }

    public Object getMainObject() {
        return this.fMainTemplate_or_mainTemplateFile;
    }

    public Set getTemplateNames() {
        if (this.fTemplateNamesOrPaths == null) {
            this.log.debug("Odd that fTemplateNamesOrPaths is null. fMainTemplate: {}", this.fMainTemplate_or_mainTemplateFile);
            return new HashSet();
        }
        return Collections.unmodifiableSet(this.fTemplateNamesOrPaths);
    }

    public void add(TemplateDerivative td, boolean parentNamePlusMyName, boolean fullPath) {
        if (this.fTemplateNamesOrPaths == null) {
            this.fTemplateNamesOrPaths = new HashSet();
        }
        String add = td.getName(parentNamePlusMyName, fullPath);
        this.fTemplateNamesOrPaths.add(add);
    }

    public String formatForUI() {
        String nm;
        File file;
        if (this.fTemplateNamesOrPaths == null) {
            return null;
        }
        String[] vals = this.fTemplateNamesOrPaths.toArray(new String[this.fTemplateNamesOrPaths.size()]);
        if (vals == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (this.fMainTemplate_or_mainTemplateFile instanceof File) {
            file = (File)this.fMainTemplate_or_mainTemplateFile;
            nm = file.getName();
        } else {
            Template t = (Template)this.fMainTemplate_or_mainTemplateFile;
            file = ParserFactory.getCache().isCached(t) ? ParserFactory.getCache().getSourceFile(this.fMainTemplate_or_mainTemplateFile) : new File(t.getName());
            nm = ((Template)this.fMainTemplate_or_mainTemplateFile).getName();
        }
        file = AuxUtils.getBaseFileFromAuxFile(file);
        buf.append(file.getPath());
        if (vals.length == 0) {
            return buf.toString();
        }
        boolean firstAuxOne = true;
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == null) continue;
            String name = AuxUtils.getAuxNameOnlyNoHash(vals[i]);
            if (!name.equals(nm)) {
                if (firstAuxOne) {
                    buf.append('#');
                    firstAuxOne = false;
                }
                buf.append(name);
            }
            if (i == vals.length - 1) continue;
            buf.append(',');
        }
        return buf.toString();
    }
}

