/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports.web;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.strucs.Hyperlink;
import edu.mit.broad.genome.objects.strucs.Linked;
import edu.mit.broad.genome.reports.DefaultHyperlink;
import edu.mit.broad.genome.reports.pages.Page;
import edu.mit.broad.genome.reports.web.WebResources;
import java.io.File;
import xapps.gsea.GseaWebResources;

public class LinkedFactory {
    private LinkedFactory() {
    }

    public static Linked createLinkedGeneSymbol(String symbol) {
        return new LinkedGeneSymbol(symbol);
    }

    public static Linked createLinkedGeneSet(GeneSet gset) {
        return new LinkedGeneSet(gset);
    }

    public static Linked createLinkedSymbol(String symbol) {
        return new LinkedProbe(symbol);
    }

    public static class SimpleLinkedFile
    implements Linked {
        private String text;
        private String fileName;

        public SimpleLinkedFile(String text, File file) {
            this.text = text;
            this.fileName = file.getName();
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public Hyperlink createDefaultLink() {
            return new DefaultHyperlink(this.text, this.fileName);
        }

        @Override
        public Hyperlink[] createAllLinks() {
            return new Hyperlink[]{this.createDefaultLink()};
        }
    }

    public static class LinkedProbe
    implements Linked {
        private String fProbe;

        public LinkedProbe(String probe) {
            if (probe == null) {
                throw new IllegalArgumentException("Parameter probe cannot be null");
            }
            this.fProbe = probe;
        }

        @Override
        public String getText() {
            return this.fProbe;
        }

        public String toString() {
            return this.fProbe;
        }

        @Override
        public Hyperlink createDefaultLink() {
            return new DefaultHyperlink(WebResources.ENSEMBL.getName(), WebResources.ENSEMBL.getUrlPrefix() + this.fProbe);
        }

        @Override
        public Hyperlink[] createAllLinks() {
            return new Hyperlink[]{this.createDefaultLink()};
        }
    }

    public static class LinkedGeneSet
    implements Linked {
        private String fGeneSetName;
        private String url;

        public LinkedGeneSet(GeneSet gset) {
            if (gset == null) {
                throw new IllegalArgumentException("Parameter gset cannot be null");
            }
            this.fGeneSetName = gset.getName(true);
            this.url = !NamingConventions.isNull(gset.getNameEnglish()) && gset.getNameEnglish().length() > 0 ? (gset.getNameEnglish().toLowerCase().startsWith("http") ? gset.getNameEnglish() : "na") : GseaWebResources.getGeneSetURL(this.fGeneSetName);
        }

        @Override
        public String getText() {
            return this.fGeneSetName;
        }

        @Override
        public Hyperlink createDefaultLink() {
            return new DefaultHyperlink(this.fGeneSetName, this.url);
        }

        @Override
        public Hyperlink[] createAllLinks() {
            return new Hyperlink[]{this.createDefaultLink()};
        }
    }

    public static class LinkedGeneSymbol
    implements Linked {
        private String fSymbol;

        public LinkedGeneSymbol(String symbol) {
            if (symbol == null) {
                throw new IllegalArgumentException("Parameter symbol cannot be null");
            }
            this.fSymbol = symbol;
        }

        @Override
        public String getText() {
            return this.fSymbol;
        }

        @Override
        public Hyperlink createDefaultLink() {
            return new DefaultHyperlink(WebResources.ENTREZ_GENE_SYMBOL.getName(), WebResources.ENTREZ_GENE_SYMBOL.getUrlPrefix() + this.fSymbol + "[sym]");
        }

        @Override
        public Hyperlink[] createAllLinks() {
            return new Hyperlink[]{this.createDefaultLink(), new DefaultHyperlink(WebResources.STANFORD_SOURCE_GENE.getName(), WebResources.STANFORD_SOURCE_GENE.getUrlPrefix() + this.fSymbol)};
        }
    }

    public static class SimpleLinkedPage
    implements Linked {
        private String text;
        private String pageName;
        private String pageExt;

        public SimpleLinkedPage(String text, Page page) {
            this.text = text;
            this.pageName = page.getName();
            this.pageExt = page.getExt();
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public Hyperlink createDefaultLink() {
            return new DefaultHyperlink(this.text, this.pageName + "." + this.pageExt);
        }

        @Override
        public Hyperlink[] createAllLinks() {
            return new Hyperlink[]{this.createDefaultLink()};
        }
    }
}

