/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.math.StringMatrix;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.IDataframe;
import java.util.ArrayList;
import java.util.List;

public class StringDataframe
extends AbstractObject
implements IDataframe {
    private StringMatrix fMatrix;
    private List<String> fRowNames;
    private List<String> fColNames;
    private String fRowLabelName;

    public StringDataframe(String name, StringMatrix smatrix, String[] rowNames, String[] colNames) {
        this(name, smatrix, StringDataframe.toList(rowNames), StringDataframe.toList(colNames));
    }

    public StringDataframe(String name, StringMatrix smatrix, String[] colNames) {
        this(name, smatrix, StringDataframe.createSeriesStrings(0, smatrix.getNumRow(), "row_"), StringDataframe.toList(colNames));
    }

    public StringDataframe(String name, StringMatrix smatrix, List<String> rowNames, String[] colNames) {
        this(name, smatrix, rowNames, StringDataframe.toList(colNames));
    }

    public StringDataframe(String name, StringMatrix smatrix, List<String> rowNames, List<String> colNames) {
        if (smatrix == null) {
            throw new IllegalArgumentException("Param matrix cant be null");
        }
        if (rowNames == null) {
            throw new IllegalArgumentException("Param rowNames cant be null");
        }
        if (colNames == null) {
            throw new IllegalArgumentException("Param rowNames cant be null");
        }
        super.initialize(name);
        if (smatrix.getNumRow() != rowNames.size()) {
            throw new IllegalArgumentException("Matrix: " + smatrix.getNumRow() + " and rowNames: " + rowNames.size() + " do not match in size");
        }
        if (smatrix.getNumCol() != colNames.size()) {
            throw new IllegalArgumentException("Matrix: " + smatrix.getNumCol() + " and colNames: " + colNames.size() + " do not match in size");
        }
        if (smatrix.getNumCol() == 0) {
            this.log.warn("zero cols in StringMatrix");
        }
        if (smatrix.getNumRow() == 0) {
            this.log.debug("zero rows in StringMatrix");
        }
        this.fMatrix = smatrix;
        this.fMatrix.setImmutable();
        this.fRowNames = rowNames;
        this.fColNames = colNames;
    }

    public String[] getColumn(int coln) {
        return this.fMatrix.getColumn(coln);
    }

    public String getElement(int rown, int coln) {
        return this.fMatrix.getElement(rown, coln);
    }

    @Override
    public Object getElementObj(int rown, int coln) {
        return this.getElement(rown, coln);
    }

    @Override
    public String getRowName(int rown) {
        return this.fRowNames.get(rown);
    }

    public String[] getRowNamesArray() {
        return this.fRowNames.toArray(new String[this.fRowNames.size()]);
    }

    @Override
    public String getColumnName(int coln) {
        return this.fColNames.get(coln).toString();
    }

    @Override
    public int getNumRow() {
        return this.fMatrix.getNumRow();
    }

    @Override
    public int getNumCol() {
        return this.fMatrix.getNumCol();
    }

    public String getRowLabelName() {
        return this.fRowLabelName;
    }

    @Override
    public String getQuickInfo() {
        StringBuffer buf = new StringBuffer().append(this.getNumRow()).append('x').append(this.getNumCol());
        return buf.toString();
    }

    private static List<String> createSeriesStrings(int start, int stop, String commonPrefix) {
        ArrayList<String> list = new ArrayList<String>(stop - start);
        for (int i = start; i < stop; ++i) {
            list.add(commonPrefix + i);
        }
        return list;
    }

    private static List<String> toList(String[] ss) {
        ArrayList<String> list = new ArrayList<String>(ss.length);
        for (int i = 0; i < ss.length; ++i) {
            list.add(ss[i]);
        }
        return list;
    }

    public void replace(String thisStr, String withThisStr) {
        this.fMatrix.replace(thisStr, withThisStr);
    }
}

