/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome;

import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.parsers.DataFormat;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class NamingConventions {
    private static int kObjectCounter = 1;
    private static final int MAX_FILE_LEN_ALLOWED = 100;

    public static String splitLongHashName(String possibleLongNameWithHashes, String prefixStr) {
        if (possibleLongNameWithHashes == null || possibleLongNameWithHashes.indexOf("#") == -1 || possibleLongNameWithHashes.length() < 80) {
            return possibleLongNameWithHashes;
        }
        StringBuffer buf = new StringBuffer();
        for (int c = 0; c < possibleLongNameWithHashes.length(); ++c) {
            char cr = possibleLongNameWithHashes.charAt(c);
            if (cr == '#') {
                buf.append(prefixStr);
            }
            buf.append(cr);
        }
        return buf.toString();
    }

    public static boolean isURL(String path) {
        return path.toLowerCase().startsWith("http") || path.toLowerCase().startsWith("https") || path.toLowerCase().startsWith("www") || path.toLowerCase().startsWith("ftp");
    }

    public static String titleize(String title) {
        if (NamingConventions.isNull(title)) {
            return "NULL";
        }
        if (title.startsWith("\"")) {
            title = title.substring(1, title.length());
        }
        if (title.endsWith("\"")) {
            title = title.substring(0, title.length() - 1);
        }
        return title;
    }

    public static String createNiceEnglishDate_for_dirs() {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("MMM", Locale.ENGLISH);
        String s = formatter.format((Object)date);
        formatter = new SimpleDateFormat("dd", Locale.ENGLISH);
        s = (s + formatter.format((Object)date)).toLowerCase();
        return s;
    }

    public static boolean isNull(String s) {
        return StringUtils.isBlank((CharSequence)s);
    }

    public static String removeExtension(File file) {
        return NamingConventions.removeExtension(file.getName());
    }

    public static String removeExtension(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Param fileName cannot be null");
        }
        if (fileName.indexOf(".") == -1) {
            return fileName;
        }
        if (fileName.indexOf(35) != -1) {
            return fileName;
        }
        if (fileName.endsWith(".")) {
            return fileName.substring(0, fileName.length() - 1);
        }
        int index = fileName.lastIndexOf(46);
        if (-1 == index) {
            return fileName;
        }
        String just_name = fileName.substring(0, index);
        String ext = fileName.substring(index + 1, fileName.length());
        if (ext.length() <= 4) {
            return just_name;
        }
        StringTokenizer tok = new StringTokenizer(ext, "_");
        tok.nextToken();
        StringBuffer extra = new StringBuffer("_");
        while (tok.hasMoreElements()) {
            extra.append(tok.nextToken());
            if (!tok.hasMoreElements()) continue;
            extra.append("_");
        }
        if (extra.length() != 1) {
            return just_name + extra;
        }
        return just_name;
    }

    public static String removeExtension(PersistentObject pob) {
        if (pob == null) {
            throw new IllegalArgumentException("Parameter pob cannot be null");
        }
        return NamingConventions.removeExtension(pob.getName());
    }

    public static File createSafeFile(File inDir, String name) {
        return new File(inDir, NamingConventions.createSafeFileName(name));
    }

    public static String createSafeFileName(String name) {
        name = name.trim();
        Object safename = name.replace('@', '_');
        safename = ((String)safename).replace('#', '_');
        safename = ((String)safename).replace(' ', '_');
        safename = ((String)safename).replace('%', '_');
        safename = ((String)safename).replace('$', '_');
        safename = ((String)safename).replace(':', '_');
        safename = ((String)safename).replace('*', '_');
        safename = ((String)safename).replace('\\', '_');
        safename = ((String)safename).replace('/', '_');
        if (((String)(safename = ((String)safename).replace('\u001c', '_'))).length() >= 100) {
            String ext = NamingConventions.getExtension((String)safename);
            safename = ((String)safename).substring(0, 100) + "." + ext;
        }
        return safename;
    }

    public static Object[] parseReportTimestampFromName(String rptname) {
        StringTokenizer tok = new StringTokenizer(rptname, ".");
        if (tok.countTokens() != 4) {
            throw new IllegalArgumentException("Invalid rpt name format: " + rptname + " got tokens #: " + tok.countTokens());
        }
        StringBuilder buf = new StringBuilder();
        buf.append(tok.nextToken()).append('.');
        buf.append(tok.nextToken());
        return new Object[]{buf.toString(), Long.parseLong(tok.nextToken())};
    }

    public static String generateName(PersistentObject pob, String short_desc_tag, boolean ultraUniquenessSafe) {
        if (pob == null) {
            return NamingConventions._generateName(null, short_desc_tag, null);
        }
        String ext = DataFormat.getExtension(pob);
        return NamingConventions._generateName(pob.getName(), short_desc_tag, ext, ultraUniquenessSafe);
    }

    public static String generateName(Dataset ds, Template t, boolean stripExtensions) {
        StringBuffer buf = new StringBuffer();
        if (stripExtensions) {
            buf.append(NamingConventions.removeExtension(ds.getName())).append(".");
            buf.append(NamingConventions.removeExtension(t.getName()));
        } else {
            buf.append(ds.getName()).append('.');
            buf.append(t.getName());
        }
        return buf.toString();
    }

    public static String generateName(Dataset ds, GeneSet gset, boolean stripExtensions) {
        StringBuffer buf = new StringBuffer();
        if (stripExtensions) {
            buf.append(NamingConventions.removeExtension(ds.getName())).append(".");
            buf.append(NamingConventions.removeExtension(gset.getName()));
        } else {
            buf.append(ds.getName()).append('.');
            buf.append(gset.getName());
        }
        return buf.toString();
    }

    public static String generateName(PersistentObject pob) {
        return NamingConventions.generateName(pob, null, false);
    }

    private static String _generateName(String origname, String short_desc_tag, String ext) {
        return NamingConventions._generateName(origname, short_desc_tag, ext, false);
    }

    private static String _generateName(String origname, String short_desc_tag, String ext, boolean ultraUniquenessSafe) {
        StringBuffer buf = new StringBuffer();
        if (origname != null) {
            buf.append(NamingConventions.removeExtension(origname));
            buf.append('.');
        }
        if (short_desc_tag != null) {
            StringUtils.replace((String)short_desc_tag, (String)" ", (String)"");
            StringUtils.replace((String)short_desc_tag, (String)"\t", (String)"");
            buf.append(short_desc_tag);
            buf.append('.');
        }
        if (ultraUniquenessSafe) {
            buf.append(NamingConventions.generateUniqueNameTag());
        } else {
            buf.append(NamingConventions.generateCounterNameTag());
        }
        if (ext != null) {
            buf.append('.');
            buf.append(ext);
        }
        return buf.toString();
    }

    private static synchronized String generateUniqueNameTag() {
        return new StringBuffer().append(System.currentTimeMillis()).toString();
    }

    public static synchronized String generateCounterNameTag() {
        return new StringBuffer().append(kObjectCounter++).toString();
    }

    public static String getExtension(String f) {
        int pos = f.lastIndexOf(".");
        String ext = pos == -1 ? "" : f.substring(pos + 1);
        if (f.indexOf(".meta.") != -1) {
            return "meta." + ext;
        }
        return ext;
    }

    public static String getExtension(File f) {
        return NamingConventions.getExtension(f.getName());
    }

    public static String getExtensionLiberal(String f) {
        String ext;
        int pos = f.lastIndexOf(".");
        if (pos == -1) {
            ext = "";
        } else {
            int pos2;
            if (pos > 0 && (pos2 = f.lastIndexOf(".", pos - 1)) != -1) {
                String ext2 = f.substring(pos2 + 1, pos);
                if (ext2.equalsIgnoreCase("gct")) {
                    return "gct";
                }
                if (ext2.equalsIgnoreCase("res")) {
                    return "res";
                }
                if (ext2.equalsIgnoreCase("pcl")) {
                    return "pcl";
                }
                if (ext2.equalsIgnoreCase("gmx")) {
                    return "gmx";
                }
                if (ext2.equalsIgnoreCase("gmt")) {
                    return "gmt";
                }
                if (ext2.equalsIgnoreCase("rnk")) {
                    return "rnk";
                }
                if (ext2.equalsIgnoreCase("cls")) {
                    return "cls";
                }
            }
            ext = f.substring(pos + 1);
        }
        return ext;
    }
}

