/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl;

import java.util.Arrays;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.RelNetComparator;
import org.tigr.microarray.mev.cluster.algorithm.impl.util.IntSorter;
import org.tigr.util.FloatMatrix;

public class PermutationTest
extends AbstractAlgorithm {
    private static final int c_DecileCount = 10;
    public static final double LOG2 = Math.log(2.0);
    public static final float MINVAL = 0.0f;
    public static final float MAXVAL = 1.0f;
    private boolean stop = false;
    private int[] m_arrMainHisto = null;
    private double[] m_arrAvgHisto = null;
    private int m_iHistoSize = 0;
    private int m_iPermutationSize = 0;
    private float m_fltHistoStep = 0.5f;
    private float m_fltMaxStatSignificant = 0.0f;

    private double getEntropy(float[] fArray) {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        int n = 0;
        int[] nArray = new int[10];
        int n2 = fArray.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (Double.isNaN(fArray[n])) continue;
            d = Math.min(d, (double)fArray[n]);
            d2 = Math.max(d2, (double)fArray[n]);
            ++n3;
        }
        double d3 = (d2 - d) / 10.0;
        if (d3 == 0.0) {
            return -1.0 * Math.log(1.0) / LOG2;
        }
        if (d == Double.MAX_VALUE) {
            return 0.0;
        }
        Arrays.fill(nArray, 0);
        for (n = 0; n < n2; ++n) {
            if (Double.isNaN(fArray[n])) continue;
            int n4 = (int)Math.ceil(((double)fArray[n] - d) / d3) - 1;
            if (n4 < 0) {
                n4 = 0;
            }
            int n5 = n4;
            nArray[n5] = nArray[n5] + 1;
        }
        if (n3 == 0) {
            return 0.0;
        }
        double d4 = 0.0;
        for (n = 0; n < 10; ++n) {
            if (nArray[n] == 0) continue;
            double d5 = (double)nArray[n] / (double)n3;
            d4 += d5 * Math.log(d5) / LOG2;
        }
        return -d4;
    }

    private void Assert(int n, int n2, float f) {
        int n3 = this.GetIndByVal(f);
        this.m_arrMainHisto[n3] = this.m_arrMainHisto[n3] + 1;
    }

    private void AssertPermutted(int n, int n2, int n3, float f) {
        int n4 = this.GetIndByVal(f);
        this.m_arrAvgHisto[n4] = this.m_arrAvgHisto[n4] + 1.0;
        this.m_fltMaxStatSignificant = Math.max(this.m_fltMaxStatSignificant, f);
    }

    private int GetIndByVal(float f) {
        int n = (int)Math.ceil((f - 0.0f) / this.m_fltHistoStep) - 1;
        if (n < 0) {
            return 0;
        }
        return n;
    }

    private void RandomPermute(FloatMatrix floatMatrix, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = (int)(Math.random() * (double)floatMatrix.getColumnDimension() + 1.0);
        for (int i = 0; i < n4; ++i) {
            while ((n2 = (int)(Math.random() * (double)(floatMatrix.getColumnDimension() - 1))) == (n3 = (int)(Math.random() * (double)(floatMatrix.getColumnDimension() - 1)))) {
            }
            float f = floatMatrix.A[n][n2];
            floatMatrix.A[n][n2] = floatMatrix.A[n][n3];
            floatMatrix.A[n][n3] = f;
        }
    }

    private void Run(int[] nArray, FloatMatrix floatMatrix, int n, float f, boolean bl) throws AlgorithmException {
        int n2 = nArray.length;
        int n3 = 0;
        boolean bl2 = false;
        int n4 = n2 * (n2 + 1) / 2;
        int n5 = n4 / 100 + 1;
        AlgorithmEvent algorithmEvent = new AlgorithmEvent(this, 1, 100, "Calculating Histogram");
        this.fireValueChanged(algorithmEvent);
        algorithmEvent.setId(2);
        FloatMatrix floatMatrix2 = new FloatMatrix(1, floatMatrix.getColumnDimension());
        for (int i = 0; i < n2; ++i) {
            if (this.stop) {
                throw new AbortException();
            }
            ++n3;
            float[] fArray = floatMatrix.A[nArray[i]];
            float[] fArray2 = floatMatrix2.A[0];
            for (int j = 0; j < fArray2.length; ++j) {
                fArray2[j] = fArray[j];
            }
            for (int j = i + 1; j < n2; ++j) {
                for (int k = 0; k < this.m_iPermutationSize; ++k) {
                    this.RandomPermute(floatMatrix2, 0);
                    float f2 = ExperimentUtil.genePearson(floatMatrix2, floatMatrix, 0, nArray[j], 1.0f);
                    f2 *= f2;
                    this.AssertPermutted(k, nArray[i], nArray[j], f2);
                }
                if (++n3 % n5 != 0) continue;
                algorithmEvent.setIntValue(n3 / n5);
                algorithmEvent.setDescription("Calculating permutation histogram ");
                this.fireValueChanged(algorithmEvent);
            }
        }
    }

    public AlgorithmData execute(AlgorithmData algorithmData) throws AlgorithmException {
        int n;
        int n2;
        FloatMatrix floatMatrix = algorithmData.getMatrix("experiment");
        if (floatMatrix == null) {
            return null;
        }
        AlgorithmParameters algorithmParameters = algorithmData.getParams();
        this.m_iHistoSize = algorithmParameters.getInt("decile-count", 1000);
        this.m_iPermutationSize = algorithmParameters.getInt("permutation-count", 20);
        this.m_fltHistoStep = 1.0f / (float)this.m_iHistoSize;
        this.m_arrMainHisto = new int[this.m_iHistoSize];
        this.m_arrAvgHisto = new double[this.m_iHistoSize];
        int n3 = algorithmParameters.getInt("distance-function", 1);
        float f = algorithmParameters.getFloat("distance-factor", 1.0f);
        boolean bl = algorithmParameters.getBoolean("distance-absolute", true);
        int n4 = n2 = floatMatrix.getRowDimension();
        boolean bl2 = algorithmParameters.getBoolean("filter-by-entropy");
        float f2 = algorithmParameters.getFloat("top-n-percent", 100.0f);
        if (f2 < 0.0f || f2 > 100.0f) {
            throw new AlgorithmException("Filter value is out of range (0, 100)%");
        }
        int[] nArray = new int[n2];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        if (bl2) {
            double[] dArray = new double[n2];
            for (n = 0; n < dArray.length; ++n) {
                dArray[n] = this.getEntropy(floatMatrix.A[n]);
            }
            IntSorter.sort(nArray, new RelNetComparator(dArray));
            n4 = (int)((float)n2 * f2 / 100.0f);
        }
        this.Run(nArray, floatMatrix, n3, f, bl);
        float f3 = this.m_fltMaxStatSignificant;
        if ((double)f3 >= 1.0) {
            for (n = this.m_arrAvgHisto.length - 1; n > 0; --n) {
                if (!(this.m_arrAvgHisto[n] / (double)this.m_iPermutationSize >= 1.0)) continue;
                f3 = (float)(n + 1) * this.m_fltHistoStep;
                if (!(f3 > 1.0f)) break;
                f3 = 1.0f;
                break;
            }
        }
        AlgorithmData algorithmData2 = new AlgorithmData();
        algorithmData2.addParam("threshold", String.valueOf(f3));
        return algorithmData2;
    }

    public void abort() {
        this.stop = true;
    }
}

