/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.parallelcolt;

import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleCholeskyDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleEigenvalueDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleLUDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleQRDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleSingularValueDecomposition;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.interfaces.HasRowMajorDoubleArray2D;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.parallelcolt.ParallelColtDenseDoubleMatrix2DFactory;
import org.ujmp.parallelcolt.calculation.Solve;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelColtDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<DenseDoubleMatrix2D> {
    private static final long serialVersionUID = -1941030601886654699L;
    public static final ParallelColtDenseDoubleMatrix2DFactory Factory = new ParallelColtDenseDoubleMatrix2DFactory();
    public static final DenseDoubleAlgebra ALG = new DenseDoubleAlgebra();
    private final DenseDoubleMatrix2D matrix;

    public ParallelColtDenseDoubleMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.matrix = new DenseDoubleMatrix2D(rows, columns);
    }

    public ParallelColtDenseDoubleMatrix2D(DoubleMatrix2D m) {
        super((long)m.rows(), (long)m.columns());
        this.matrix = m instanceof org.ujmp.core.doublematrix.DenseDoubleMatrix2D ? (DenseDoubleMatrix2D)m : new DenseDoubleMatrix2D(m.toArray());
    }

    public ParallelColtDenseDoubleMatrix2D(DenseDoubleMatrix2D m) {
        super((long)m.rows(), (long)m.columns());
        this.matrix = m;
    }

    public ParallelColtDenseDoubleMatrix2D(Matrix source) {
        super(source.getRowCount(), source.getColumnCount());
        if (source instanceof HasRowMajorDoubleArray2D) {
            double[][] data = ((HasRowMajorDoubleArray2D)((Object)source)).getRowMajorDoubleArray2D();
            this.matrix = new DenseDoubleMatrix2D(data);
        } else if (source instanceof org.ujmp.core.doublematrix.DenseDoubleMatrix2D) {
            this.matrix = new DenseDoubleMatrix2D((int)source.getRowCount(), (int)source.getColumnCount());
            org.ujmp.core.doublematrix.DenseDoubleMatrix2D m2 = (org.ujmp.core.doublematrix.DenseDoubleMatrix2D)source;
            int r = (int)source.getRowCount();
            while (--r >= 0) {
                int c = (int)source.getColumnCount();
                while (--c >= 0) {
                    this.matrix.setQuick(r, c, m2.getDouble(r, c));
                }
            }
        } else {
            this.matrix = new DenseDoubleMatrix2D((int)source.getRowCount(), (int)source.getColumnCount());
            for (long[] c : source.availableCoordinates()) {
                this.setDouble(source.getAsDouble(c), c);
            }
        }
        if (source.getMetaData() != null) {
            this.setMetaData(source.getMetaData().clone());
        }
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.getQuick((int)row, (int)column);
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.getQuick(row, column);
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.setQuick((int)row, (int)column, value);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.setQuick(row, column, value);
    }

    @Override
    public DenseDoubleMatrix2D getWrappedObject() {
        return this.matrix;
    }

    @Override
    public Matrix plus(double value) {
        ParallelColtDenseDoubleMatrix2D result = new ParallelColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)this.matrix.copy().assign(DoubleFunctions.plus((double)value)));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix inv() {
        return new ParallelColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)ALG.inverse((DoubleMatrix2D)this.matrix));
    }

    @Override
    public Matrix times(double value) {
        ParallelColtDenseDoubleMatrix2D result = new ParallelColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)this.matrix.copy().assign(DoubleFunctions.mult((double)value)));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public Matrix transpose() {
        return new ParallelColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)this.matrix.viewDice().copy());
    }

    @Override
    public Matrix plus(Matrix m) {
        if (m instanceof ParallelColtDenseDoubleMatrix2D) {
            DoubleMatrix2D result = this.matrix.copy();
            result.assign((DoubleMatrix2D)((ParallelColtDenseDoubleMatrix2D)m).getWrappedObject(), DoubleFunctions.plus);
            ParallelColtDenseDoubleMatrix2D ret = new ParallelColtDenseDoubleMatrix2D(result);
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                ret.setMetaData(a.clone());
            }
            return ret;
        }
        return super.plus(m);
    }

    @Override
    public Matrix minus(Matrix m) {
        if (m instanceof ParallelColtDenseDoubleMatrix2D) {
            DoubleMatrix2D result = this.matrix.copy();
            result.assign((DoubleMatrix2D)((ParallelColtDenseDoubleMatrix2D)m).getWrappedObject(), DoubleFunctions.minus);
            ParallelColtDenseDoubleMatrix2D ret = new ParallelColtDenseDoubleMatrix2D(result);
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                ret.setMetaData(a.clone());
            }
            return ret;
        }
        return super.minus(m);
    }

    @Override
    public Matrix mtimes(Matrix m) {
        if (m instanceof ParallelColtDenseDoubleMatrix2D) {
            DenseDoubleMatrix2D ret = new DenseDoubleMatrix2D((int)this.getRowCount(), (int)m.getColumnCount());
            this.matrix.zMult((DoubleMatrix2D)((ParallelColtDenseDoubleMatrix2D)m).matrix, (DoubleMatrix2D)ret);
            ParallelColtDenseDoubleMatrix2D result = new ParallelColtDenseDoubleMatrix2D(ret);
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                result.setMetaData(a.clone());
            }
            return result;
        }
        return super.mtimes(m);
    }

    @Override
    public Matrix[] svd() {
        DenseDoubleSingularValueDecomposition svd = new DenseDoubleSingularValueDecomposition((DoubleMatrix2D)this.matrix, true, false);
        ParallelColtDenseDoubleMatrix2D u = new ParallelColtDenseDoubleMatrix2D(svd.getU());
        ParallelColtDenseDoubleMatrix2D s = new ParallelColtDenseDoubleMatrix2D(svd.getS());
        ParallelColtDenseDoubleMatrix2D v = new ParallelColtDenseDoubleMatrix2D(svd.getV());
        return new Matrix[]{u, s, v};
    }

    @Override
    public Matrix[] eig() {
        DenseDoubleEigenvalueDecomposition eig = new DenseDoubleEigenvalueDecomposition((DoubleMatrix2D)this.matrix);
        ParallelColtDenseDoubleMatrix2D v = new ParallelColtDenseDoubleMatrix2D(eig.getV());
        ParallelColtDenseDoubleMatrix2D d = new ParallelColtDenseDoubleMatrix2D(eig.getD());
        return new Matrix[]{v, d};
    }

    @Override
    public Matrix[] qr() {
        DenseDoubleQRDecomposition qr = new DenseDoubleQRDecomposition((DoubleMatrix2D)this.matrix);
        ParallelColtDenseDoubleMatrix2D q = new ParallelColtDenseDoubleMatrix2D(qr.getQ(false));
        ParallelColtDenseDoubleMatrix2D r = new ParallelColtDenseDoubleMatrix2D(qr.getR(false));
        return new Matrix[]{q, r};
    }

    @Override
    public Matrix[] lu() {
        if (this.getRowCount() >= this.getColumnCount()) {
            DenseDoubleLUDecomposition lu = new DenseDoubleLUDecomposition((DoubleMatrix2D)this.matrix);
            ParallelColtDenseDoubleMatrix2D l = new ParallelColtDenseDoubleMatrix2D(lu.getL());
            ParallelColtDenseDoubleMatrix2D u = new ParallelColtDenseDoubleMatrix2D(lu.getU().viewPart(0, 0, (int)this.getColumnCount(), (int)this.getColumnCount()));
            int m = (int)this.getRowCount();
            int[] piv = lu.getPivot();
            ParallelColtDenseDoubleMatrix2D p = new ParallelColtDenseDoubleMatrix2D(m, m);
            for (int i = 0; i < m; ++i) {
                p.setAsDouble(1.0, new long[]{i, piv[i]});
            }
            return new Matrix[]{l, u, p};
        }
        throw new RuntimeException("only supported for matrices m>=n");
    }

    @Override
    public Matrix chol() {
        DenseDoubleCholeskyDecomposition chol = new DenseDoubleCholeskyDecomposition((DoubleMatrix2D)this.matrix);
        ParallelColtDenseDoubleMatrix2D r = new ParallelColtDenseDoubleMatrix2D(chol.getL());
        return r;
    }

    public Matrix copy() {
        ParallelColtDenseDoubleMatrix2D m = new ParallelColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)this.matrix.copy());
        if (this.getMetaData() != null) {
            m.setMetaData(this.getMetaData().clone());
        }
        return m;
    }

    @Override
    public Matrix solve(Matrix b) {
        return Solve.INSTANCE.calc(this, b);
    }

    @Override
    public Matrix solveSPD(Matrix b) {
        if (b instanceof ParallelColtDenseDoubleMatrix2D) {
            ParallelColtDenseDoubleMatrix2D b2 = new ParallelColtDenseDoubleMatrix2D(b);
            DenseDoubleCholeskyDecomposition chol = new DenseDoubleCholeskyDecomposition((DoubleMatrix2D)this.matrix);
            chol.solve((DoubleMatrix2D)b2.matrix);
            return b2;
        }
        return super.solve(b);
    }

    @Override
    public Matrix invSPD() {
        DenseDoubleCholeskyDecomposition chol = new DenseDoubleCholeskyDecomposition((DoubleMatrix2D)this.matrix);
        DoubleMatrix2D ret = DoubleFactory2D.dense.identity(this.matrix.rows());
        chol.solve(ret);
        return new ParallelColtDenseDoubleMatrix2D(ret);
    }

    public ParallelColtDenseDoubleMatrix2DFactory getFactory() {
        return Factory;
    }
}

