/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.bytematrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.bytematrix.stub.AbstractDenseByteMatrix2D;

public class ArrayDenseByteMatrix2D
extends AbstractDenseByteMatrix2D {
    private static final long serialVersionUID = 1111734188254187991L;
    private final byte[][] values;

    public ArrayDenseByteMatrix2D(byte[] ... v) {
        super((long)v.length, (long)v[0].length);
        this.values = v;
    }

    public ArrayDenseByteMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.values = new byte[rows][columns];
    }

    public ArrayDenseByteMatrix2D(byte[] v) {
        super((long)v.length, 1L);
        this.values = new byte[v.length][1];
        int r = v.length;
        while (--r >= 0) {
            this.values[r][0] = v[r];
        }
    }

    public byte getByte(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    public void setByte(byte value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    public byte getByte(int row, int column) {
        return this.values[row][column];
    }

    public void setByte(byte value, int row, int column) {
        this.values[row][column] = value;
    }

    public final Matrix transpose() {
        byte[][] result = new byte[this.values[0].length][this.values.length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[c][r];
            }
        }
        return new ArrayDenseByteMatrix2D(result);
    }
}

