/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.apache.log4j.Logger;
import xtools.api.param.ParamHelper;
import xtools.api.param.StringReqdParam;

public class FeatureSpaceReqdParam
extends StringReqdParam
implements ActionListener {
    private static final Logger klog = Logger.getLogger(FeatureSpaceReqdParam.class);
    private static String[] MODES = new String[]{"Remap_Only", "Collapse", "No_Collapse"};

    public FeatureSpaceReqdParam() {
        super("collapse", "Collapse/Remap to gene symbols", "Perform the analysis in the specified feature space - either gene symbols or as is (any mappings required will be done internally using the Chip/Platform specified)", MODES[1], MODES);
    }

    public FeatureSpaceReqdParam(String def) {
        super("collapse", "Collapse/Remap to gene symbols", "Perform the analysis in the specified feature space - either gene symbols or as is (any mappings required will be done internally using the Chip/Platform specified)", def, MODES);
    }

    @Override
    public void setValue(Object value) {
        if ("true".equals(value)) {
            value = "Collapse";
        }
        if ("false".equals(value)) {
            value = "No_Collapse";
        }
        super.setValue(value);
    }

    public boolean isSymbols() {
        int index = this.getStringIndexChoosen();
        return index <= 1;
    }

    public boolean isRemap() {
        int index = this.getStringIndexChoosen();
        return index == 0;
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.cbOptions == null) {
            this.cbOptions = ParamHelper.createActionListenerBoundHintsComboBox(false, this, this);
            ParamHelper.safeSelectValueDefaultByString(this.cbOptions.getComboBox(), this);
            this.cbOptions.getComboBox().setRenderer(new MyListRenderer());
        }
        return this.cbOptions;
    }

    public static class MyListRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (index == 0) {
                this.setText(MODES[0] + " (remap dataset with 'chip' without mathematical collapse)");
            } else if (index == 1) {
                this.setText(MODES[1] + " (use 'chip' to collapse dataset to symbols before analysis)");
            } else if (index == 2) {
                this.setText(MODES[2] + " (use dataset 'as is' in the original format)");
            }
            return this;
        }
    }
}

