/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing;

import edu.mit.broad.genome.Conf;
import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.io.LoopedStreams;
import edu.mit.broad.xbench.core.api.Application;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import javax.swing.JTextArea;
import javax.swing.text.Document;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.OutputStreamAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import xapps.api.frameworks.fiji.StatusBarAppender;

public class SystemConsole
extends JTextArea {
    public SystemConsole() {
        this.setText("< Process output will appear below >\n\n");
        if (!Conf.isDebugMode()) {
            try {
                LoopedStreams ls = new LoopedStreams();
                PrintStream ps = new PrintStream(ls.getOutputStream());
                System.setOut(ps);
                System.setErr(ps);
                SystemConsole.addAppender(ps, "ConsoleViewer");
                this.startConsoleReaderThread(ls.getInputStream());
                this.setAutoscrolls(true);
            }
            catch (Throwable t) {
                this.setText("Could not open system console properly. Error: " + TraceUtils.getAsString(t));
            }
        } else {
            System.out.println("Skipping sysout redirection as in debug mode");
        }
    }

    public static void addAppender(OutputStream outputStream, String outputStreamName) {
        LoggerContext context = LoggerContext.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern("%-8r [%-6p] - %m%n").build();
        OutputStreamAppender appender = OutputStreamAppender.createAppender((Layout)layout, null, (OutputStream)outputStream, (String)outputStreamName, (boolean)false, (boolean)true);
        appender.start();
        config.addAppender((Appender)appender);
        SystemConsole.updateLoggers((Appender)appender, config);
    }

    public static StatusBarAppender createStatusBarAppender(String name) {
        LoggerContext context = LoggerContext.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern("%-8r [%-6p] - %m%n").build();
        StatusBarAppender statusBar = new StatusBarAppender(name, null, (Layout<? extends Serializable>)layout);
        statusBar.start();
        config.addAppender((Appender)statusBar);
        SystemConsole.updateLoggers((Appender)statusBar, config);
        return statusBar;
    }

    public static void updateLoggers(Appender appender, Configuration config) {
        Level level = null;
        Filter filter = null;
        for (LoggerConfig loggerConfig : config.getLoggers().values()) {
            loggerConfig.addAppender(appender, level, filter);
        }
        config.getRootLogger().addAppender(appender, level, filter);
    }

    private void startConsoleReaderThread(InputStream inStream) {
        final BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        new Thread(new Runnable(){

            @Override
            public void run() {
                char[] buff = new char[256];
                try {
                    int count;
                    Document doc = SystemConsole.this.getDocument();
                    while (-1 != (count = reader.read(buff, 0, buff.length))) {
                        SystemConsole.this.append(String.valueOf(buff, 0, count));
                        SystemConsole.this.setCaretPosition(doc.getLength());
                    }
                }
                catch (IOException e) {
                    Application.getWindowManager().showMessage(null, "Error reading from BufferedReader: " + e);
                }
            }
        }).start();
    }
}

