/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.math.DoubleElement;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.DefaultRankedList;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.MetricWeightStruc;
import edu.mit.broad.genome.objects.PersistentObject;
import gnu.trove.TFloatArrayList;
import java.util.ArrayList;
import java.util.List;

public interface RankedList
extends PersistentObject {
    public RankedList cloneShallowRL(String var1);

    public int getSize();

    public int getSize(ScoreMode var1);

    public float getScore(int var1);

    public float getScore(String var1);

    public float[] getScores(GeneSet var1);

    public Vector getScoresV(boolean var1);

    public int getRank(String var1);

    public String getRankName(int var1);

    public List getRankedNames();

    public String[] getRankedNamesArray();

    public List getNamesOfUpOrDnXRanks(int var1, boolean var2);

    public RankedList extractRanked(GeneSet var1);

    public RankedList extractRanked(ScoreMode var1);

    public MetricWeightStruc getMetricWeightStruc();

    public static class Helper {
        public static RankedList extract(GeneSet gset, RankedList rl) {
            DoubleElement[] dels = new DoubleElement[gset.getNumMembers()];
            for (int i = 0; i < gset.getNumMembers(); ++i) {
                int rank = rl.getRank(gset.getMember(i));
                dels[i] = new DoubleElement(i, rank);
            }
            dels = DoubleElement.sort(SortMode.REAL, Order.ASCENDING, dels);
            ArrayList<String> rankedLabels = new ArrayList<String>();
            Vector rankedScores = new Vector(dels.length);
            for (int i = 0; i < dels.length; ++i) {
                String name = gset.getMember(dels[i].fIndex);
                rankedLabels.add(name);
                rankedScores.setElement(i, rl.getScore(name));
            }
            return new DefaultRankedList(gset.getName(true), rankedLabels, rankedScores, true, true);
        }

        public static List getLabelsOfUpOrDnXRanks(int upOrDnX, boolean up, RankedList rl) {
            ArrayList<String> list = new ArrayList<String>();
            if (upOrDnX > rl.getSize()) {
                upOrDnX = rl.getSize();
            }
            if (up) {
                for (int r = 0; r < upOrDnX; ++r) {
                    list.add(rl.getRankName(r));
                }
            } else {
                int start = rl.getSize() - 1;
                for (int r = 0; r < upOrDnX; ++r) {
                    list.add(rl.getRankName(start));
                    --start;
                }
            }
            return list;
        }

        public static RankedList extractRanked(ScoreMode smode, RankedList rl) {
            ArrayList<String> rankedNames = new ArrayList<String>();
            TFloatArrayList rankedScores = new TFloatArrayList();
            String suffix = smode.getName();
            for (int i = 0; i < rl.getSize(); ++i) {
                float score = rl.getScore(i);
                if (smode.isPostiveOnly() && XMath.isPositive(score)) {
                    rankedNames.add(rl.getRankName(i));
                    rankedScores.add(score);
                    continue;
                }
                if (!smode.isNegativeOnly() || !XMath.isNegative(score)) continue;
                rankedNames.add(rl.getRankName(i));
                rankedScores.add(score);
            }
            return new DefaultRankedList(rl.getName() + "_" + suffix, rankedNames, rankedScores);
        }
    }
}

