/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.objects.Id;
import edu.mit.broad.genome.objects.PersistentObject;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class AbstractObject
implements PersistentObject {
    private String fName;
    private String fNameEnglish;
    private Id fId;
    private StringBuffer fComment;
    protected transient Logger log;
    private boolean fInited;
    private Properties prp;

    protected AbstractObject(String name) {
        this.initialize(Id.createId(), name);
    }

    protected AbstractObject() {
        this.log = Logger.getLogger(this.getClass());
    }

    protected void initialize(Id id, String name) {
        this.initialize(id, name, null);
    }

    protected void initialize(Id id, String name, String nameEnglish) {
        if (this.fInited) {
            throw new IllegalStateException("Already initialized. disp name " + name);
        }
        if (id == null) {
            throw new NullPointerException("Parameter id cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("Parameter name cannot be null");
        }
        this.log = Logger.getLogger(this.getClass());
        this.fId = id;
        this.fName = this.removeExtension(name);
        if (nameEnglish != null) {
            this.fNameEnglish = this.removeExtension(nameEnglish);
        }
        this.fInited = true;
    }

    protected void initialize(String name) {
        this.initialize(Id.createId(), name);
    }

    protected void initialize(String name, String nameEnglish) {
        this.initialize(Id.createId(), name, nameEnglish);
    }

    protected boolean isInited() {
        return this.fInited;
    }

    private String removeExtension(String name) {
        return name;
    }

    @Override
    public Id getId() {
        this.checkInit();
        return this.fId;
    }

    private void checkInit() {
        if (!this.fInited) {
            throw new IllegalStateException("Uninitialized: " + this.fName);
        }
    }

    @Override
    public String getName() {
        this.checkInit();
        return this.fName;
    }

    @Override
    public String getNameEnglish() {
        this.checkInit();
        return this.fNameEnglish;
    }

    @Override
    public String getComment() {
        if (this.fComment == null) {
            return "";
        }
        return this.fComment.toString();
    }

    @Override
    public void addComment(String comment) {
        if (this.fComment == null) {
            this.fComment = new StringBuffer(comment);
        }
    }

    protected void setName(String newname) {
        if (newname == null) {
            this.log.warn((Object)"Ignoring rename request as newname is null");
        } else {
            this.fName = newname;
        }
    }

    public void setProperty(String key, String value) {
        if (this.prp == null) {
            this.prp = new Properties();
        }
        this.prp.put(key, value);
    }
}

