/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.math;

import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.Vector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.function.BiFunction;
import org.apache.log4j.Logger;

public class XMath {
    private static final Logger klog = Logger.getLogger(XMath.class);

    private XMath() {
    }

    public static boolean isAscending(int[] ints) {
        for (int i = 0; i < ints.length - 1; ++i) {
            int nextValue = ints[i + 1];
            int thisValue = ints[i];
            if (nextValue >= thisValue) continue;
            return false;
        }
        return true;
    }

    public static float getFWERTwoTailed(float realScore, Matrix rndScores) {
        if (XMath.isPositive(realScore)) {
            return XMath.getFWER(realScore, rndScores, true);
        }
        return XMath.getFWERLessThan(realScore, rndScores);
    }

    public static float getFWER(float realScore, Matrix rndScores, boolean pos) {
        Vector best_of_each_perm = pos ? rndScores.getColumnMaxes() : rndScores.getColumnMins();
        double fwer = pos ? XMath.getPValue(realScore, best_of_each_perm) : XMath.getPValueLessThan(realScore, best_of_each_perm);
        return (float)fwer;
    }

    public static float getFWERLessThan(float realScore, Matrix rndScores) {
        Vector lowest_of_each_perm = new Vector(rndScores.getNumCol());
        for (int c = 0; c < rndScores.getNumCol(); ++c) {
            lowest_of_each_perm.setElement(c, rndScores.getColumnV(c).min());
        }
        return (float)XMath.getPValueLessThan(realScore, lowest_of_each_perm);
    }

    public static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public static boolean isSameSign(float a, float b) {
        if (a < 0.0f && b < 0.0f) {
            return true;
        }
        if (a == 0.0f && b == 0.0f) {
            return true;
        }
        return a > 0.0f && b > 0.0f;
    }

    public static boolean isEven(int x) {
        return (float)(x / 2) == (float)x / 2.0f;
    }

    public static boolean isPositive(float x) {
        return x >= 0.0f;
    }

    public static boolean isPositive(double x) {
        return x >= 0.0;
    }

    public static boolean isNegative(float x) {
        return x <= 0.0f;
    }

    public static int[] toIndices(int maxIndex, boolean inclusive) {
        if (maxIndex <= 0) {
            throw new IllegalArgumentException("Specified max for indices must be more than 0, got: " + maxIndex);
        }
        int till = inclusive ? maxIndex + 1 : maxIndex;
        int[] inds = new int[till];
        for (int i = 0; i < till; ++i) {
            inds[i] = i;
        }
        return inds;
    }

    public static int[] randomizeWithoutReplacement(int num, RandomSeedGenerator rsgen) {
        return XMath.randomizeWithoutReplacement(num, rsgen.getRandom());
    }

    public static int[] randomizeWithoutReplacement(int num, Random rnd) {
        ArrayList<Integer> seen = new ArrayList<Integer>(num);
        int[] inds = new int[num];
        int cnt = 0;
        int i = 0;
        while (i < num) {
            int r = rnd.nextInt(num);
            if (seen.contains(new Integer(r))) continue;
            seen.add(new Integer(r));
            inds[cnt++] = r;
            if (cnt != num) continue;
            break;
        }
        return inds;
    }

    public static int[] randomlySampleWithoutReplacement(int numRndNeeded, int highestrandomnumExclusive, RandomSeedGenerator rsgen) {
        return XMath.randomlySampleWithoutReplacement(numRndNeeded, highestrandomnumExclusive, rsgen.getRandom());
    }

    public static int[] randomlySampleWithoutReplacement(int numRndNeeded, int maxRndNumExclusive, Random rnd) {
        if (maxRndNumExclusive == numRndNeeded) {
            return XMath.toIndices(maxRndNumExclusive, false);
        }
        if (numRndNeeded > maxRndNumExclusive) {
            throw new IllegalArgumentException("Cannot pick more numbers (no replacement) numRndNeeded: " + numRndNeeded + " than max possible number maxRndNumExclusive: " + maxRndNumExclusive);
        }
        ArrayList<Integer> seen = new ArrayList<Integer>(numRndNeeded);
        int[] inds = new int[numRndNeeded];
        int cnt = 0;
        int i = 0;
        while (i < numRndNeeded) {
            int r = rnd.nextInt(maxRndNumExclusive);
            if (seen.contains(new Integer(r))) continue;
            seen.add(new Integer(r));
            inds[cnt++] = r;
            if (cnt != numRndNeeded) continue;
            break;
        }
        return inds;
    }

    public static double getPValue(float score, float[] values) {
        int cntmore = 0;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] > score)) continue;
            ++cntmore;
        }
        return (double)cntmore / (double)values.length;
    }

    public static double getPValueLessThan(float score, float[] values) {
        int cntless = 0;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] < score)) continue;
            ++cntless;
        }
        return (double)cntless / (double)values.length;
    }

    public static double getPValue(float score, Vector values) {
        return XMath.getPValue(score, values.elementData);
    }

    public static double getPValueLessThan(float score, Vector values) {
        return XMath.getPValueLessThan(score, values.elementData);
    }

    public static double getPValueTwoTailed(float score, float[] values) {
        int cnt = 0;
        if (score >= 0.0f) {
            for (int i = 0; i < values.length; ++i) {
                if (!(values[i] > score)) continue;
                ++cnt;
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                if (!(values[i] < score)) continue;
                ++cnt;
            }
        }
        return (double)cnt / (double)values.length;
    }

    public static double getPValueTwoTailed(float score, Vector values) {
        return XMath.getPValueTwoTailed(score, values.elementData);
    }

    public static float getPValueTwoTailed_pos_neg_seperate(float realEs, Vector rndEs) {
        Vector ex = rndEs.extract(realEs, ScoreMode.POS_AND_NEG_SEPERATELY);
        return (float)XMath.getPValueTwoTailed(realEs, ex);
    }

    public static float max(float[] values) {
        if (values.length == 0) {
            klog.warn((Object)"FIX ME Zero length array");
            throw new IllegalArgumentException("Zero length array not allowed");
        }
        float max = values[0];
        for (int i = 0; i < values.length; ++i) {
            if (!(max < values[i])) continue;
            max = values[i];
        }
        return max;
    }

    public static int min(int a, int b) {
        return XMath.min(new int[]{a, b});
    }

    public static int min(int[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Zero length array not allowed");
        }
        int min = values[0];
        for (int i = 0; i < values.length; ++i) {
            if (min <= values[i]) continue;
            min = values[i];
        }
        return min;
    }

    private static void enforceEqualSize(Vector x, Vector y) {
        if (x.getSize() != y.getSize()) {
            throw new IllegalArgumentException("Vector lengths not equal x=" + x.getSize() + " and y=" + y.getSize());
        }
    }

    private static void enforceEqualSize(Vector[] vss) {
        if (vss.length == 0) {
            return;
        }
        int size = vss[0].getSize();
        for (int i = 0; i < vss.length; ++i) {
            if (vss[i].getSize() == size) continue;
            throw new IllegalArgumentException("Vector lengths not equal first=" + size + " and y=" + vss[i].getSize() + " at index " + i);
        }
    }

    private static void enforceEqualSize(float[] x, float[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Vector lengths not equal x=" + x.length + " and y=" + y.length);
        }
    }

    public static double euclidean(Vector x, Vector y) {
        XMath.enforceEqualSize(x, y);
        float sum = 0.0f;
        for (int i = 0; i < x.getSize(); ++i) {
            float diff = x.getElement(i) - y.getElement(i);
            sum += diff * diff;
        }
        return Math.sqrt(sum);
    }

    public static double manhatten(Vector x, Vector y) {
        XMath.enforceEqualSize(x, y);
        double sum = 0.0;
        for (int i = 0; i < x.getSize(); ++i) {
            sum += (double)Math.abs(x.getElement(i) - y.getElement(i));
        }
        return sum;
    }

    public static double meansdiff(Vector x, Vector y) {
        return x.mean() - y.mean();
    }

    public static double meansratio(Vector x, Vector y) {
        return x.mean() / y.mean();
    }

    public static double mediansratio(Vector x, Vector y) {
        return x.median() / y.median();
    }

    public static double meanOrMedianRatio(Vector x, Vector y, boolean useMean) {
        return x.meanOrMedian(useMean) / y.meanOrMedian(useMean);
    }

    public static double meanOrMedianDiff(Vector x, Vector y, boolean useMean) {
        return x.meanOrMedian(useMean) - y.meanOrMedian(useMean);
    }

    public static double mediansdiff(Vector x, Vector y) {
        return x.median() - y.median();
    }

    public static Vector medianVector(Vector[] vss) {
        XMath.enforceEqualSize(vss);
        int size = vss[0].getSize();
        float[] medians = new float[size];
        for (int i = 0; i < size; ++i) {
            Vector v = new Vector(vss.length);
            for (int c = 0; c < vss.length; ++c) {
                v.setElement(c, vss[c].getElement(i));
            }
            medians[i] = (float)v.median();
        }
        return new Vector(medians);
    }

    public static Vector meanVector(Vector[] vss) {
        XMath.enforceEqualSize(vss);
        int size = vss[0].getSize();
        float[] means = new float[size];
        for (int i = 0; i < size; ++i) {
            Vector v = new Vector(vss.length);
            for (int c = 0; c < vss.length; ++c) {
                v.setElement(c, vss[c].getElement(i));
            }
            means[i] = (float)v.mean();
        }
        return new Vector(means);
    }

    public static Vector maxVector(Vector[] vss) {
        XMath.enforceEqualSize(vss);
        int size = vss[0].getSize();
        float[] maxs = new float[size];
        for (int i = 0; i < size; ++i) {
            Vector v = new Vector(vss.length);
            for (int c = 0; c < vss.length; ++c) {
                v.setElement(c, vss[c].getElement(i));
            }
            maxs[i] = v.max();
        }
        return new Vector(maxs);
    }

    public static Vector sumVector(Vector[] vss) {
        XMath.enforceEqualSize(vss);
        int size = vss[0].getSize();
        float[] sums = new float[size];
        for (int i = 0; i < size; ++i) {
            Vector v = new Vector(vss.length);
            for (int c = 0; c < vss.length; ++c) {
                v.setElement(c, vss[c].getElement(i));
            }
            sums[i] = (float)v.sum();
        }
        return new Vector(sums);
    }

    public static float median(float[] x) {
        if (x.length == 0) {
            return Float.NaN;
        }
        int aLen = x.length;
        float[] v1 = new float[aLen];
        System.arraycopy(x, 0, v1, 0, aLen);
        Arrays.sort(v1);
        int ind = (aLen - 1) / 2;
        if (XMath.isEven(aLen)) {
            return (v1[ind] + v1[aLen / 2]) / 2.0f;
        }
        return v1[ind];
    }

    public static float mean(float[] x) {
        if (x.length == 0) {
            return Float.NaN;
        }
        return XMath.sum(x) / (float)x.length;
    }

    public static float sum(float[] x) {
        float sum = 0.0f;
        for (float f : x) {
            sum += f;
        }
        return sum;
    }

    public static double pearson(Vector x, Vector y) {
        XMath.enforceEqualSize(x, y);
        double N = x.getSize();
        if (N == 0.0 || N == 1.0) {
            return Double.NaN;
        }
        double numr = x.sumprod(y) - x.sum() * y.sum() / N;
        double denr = (x.squaresum() - x.sum() * x.sum() / N) * (y.squaresum() - y.sum() * y.sum() / N);
        denr = Math.sqrt(denr);
        return numr / denr;
    }

    public static double regressionSlope(Vector x, Vector yTemplate, Vector[] splits, boolean biased, boolean fixlow) {
        XMath.enforceEqualSize(x, yTemplate);
        double xsum = x.sum();
        double N = x.getSize();
        double numrA = N * x.sumprod(yTemplate);
        double numrB = xsum * yTemplate.sum();
        double denrA = N * x.squaresum();
        double denrB = xsum * xsum;
        double C = (numrA - numrB) / (denrA - denrB);
        double var = 0.0;
        for (int i = 0; i < splits.length; ++i) {
            var += splits[i].stddev(biased, fixlow);
        }
        if (var == 0.0) {
            return Double.NaN;
        }
        return C / var;
    }

    public static double cosine(Vector x, Vector y) {
        return XMath.cosine(x.elementData, y.elementData);
    }

    public static double cosine(float[] x, float[] y) {
        XMath.enforceEqualSize(x, y);
        double mag_x = 0.0;
        double mag_y = 0.0;
        double sump = 0.0;
        for (int i = 0; i < x.length; ++i) {
            mag_x += (double)(x[i] * x[i]);
            mag_y += (double)(y[i] * y[i]);
            sump += (double)(x[i] * y[i]);
        }
        return 1.0 - sump / Math.sqrt(mag_x * mag_y);
    }

    public static double s2n(Vector x, Vector y, boolean usebiased, boolean usemedian, boolean fixlow) {
        double s2n = usemedian ? (x.median() - y.median()) / (x.stddev(usebiased, fixlow) + y.stddev(usebiased, fixlow)) : (x.mean() - y.mean()) / (x.stddev(usebiased, fixlow) + y.stddev(usebiased, fixlow));
        return s2n;
    }

    public static final BiFunction<Vector, Vector, Double> getS2n(boolean usebiased, boolean usemedian, boolean fixlow) {
        if (usemedian) {
            if (usebiased) {
                if (fixlow) {
                    return (x, y) -> XMath.s2nMedianBiasedFixLow(x, y);
                }
                return (x, y) -> XMath.s2nMedianBiasedNotFixLow(x, y);
            }
            if (fixlow) {
                return (x, y) -> XMath.s2nMedianUnBiasedFixLow(x, y);
            }
            return (x, y) -> XMath.s2nMedianUnBiasedNotFixLow(x, y);
        }
        if (usebiased) {
            if (fixlow) {
                return (x, y) -> XMath.s2nMeanBiasedFixLow(x, y);
            }
            return (x, y) -> XMath.s2nMeanBiasedNotFixLow(x, y);
        }
        if (fixlow) {
            return (x, y) -> XMath.s2nMeanUnBiasedFixLow(x, y);
        }
        return (x, y) -> XMath.s2nMeanUnBiasedNotFixLow(x, y);
    }

    public static double s2nMeanBiasedFixLow(Vector x, Vector y) {
        return (x.mean() - y.mean()) / (x.stddevBiasedFixLow() + y.stddevBiasedFixLow());
    }

    public static double s2nMeanUnBiasedFixLow(Vector x, Vector y) {
        return (x.mean() - y.mean()) / (x.stddevUnBiasedFixLow() + y.stddevUnBiasedFixLow());
    }

    public static double s2nMeanBiasedNotFixLow(Vector x, Vector y) {
        return (x.mean() - y.mean()) / (x.stddevBiasedNotFixLow() + y.stddevBiasedNotFixLow());
    }

    public static double s2nMeanUnBiasedNotFixLow(Vector x, Vector y) {
        return (x.mean() - y.mean()) / (x.stddevUnBiasedNotFixLow() + y.stddevUnBiasedNotFixLow());
    }

    public static double s2nMedianBiasedFixLow(Vector x, Vector y) {
        return (x.median() - y.median()) / (x.stddevBiasedFixLow() + y.stddevBiasedFixLow());
    }

    public static double s2nMedianUnBiasedFixLow(Vector x, Vector y) {
        return (x.median() - y.median()) / (x.stddevUnBiasedFixLow() + y.stddevUnBiasedFixLow());
    }

    public static double s2nMedianBiasedNotFixLow(Vector x, Vector y) {
        return (x.median() - y.median()) / (x.stddevBiasedNotFixLow() + y.stddevBiasedNotFixLow());
    }

    public static double s2nMedianUnBiasedNotFixLow(Vector x, Vector y) {
        return (x.median() - y.median()) / (x.stddevUnBiasedNotFixLow() + y.stddevUnBiasedNotFixLow());
    }

    public static double tTest(Vector x, Vector y, boolean usebiased, boolean usemedian, boolean fixlow) {
        double numr = usemedian ? x.median() - y.median() : x.mean() - y.mean();
        double denr = usebiased ? Math.sqrt(x.var(usebiased, fixlow) / (double)(x.getSize() - 1) + y.var(usebiased, fixlow) / (double)(y.getSize() - 1)) : Math.sqrt(x.var(usebiased, fixlow) / (double)x.getSize() + y.var(usebiased, fixlow) / (double)y.getSize());
        return numr / denr;
    }

    public static double bhat(Vector v1, Vector v2, boolean usebiased, boolean fixlow) {
        double firstterm = (v2.mean() - v1.mean()) * (0.5 / (v1.var(usebiased, fixlow) + v2.var(usebiased, fixlow))) * (v2.mean() - v1.mean());
        double secterm = 0.5 * Math.log((v1.var(usebiased, fixlow) + v2.var(usebiased, fixlow)) / 2.0 / Math.sqrt(v1.var(usebiased, fixlow) * v2.var(usebiased, fixlow)));
        return firstterm + secterm;
    }

    public static double pearsonD(Vector minusplusvec, Vector y) {
        XMath.enforceEqualSize(minusplusvec, y);
        for (int i = 0; i < minusplusvec.getSize(); ++i) {
            if (minusplusvec.getElement(i) == -1.0f && minusplusvec.getElement(i) == 1.0f) continue;
            throw new IllegalArgumentException("MinusPlus vector has invalid element: " + minusplusvec.getElement(i) + " only -1 and +1 allowed");
        }
        Vector v = new Vector(y);
        v.pnormalize();
        return 1.0 - XMath.pearson(minusplusvec, v);
    }

    public static double mannWhitney(int[] hitIndices, int totSize) {
        double sr = 0.0;
        for (int i = 0; i < hitIndices.length; ++i) {
            sr += (double)hitIndices[i];
        }
        double N = hitIndices.length;
        double term1 = sr / N;
        double st = totSize * (totSize - 1) / 2;
        double d = totSize;
        double term2 = (st - sr) / (d - N);
        double mw = term1 - term2;
        return -1.0 * mw;
    }

    public static int getMoreThanCount(float value, Vector sorted_pos_to_neg) {
        int cnt = 0;
        for (int i = 0; i < sorted_pos_to_neg.getSize() && !(value > sorted_pos_to_neg.getElement(i)); ++i) {
            ++cnt;
        }
        return cnt;
    }

    public static int getLessThanCount(float value, Vector sorted_low_to_high) {
        int cnt = 0;
        for (int i = 0; i < sorted_low_to_high.getSize() && !(value < sorted_low_to_high.getElement(i)); ++i) {
            ++cnt;
        }
        return cnt;
    }
}

