/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.MismatchedSizeException;
import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.alg.DatasetMetrics;
import edu.mit.broad.genome.alg.GeneSetGenerators;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.Metrics;
import edu.mit.broad.genome.alg.gsea.GeneSetCohort;
import edu.mit.broad.genome.alg.gsea.GeneSetCohortGenerator;
import edu.mit.broad.genome.alg.gsea.KSCore;
import edu.mit.broad.genome.alg.markers.PermutationTestBuilder;
import edu.mit.broad.genome.math.LabelledVectorProcessor;
import edu.mit.broad.genome.math.LabelledVectorProcessors;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateFactoryRandomizer;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDbImplWithPermTest;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDbImpl_one_shared_rl;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResultImpl;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentScore;
import edu.mit.broad.genome.objects.strucs.DatasetTemplate;
import edu.mit.broad.genome.objects.strucs.TemplateRandomizerType;
import edu.mit.broad.vdb.chip.Chip;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class KSTests {
    private final Logger log = Logger.getLogger(this.getClass());
    private final KSCore core;
    private static final int LOG_FREQ = 5;
    private PrintStream sout;

    public KSTests(PrintStream os) {
        this.sout = os;
        this.core = new KSCore();
    }

    public KSTests() {
        this(System.out);
    }

    public EnrichmentDb executeGsea(DatasetTemplate dt, GeneSet[] gsets, int nperm, Metric metric, SortMode sort, Order order, LabelledVectorProcessor lvp, RandomSeedGenerator rst, TemplateRandomizerType rt, Map mps, GeneSetCohortGenerator gcohgen, boolean permuteTemplate, int numMarkers, List store_rnd_ranked_lists_here_opt) throws Exception {
        return this.executeGsea(dt.getDataset(false), dt.getTemplate(), gsets, nperm, metric, sort, order, lvp, rst, rt, mps, gcohgen, permuteTemplate, numMarkers, store_rnd_ranked_lists_here_opt);
    }

    public EnrichmentDb executeGsea(Dataset ds, Template t, GeneSet[] gsets, int nperm, Metric metric, SortMode sort, Order order, LabelledVectorProcessor lvp, RandomSeedGenerator rst, TemplateRandomizerType rt, Map mps, GeneSetCohortGenerator gcohgen, boolean permuteTemplate, int numMarkers, List store_rnd_ranked_lists_here_opt) {
        this.log.debug((Object)("!!!! Executing for: " + ds.getName() + " # samples: " + ds.getNumCol()));
        EnrichmentDb edb = permuteTemplate ? this.shuffleTemplate(nperm, metric, sort, order, mps, lvp, ds, t, gsets, gcohgen, rt, rst, numMarkers, store_rnd_ranked_lists_here_opt) : this.shuffleGeneSet(nperm, metric, sort, order, mps, lvp, ds, t, gsets, gcohgen, rst);
        this.sout.println("Finished permutations ... creating reports");
        return edb;
    }

    public EnrichmentDb executeGsea(RankedList rl_real, GeneSet[] gsets, int nperm, RandomSeedGenerator rst, Chip chip, GeneSetCohortGenerator gcohgen) throws Exception {
        this.log.debug((Object)("!!!! Executing for: " + rl_real.getName() + " # features: " + rl_real.getSize()));
        EnrichmentResult[] results = this.shuffleGeneSet_precannedRankedList(nperm, rl_real, null, gsets, chip, gcohgen, rst);
        return new EnrichmentDbImpl_one_shared_rl(rl_real.getName(), rl_real, null, null, results, new LabelledVectorProcessors.None(), new Metrics.None(), new HashMap(), SortMode.REAL, Order.DESCENDING, nperm, null);
    }

    public EnrichmentDb shuffleTemplate(int nperm, Metric metric, SortMode sort, Order order, Map metricParams, LabelledVectorProcessor lvp, Dataset ds, Template template, GeneSet[] gsets, GeneSetCohortGenerator gcohgen, TemplateRandomizerType rt, RandomSeedGenerator rst, int numMarkers, List store_rnd_ranked_lists_here_opt) {
        Template[] rndTemplates = TemplateFactoryRandomizer.createRandomTemplates(nperm, template, rt, rst);
        this.log.debug((Object)("Done generating rnd templates: " + rndTemplates.length));
        return this.shuffleTemplate_canned_templates(metric, sort, order, metricParams, lvp, ds, template, gsets, gcohgen, rndTemplates, null, null, numMarkers, store_rnd_ranked_lists_here_opt);
    }

    public EnrichmentDb shuffleTemplate_canned_templates(Metric metric, SortMode sort, Order order, Map metricParams, LabelledVectorProcessor lvp, Dataset ds, Template template, GeneSet[] gsets, GeneSetCohortGenerator gcohgen, Template[] rndTemplates, RankedList realRankedList_pre_calculated_opt, RankedList[] rndRankedLists_pre_calculated_opt, int numMarkers, List store_rnd_ranked_lists_here_opt) {
        this.log.debug((Object)("shuffleTemplate with -- nperm: " + rndTemplates.length + " Order: " + order + " Sort: " + sort + " gsets: " + gsets.length));
        String dstName = NamingConventions.generateName(ds, template, true);
        Chip chip = ds.getAnnot().getChip();
        DatasetMetrics dm = new DatasetMetrics();
        PermutationTestBuilder ptest = new PermutationTestBuilder(dstName, numMarkers, rndTemplates.length, lvp, metric, sort, order, metricParams, ds, template, null, template.isCategorical());
        RankedList rlReal = realRankedList_pre_calculated_opt != null ? realRankedList_pre_calculated_opt : dm.scoreDataset(metric, sort, order, metricParams, lvp, ds, template);
        if (rlReal.getSize() != ds.getNumRow()) {
            throw new MismatchedSizeException();
        }
        GeneSetCohort gcoh = gcohgen.createGeneSetCohort(rlReal, gsets, false, true);
        EnrichmentScore[] realScores = this.core.calculateKSScore(gcoh, true);
        Vector[] rndEss = new Vector[gsets.length];
        for (int g = 0; g < gsets.length; ++g) {
            rndEss[g] = new Vector(rndTemplates.length);
        }
        for (int c = 0; c < rndTemplates.length; ++c) {
            RankedList rndRl = rndRankedLists_pre_calculated_opt != null ? rndRankedLists_pre_calculated_opt[c] : dm.scoreDataset(metric, sort, order, metricParams, lvp, ds, rndTemplates[c]);
            if (store_rnd_ranked_lists_here_opt != null) {
                store_rnd_ranked_lists_here_opt.add(rndRl);
            }
            if (c % 5 == 0) {
                StringBuffer ib = new StringBuffer("Iteration: ").append(c + 1).append('/').append(rndTemplates.length);
                ib.append(" for ").append(dstName);
                System.out.println(ib.toString());
            }
            GeneSetCohort gcohRnd = gcohgen.createGeneSetCohort(rndRl, gsets, false, false);
            EnrichmentScore[] rndScores = this.core.calculateKSScore(gcohRnd, false);
            for (int g = 0; g < gsets.length; ++g) {
                rndEss[g].setElement(c, rndScores[g].getES());
            }
            ptest.addRnd(rndTemplates[c], rndRl);
        }
        EnrichmentResult[] results = new EnrichmentResult[gsets.length];
        for (int g = 0; g < gsets.length; ++g) {
            results[g] = new EnrichmentResultImpl(rlReal, template, gsets[g], chip, realScores[g], rndEss[g]);
        }
        ptest.doCalc();
        return new EnrichmentDbImplWithPermTest(dstName, rlReal, ds, template, results, lvp, metric, metricParams, sort, order, rndTemplates.length, null, ptest);
    }

    private EnrichmentResult[] shuffleGeneSet_precannedRankedList(int nperm, RankedList rlReal, Template t_opt, GeneSet[] gsetsReal, Chip chip_opt, GeneSetCohortGenerator gcohgen, RandomSeedGenerator rst) {
        EnrichmentResult[] results = new EnrichmentResult[gsetsReal.length];
        GeneSetCohort gcohReal = gcohgen.createGeneSetCohort(rlReal, gsetsReal, false, true);
        EnrichmentScore[] real_scores = this.core.calculateKSScore(gcohReal, true);
        for (int g = 0; g < gsetsReal.length; ++g) {
            Vector rndEss;
            if (g % 5 == 0) {
                this.sout.println("shuffleGeneSet for GeneSet " + (g + 1) + "/" + gsetsReal.length + " nperm: " + nperm);
            }
            if (nperm > 0) {
                GeneSet[] rndgsets = GeneSetGenerators.createRandomGeneSetsFixedSize(nperm, rlReal, gsetsReal[g], rst);
                GeneSetCohort gcohRnd = gcohReal.clone(rndgsets, false);
                rndEss = new Vector(rndgsets.length);
                EnrichmentScore[] rnds = this.core.calculateKSScore(gcohRnd, false);
                for (int r = 0; r < rndgsets.length; ++r) {
                    rndEss.setElement(r, rnds[r].getES());
                }
            } else {
                rndEss = new Vector(0);
            }
            results[g] = new EnrichmentResultImpl(rlReal, t_opt, gsetsReal[g], chip_opt, real_scores[g], rndEss);
        }
        return results;
    }

    public EnrichmentDb shuffleGeneSet(int nperm, Metric metric, SortMode sort, Order order, Map metricParams, LabelledVectorProcessor lvp, Dataset ds, Template template, GeneSet[] gsets, GeneSetCohortGenerator gen, RandomSeedGenerator rst) {
        if (ds == null) {
            throw new IllegalArgumentException("Param ds cannot be null");
        }
        DatasetMetrics dm = new DatasetMetrics();
        ScoredDataset rlReal = dm.scoreDataset(metric, sort, order, metricParams, lvp, ds, template);
        Chip chip = ds.getAnnot().getChip();
        EnrichmentResult[] results = this.shuffleGeneSet_precannedRankedList(nperm, rlReal, template, gsets, chip, gen, rst);
        String name = NamingConventions.generateName(ds, template, true);
        return new EnrichmentDbImpl_one_shared_rl(name, rlReal, ds, template, results, lvp, metric, metricParams, sort, order, nperm, null);
    }
}

