/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.alg.DatasetBuilder;
import edu.mit.broad.genome.alg.RankedListGenerators;
import edu.mit.broad.genome.alg.distrib.RangeFactory;
import edu.mit.broad.genome.math.ColorSchemes;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.Range;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.Annot;
import edu.mit.broad.genome.objects.ColorDataset;
import edu.mit.broad.genome.objects.ColorDatasetImpl;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.ScoredDataset;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateFactory;
import edu.mit.broad.genome.objects.strucs.DatasetTemplate;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.chip.NullSymbolMode;
import edu.mit.broad.vdb.chip.NullSymbolModes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import xtools.api.param.BadParamException;

public class DatasetGenerators {
    private final Logger log = Logger.getLogger(DatasetGenerators.class);

    public ColorDataset createColorDataset(int numRanges, RankedList rl, ColorSchemes.ColorScheme cs) {
        Range[] ranges = RangeFactory.createRanges(numRanges, 0.0, rl.getSize());
        Vector v_full = rl.getScoresV(false);
        Matrix m = new Matrix(1, ranges.length);
        for (int c = 0; c < ranges.length; ++c) {
            m.setElement(0, c, (float)v_full.mean((int)ranges[c].getMin(), (int)ranges[c].getMax()));
        }
        return new ColorDatasetImpl(new DefaultDataset("foo", m, null), cs);
    }

    public Dataset collapse(Dataset origDs, Chip chip, boolean includeOnlySymbols, int collapse_gex_mode) {
        return this.collapse_core((Dataset)origDs, (Chip)chip, (boolean)includeOnlySymbols, (int)collapse_gex_mode).symbolized;
    }

    public CollapsedDataset collapse_core(Dataset origDs, Chip chip, boolean includeOnlySymbols, int collapse_gex_mode) {
        if (origDs == null) {
            throw new IllegalArgumentException("Param ds cannot be null");
        }
        if (chip == null) {
            throw new IllegalArgumentException("Param chip cannot be null");
        }
        HashMap symbolStrucMap = new HashMap();
        NullSymbolMode nm = includeOnlySymbols ? NullSymbolModes.OmitNulls : NullSymbolModes.ReplaceWithProbeId;
        for (int r = 0; r < origDs.getNumRow(); ++r) {
            String ps = origDs.getRowName(r);
            String symbol = chip.getSymbol(ps, nm);
            String title = chip.getTitle(ps, nm);
            if (!StringUtils.isNotEmpty((CharSequence)symbol)) continue;
            Object obj = symbolStrucMap.get(symbol);
            if (obj == null) {
                obj = new CollapseStruc(symbol, title);
            }
            ((CollapseStruc)obj).add(ps);
            symbolStrucMap.put(symbol, obj);
        }
        Matrix m = new Matrix(symbolStrucMap.size(), origDs.getNumCol());
        ArrayList<String> rowNames = new ArrayList<String>();
        ArrayList<String> rowDescs = new ArrayList<String>();
        Iterator it = symbolStrucMap.keySet().iterator();
        int row = 0;
        while (it.hasNext()) {
            Object o = it.next();
            CollapseStruc collapseStruc = (CollapseStruc)symbolStrucMap.get(o);
            rowNames.add(collapseStruc.symbol);
            rowDescs.add(collapseStruc.title);
            String[] pss = collapseStruc.getProbes();
            if (pss.length == 1) {
                String ps = pss[0];
                m.setRow(row, origDs.getRow(ps));
            } else {
                Vector[] vss = origDs.getRows(new GeneSet("foo", "foo", pss));
                if (collapse_gex_mode == 0) {
                    m.setRow(row, XMath.maxVector(vss));
                } else if (collapse_gex_mode == 1) {
                    m.setRow(row, XMath.medianVector(vss));
                } else if (collapse_gex_mode == 2) {
                    m.setRow(row, XMath.meanVector(vss));
                } else if (collapse_gex_mode == 3) {
                    m.setRow(row, XMath.sumVector(vss));
                } else {
                    throw new BadParamException("Multiple rows mapped to the symbol ''" + collapseStruc.symbol + "'.  This is not allowed in Remap_only mode.", 1020);
                }
            }
            ++row;
        }
        String extendedName = collapse_gex_mode <= 3 ? "_collapsed_to_symbols" : "_remapped_to_symbols";
        String name = origDs.getName() + extendedName;
        this.log.info((Object)("Creating collapsed dataset " + name + ", chosen mode " + collapse_gex_mode));
        Annot annot = new Annot(new FeatureAnnot(name, rowNames, rowDescs, chip), origDs.getAnnot().getSampleAnnot_global());
        CollapsedDataset cds = new CollapsedDataset();
        cds.orig = origDs;
        cds.symbolized = new DefaultDataset(name, m, rowNames, origDs.getColumnNames(), true, annot);
        cds.symbolCollapseStrucMap = symbolStrucMap;
        return cds;
    }

    public RankedList collapse(RankedList origRL, Chip chip, boolean includeOnlySymbols, int collapse_gex_mode) {
        if (origRL == null) {
            throw new IllegalArgumentException("Param origRL cannot be null");
        }
        if (chip == null) {
            throw new IllegalArgumentException("Param chip cannot be null");
        }
        HashMap symbolStrucMap = new HashMap();
        NullSymbolMode nm = includeOnlySymbols ? NullSymbolModes.OmitNulls : NullSymbolModes.ReplaceWithProbeId;
        for (int r = 0; r < origRL.getSize(); ++r) {
            String ps = origRL.getRankName(r);
            String symbol = chip.getSymbol(ps, nm);
            String title = chip.getTitle(ps, nm);
            if (!StringUtils.isNotEmpty((CharSequence)symbol)) continue;
            Object obj = symbolStrucMap.get(symbol);
            if (obj == null) {
                obj = new CollapseStruc(symbol, title);
            }
            ((CollapseStruc)obj).add(ps);
            symbolStrucMap.put(symbol, obj);
        }
        Vector cl_scores = new Vector(symbolStrucMap.size());
        ArrayList<String> cl_rowNames = new ArrayList<String>();
        Iterator it = symbolStrucMap.keySet().iterator();
        int row = 0;
        while (it.hasNext()) {
            Object o = it.next();
            CollapseStruc collapseStruc = (CollapseStruc)symbolStrucMap.get(o);
            cl_rowNames.add(collapseStruc.symbol);
            String[] pss = collapseStruc.getProbes();
            if (pss.length == 1) {
                String ps = pss[0];
                cl_scores.setElement(row, origRL.getScore(ps));
            } else {
                float[] fss = origRL.getScores(new GeneSet("foo", "foo", pss));
                if (collapse_gex_mode == 0) {
                    cl_scores.setElement(row, XMath.max(fss));
                } else if (collapse_gex_mode == 1) {
                    cl_scores.setElement(row, XMath.median(fss));
                } else if (collapse_gex_mode == 2) {
                    cl_scores.setElement(row, XMath.mean(fss));
                } else if (collapse_gex_mode == 3) {
                    cl_scores.setElement(row, XMath.sum(fss));
                } else {
                    throw new BadParamException("Multiple rows mapped to the symbol ''" + collapseStruc.symbol + "'.  This is not allowed in Remap_only mode.", 1020);
                }
            }
            ++row;
        }
        String extendedName = collapse_gex_mode <= 3 ? "_collapsed" : "_remapped";
        String newName = origRL.getName() + extendedName;
        if (cl_scores.getSize() == 0) {
            throw new BadParamException("The collapsed dataset was empty when used with chip:" + chip.getName(), 1005);
        }
        return RankedListGenerators.sortByVectorAndGetRankedList(cl_scores, SortMode.REAL, Order.DESCENDING, cl_rowNames).cloneShallowRL(newName);
    }

    public DatasetTemplate extract(Dataset fullDs, Template template) {
        return DatasetGenerators.extract(fullDs, template, true);
    }

    public static synchronized DatasetTemplate extract(Dataset fullDs, Template origT, boolean verbose) {
        return TemplateFactory.extract(fullDs, origT, verbose);
    }

    public Dataset extractRows(String newName, Dataset ds, List rowNames) {
        if (newName == null) {
            throw new IllegalArgumentException("Parameter newName cannot be null");
        }
        if (rowNames == null) {
            throw new IllegalArgumentException("Parameter probenames cannot be null");
        }
        if (ds == null) {
            throw new IllegalArgumentException("Parameter fullDs cannot be null");
        }
        DatasetBuilder builder = new DatasetBuilder(newName, ds.getColumnNames());
        int misscnt = 0;
        ArrayList<String> hitNames = new ArrayList<String>();
        for (int i = 0; i < rowNames.size(); ++i) {
            String probeName = (String)rowNames.get(i);
            int index = ds.getRowIndex(probeName);
            if (index == -1) {
                ++misscnt;
                continue;
            }
            hitNames.add(probeName);
            builder.addRow(index, ds);
        }
        if (misscnt != 0) {
            this.log.warn((Object)("Not all probes had matches. Total probes:" + rowNames.size() + " missing number:" + misscnt + " hits:" + hitNames.size()));
        }
        return builder.generate(ds.getAnnot());
    }

    public Dataset extractRows(Dataset fullDs, GeneSet gset) {
        if (gset == null) {
            throw new IllegalArgumentException("Parameter gset cannot be null");
        }
        if (fullDs == null) {
            throw new IllegalArgumentException("Parameter fullDs cannot be null");
        }
        String name = NamingConventions.generateName(fullDs, gset, true);
        return this.extractRows(name, fullDs, gset.getMembers());
    }

    public Dataset extractRows(Dataset ds, List rowNames) {
        if (rowNames == null) {
            throw new IllegalArgumentException("Parameter names cannot be null");
        }
        if (ds == null) {
            throw new IllegalArgumentException("Parameter fullDs cannot be null");
        }
        String name = ds.getName() + "_nrows" + rowNames.size();
        return this.extractRows(name, ds, rowNames);
    }

    public Dataset extractRowsSorted(ScoredDataset fullSds, GeneSet gset) {
        if (gset == null) {
            throw new IllegalArgumentException("Parameter fset cannot be null");
        }
        if (fullSds == null) {
            throw new IllegalArgumentException("Parameter fullSds cannot be null");
        }
        GeneSet ofset = new GeneSet(gset, fullSds);
        String name = NamingConventions.generateName((Dataset)fullSds, gset, true);
        return this.extractRows(name, fullSds, ofset.getMembers());
    }

    public static class CollapseStruc {
        String symbol;
        String title;
        Set probes;

        CollapseStruc(String symbol, String title) {
            this.symbol = symbol;
            this.title = title;
            this.probes = new HashSet();
        }

        private void add(String ps) {
            this.probes.add(ps);
        }

        public String[] getProbes() {
            return this.probes.toArray(new String[this.probes.size()]);
        }

        public String toString() {
            return this.symbol;
        }

        public int hashCode() {
            return this.symbol.hashCode();
        }

        public boolean equals(Object obj) {
            return this.symbol.equals(obj);
        }
    }

    public static class CollapsedDataset {
        public Dataset symbolized;
        public Dataset orig;
        public Map symbolCollapseStrucMap;
    }
}

