/*
 * Decompiled with CFR 0.152.
 */
package xapps.api.frameworks;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.actions.ExtAction;
import edu.mit.broad.xbench.actions.FileAction;
import edu.mit.broad.xbench.actions.FileObjectAction;
import edu.mit.broad.xbench.actions.FilesAction;
import edu.mit.broad.xbench.actions.ObjectAction;
import edu.mit.broad.xbench.actions.PobActions;
import edu.mit.broad.xbench.actions.ProxyFileAction;
import edu.mit.broad.xbench.actions.ProxyFileObjectAction;
import edu.mit.broad.xbench.actions.ProxyObjectAction;
import edu.mit.broad.xbench.actions.XAction;
import edu.mit.broad.xbench.actions.ext.FileBrowserAction;
import edu.mit.broad.xbench.actions.ext.OsExplorerAction;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;

public abstract class AbstractActionLookup {
    private static final Logger klog = Logger.getLogger(AbstractActionLookup.class);
    protected final Map fExtActionsMap = new HashMap();

    protected AbstractActionLookup() {
    }

    protected abstract PobActions lookupActions(Object var1);

    public JPopupMenu createPopup(File file) {
        String ext = NamingConventions.getExtension(file);
        Object obj = this.fExtActionsMap.get(ext);
        if (obj == null) {
            JPopupMenu p = new JPopupMenu();
            if (!file.isDirectory()) {
                p.add(new FileBrowserAction(file));
            }
            p.add(new OsExplorerAction(file));
            return p;
        }
        PobActions da = (PobActions)obj;
        return this._createPopup(da.allActions, file);
    }

    public JPopupMenu createPopup(Object obj) {
        if (obj instanceof File) {
            return this.createPopup((File)obj);
        }
        PobActions pa = this.lookupActions(obj);
        XAction[] actions = pa.allActions;
        if (actions != null && actions.length > 0) {
            return this.createPopupForObject(actions, obj);
        }
        return new JPopupMenu();
    }

    public JPopupMenu createPopupForObject(XAction[] actions, Object obj) {
        int i;
        JPopupMenu menu = new JPopupMenu();
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        for (i = 0; i < actions.length; ++i) {
            if (actions[i] == null) {
                list.add(new JSeparator());
                continue;
            }
            try {
                list.add(new JMenuItem(this.createAction(actions[i], obj)));
                continue;
            }
            catch (Throwable e) {
                klog.error((Object)"Error making popup", e);
                list.add(new JMenuItem("Error making popup: " + e));
            }
        }
        for (i = 0; i < list.size(); ++i) {
            menu.add((JComponent)list.get(i));
        }
        return menu;
    }

    private JPopupMenu _createPopup(XAction[] actions, File file) {
        int i;
        JPopupMenu menu = new JPopupMenu();
        if (actions == null) {
            return menu;
        }
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        for (i = 0; i < actions.length; ++i) {
            if (actions[i] == null) {
                list.add(new JSeparator());
                continue;
            }
            try {
                JMenuItem item = new JMenuItem(this.createAction(actions[i], file));
                list.add(item);
                continue;
            }
            catch (Throwable e) {
                klog.error((Object)e);
                list.add(new JMenuItem("Error making popup: " + e));
            }
        }
        for (i = 0; i < list.size(); ++i) {
            menu.add((JComponent)list.get(i));
        }
        return menu;
    }

    public XAction createAction(XAction action, Object data) throws Exception {
        if (action instanceof FileObjectAction) {
            return new ProxyFileObjectAction((FileObjectAction)action, data);
        }
        if (action instanceof ObjectAction) {
            return new ProxyObjectAction((ObjectAction)action, data);
        }
        if (action instanceof FileAction && data instanceof File) {
            return new ProxyFileAction((FileAction)action, (File)data);
        }
        if (action instanceof FileAction && data instanceof PersistentObject && ParserFactory.getCache().isCached((PersistentObject)data)) {
            return new ProxyFileAction((FileAction)action, ParserFactory.getCache().getSourceFile(data));
        }
        if (action instanceof FilesAction && data instanceof File[]) {
            return new ProxyFileAction((FileAction)((FilesAction)action), (File[])data);
        }
        if (action instanceof ExtAction && data instanceof File) {
            Class<?> cl = action.getClass();
            ExtAction real = (ExtAction)cl.newInstance();
            real.setPath((File)data);
            return real;
        }
        if (action instanceof ExtAction && data instanceof PersistentObject) {
            Class<?> cl = action.getClass();
            ExtAction real = (ExtAction)cl.newInstance();
            real.setPath(ParserFactory.getCache().getSourceFile(data));
            return real;
        }
        if (action instanceof XAction) {
            Class<?> cl = action.getClass();
            return (XAction)cl.newInstance();
        }
        throw new Exception("Unknown action type: " + action + " and object combo: " + data);
    }
}

