/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.icons.JideIconsFactory;
import edu.mit.broad.genome.alg.ComparatorFactory;
import edu.mit.broad.genome.alg.GeneSetStats;
import edu.mit.broad.genome.alg.gsea.PValueCalculatorImpls;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.objects.BitSetDataset;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GPWrappers;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import gnu.trove.TFloatIntHashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.gsea.GeneHistogram;
import org.genepattern.gsea.GeneSetSimilarityPanel;
import org.genepattern.gsea.HCLAlgorithm;
import org.genepattern.gsea.JaccardHistogram;
import org.genepattern.gsea.LeadingEdgePanel;
import org.genepattern.heatmap.ColorScheme;
import org.genepattern.heatmap.HeatMapComponent;
import org.genepattern.menu.jfree.JFreeMenuBar;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;

public class LeadingEdgeAnalysis {
    private JPanel mainComponent;
    private JaccardHistogram jaccardHistogram = new JaccardHistogram();
    private final GeneHistogram geneHistogram = new GeneHistogram();
    private HeatMapComponent geneSetSimilarityHeatmap;
    private LeadingEdgePanel leadingEdgePanel;
    private Dataset clusteredDataset = null;
    private static final String LEADING_EDGE_MATRIX_KEY = "Leading Edge Matrix";
    private static final String GENE_SET_SIMILARITY_MATRIX_KEY = "Gene Set Similarity Matrix";
    private static final String GENE_HISTOGRAM_KEY = "Gene Histogram";
    private static final String JACCARD_HISTOGRAM_KEY = "Jaccard Histogram of Gene Sets";

    public static final LeadingEdgeAnalysis runAnalysis(EnrichmentDb edb, String[] gsetNames, Frame parentFrame) {
        GeneSet[] gsets = new GeneSet[gsetNames.length];
        for (int r = 0; r < gsetNames.length; ++r) {
            EnrichmentResult result = edb.getResultForGeneSet(gsetNames[r]);
            gsets[r] = result.getSignal().getAsGeneSet();
        }
        DefaultGeneSetMatrix lev_gmx = new DefaultGeneSetMatrix("leading_edge_matrix_for_" + edb.getName(), gsets);
        LeadingEdgeAnalysis analysis = new LeadingEdgeAnalysis(lev_gmx, edb.getRankedList(), parentFrame);
        analysis.setResultDirectory(edb.getEdbDir());
        return analysis;
    }

    public static EnrichmentResult[] getAllResultsFromEdb(EnrichmentDb edb_original) {
        String normModeName = "meandiv";
        PValueCalculatorImpls.GseaImpl pvc = new PValueCalculatorImpls.GseaImpl(normModeName);
        EnrichmentResult[] results = pvc.calcNPValuesAndFDR(edb_original.getResults());
        EnrichmentDb edb = edb_original.cloneDeep(results);
        EnrichmentResult[] enrichmentResults = edb.getResults(new ComparatorFactory.EnrichmentResultByNESComparator(Order.DESCENDING));
        return enrichmentResults;
    }

    private Dataset _morph(Dataset ds, RankedList rl) {
        Matrix m = new Matrix(ds.getNumRow(), ds.getNumCol());
        for (int r = 0; r < ds.getNumRow(); ++r) {
            for (int c = 0; c < ds.getNumCol(); ++c) {
                float score = rl.getScore(ds.getColumnName(c));
                float value = ds.getElement(r, c);
                if (value == 1.0f) {
                    m.setElement(r, c, score);
                    continue;
                }
                m.setElement(r, c, value);
            }
        }
        return new DefaultDataset(ds.getName(), m, ds.getRowNames(), ds.getColumnNames(), true, ds.getAnnot());
    }

    public void setResultDirectory(File file) {
        this.leadingEdgePanel.setResultDirectory(file);
    }

    public LeadingEdgeAnalysis(GeneSetMatrix lev_gmx, RankedList rankedList, Frame parent) {
        int i;
        GeneSet[] gsets = lev_gmx.getGeneSets();
        Dataset lev_ds = new BitSetDataset(lev_gmx).toDataset();
        try {
            this.clusteredDataset = HCLAlgorithm.cluster(lev_ds);
        }
        catch (Throwable t) {
            this.clusteredDataset = lev_ds;
            t.printStackTrace();
        }
        final Dataset lev_ds_clustered_m = rankedList != null ? this._morph(this.clusteredDataset, rankedList) : this.clusteredDataset;
        this.leadingEdgePanel = new LeadingEdgePanel(parent);
        ColorScheme cs = rankedList != null ? GPWrappers.createColorScheme_for_lev_with_score(lev_ds_clustered_m) : new ColorScheme(){

            @Override
            public Color getColor(int row, int column) {
                return lev_ds_clustered_m.getElement(row, column) == 0.0f ? Color.white : Color.yellow;
            }

            @Override
            public void setDataset(IExpressionData d) {
            }

            @Override
            public Component getLegend() {
                return null;
            }
        };
        this.leadingEdgePanel.setData(GPWrappers.createIExpressionData(lev_ds_clustered_m), cs);
        GeneSetStats stats = new GeneSetStats();
        GeneSetStats.RedStruc rs = stats.calcRedundancy(gsets, false);
        GeneSetSimilarityPanel geneSetSimilarityPanel = new GeneSetSimilarityPanel(parent);
        GeneSet[] reorderedGeneSets = new GeneSet[gsets.length];
        HashMap<String, Integer> geneSetName2Index = new HashMap<String, Integer>();
        for (i = 0; i < gsets.length; ++i) {
            geneSetName2Index.put(gsets[i].getName(true), new Integer(i));
        }
        for (i = 0; i < gsets.length; ++i) {
            String geneSetName = lev_ds_clustered_m.getRowName(i);
            reorderedGeneSets[i] = gsets[(Integer)geneSetName2Index.get(geneSetName)];
        }
        geneSetSimilarityPanel.setGeneSets(reorderedGeneSets);
        TFloatIntHashMap jaccardToOccurrencesMap = rs.jaccardDistrib;
        this.jaccardHistogram.setJaccardToOccurrencesMap(jaccardToOccurrencesMap);
        this.jaccardHistogram.setPreferredSize(new Dimension(100, 100));
        RankedList featureFrequency = rs.featureFreq;
        this.geneHistogram.setFeatureFrequency(featureFrequency, rankedList != null ? rankedList : null);
        ChartMouseListener listener = new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent event) {
                int mouseX = event.getTrigger().getX();
                int mouseY = event.getTrigger().getY();
                int index = LeadingEdgeAnalysis.this.geneHistogram.getXIndex(mouseX, mouseY);
                if (index != -1) {
                    String geneName = LeadingEdgeAnalysis.this.geneHistogram.getGeneName(index);
                    int columnIndex = lev_ds_clustered_m.getColumnIndex(geneName);
                    LeadingEdgeAnalysis.this.leadingEdgePanel.getHeatMapComponent().getSampleTable().setColumnSelectionInterval(columnIndex, columnIndex);
                }
            }

            public void chartMouseMoved(ChartMouseEvent event) {
            }
        };
        this.geneHistogram.getChartPanel().addChartMouseListener(listener);
        this.geneHistogram.setPreferredSize(new Dimension(100, 100));
        JScrollPane leadingEdgeSP = new JScrollPane(this.leadingEdgePanel.getHeatMapComponent());
        leadingEdgeSP.setBorder(null);
        this.geneSetSimilarityHeatmap = geneSetSimilarityPanel.getHeatMapComponent();
        JScrollPane geneSetSP = new JScrollPane(this.geneSetSimilarityHeatmap);
        geneSetSP.setBorder(null);
        if (parent == null) {
            return;
        }
        this.mainComponent = new JPanel();
        UIManager.getDefaults().put("JideSplitPane.dividerSize", new Integer(9));
        DefaultDockingManager manager = new DefaultDockingManager(null, this.mainComponent){

            public void activateFrame(String key) {
                super.activateFrame(key);
            }
        };
        manager.setInitSplitPriority(0);
        manager.setShowWorkspace(false);
        manager.setRearrangable(false);
        manager.setAutohidable(false);
        manager.setFloatable(false);
        manager.setShowTitleBar(false);
        manager.getWorkspace().setAcceptDockableFrame(false);
        manager.setProportionalSplits(true);
        manager.beginLoadLayoutData();
        int width = parent.getWidth();
        int height = parent.getHeight();
        DockableFrame f = new DockableFrame(LEADING_EDGE_MATRIX_KEY, (Icon)JideIconsFactory.getImageIcon((String)"jide/dockableframe_1.gif"));
        f.getContentPane().add(leadingEdgeSP);
        f.setInitIndex(0);
        f.setInitSide(1);
        f.setPreferredSize(new Dimension(width / 2, height / 2));
        f.setJMenuBar(this.leadingEdgePanel.getMenuBar());
        manager.addFrame(f);
        f = new DockableFrame(GENE_SET_SIMILARITY_MATRIX_KEY, (Icon)JideIconsFactory.getImageIcon((String)"jide/dockableframe_1.gif"));
        f.getContentPane().add(geneSetSP);
        f.setInitIndex(1);
        f.setInitSide(1);
        f.setPreferredSize(new Dimension(width / 2, height / 2));
        f.setJMenuBar(geneSetSimilarityPanel.getMenuBar());
        manager.addFrame(f);
        f = new DockableFrame(GENE_HISTOGRAM_KEY, (Icon)JideIconsFactory.getImageIcon((String)"jide/dockableframe_1.gif"));
        f.getContentPane().add(new JScrollPane(this.geneHistogram));
        f.setInitIndex(0);
        f.setInitSide(2);
        f.setPreferredSize(new Dimension(width / 2, height / 2));
        JFreeMenuBar menuBar = new JFreeMenuBar((JComponent)this.geneHistogram.getChartPanel(), parent);
        f.setJMenuBar((JMenuBar)menuBar);
        manager.addFrame(f);
        f = new DockableFrame(JACCARD_HISTOGRAM_KEY, (Icon)JideIconsFactory.getImageIcon((String)"jide/dockableframe_1.gif"));
        f.getContentPane().add(new JScrollPane(this.jaccardHistogram));
        f.setInitIndex(1);
        f.setInitSide(2);
        f.setPreferredSize(new Dimension(width / 2, height / 2));
        menuBar = new JFreeMenuBar((JComponent)this.jaccardHistogram.getChartPanel(), parent);
        f.setJMenuBar((JMenuBar)menuBar);
        manager.addFrame(f);
        manager.loadLayoutData();
    }

    public Component getComponent() {
        return this.mainComponent;
    }

    public JaccardHistogram getJaccardHistogram() {
        return this.jaccardHistogram;
    }

    public GeneHistogram getGeneHistogram() {
        return this.geneHistogram;
    }

    public HeatMapComponent getGeneSetSimilarityHeatmap() {
        return this.geneSetSimilarityHeatmap;
    }

    public LeadingEdgePanel getLeadingEdgePanel() {
        return this.leadingEdgePanel;
    }

    public Dataset getClusteredDataset() {
        return this.clusteredDataset;
    }
}

