/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.reports.api;

import edu.mit.broad.genome.charts.XChart;
import edu.mit.broad.genome.reports.pages.HtmlFormat;
import java.io.File;
import java.io.IOException;
import org.apache.ecs.Element;
import org.apache.ecs.StringElement;
import org.apache.ecs.html.BR;
import org.apache.ecs.html.Div;
import org.apache.ecs.html.IMG;
import org.genepattern.heatmap.image.HeatMap;
import org.genepattern.io.ImageUtil;

public class PicFile {
    private String srcName;
    private String name;
    private XChart xChart;
    private HeatMap heatMap;
    private String title;
    private String caption;
    private int width;
    private int height;
    private int currPicCnt;
    private boolean createSvgs;
    private File fSavedFile;
    private File fSavedFileSvg;
    private boolean isSaved = false;
    private static int kImageCounter = 1;

    public PicFile(XChart xChart, int width, int height, int currPicCnt, File saveInDir, boolean createSvgs) {
        if (xChart == null) {
            throw new IllegalArgumentException("Parameter xChart cannot be null");
        }
        String srcName = PicFile.generateName(xChart) + ".png";
        this.xChart = xChart;
        this.heatMap = null;
        this.init(saveInDir, srcName, xChart.getName(), xChart.getTitle(), xChart.getCaption(), width, height, currPicCnt, createSvgs);
    }

    public PicFile(String name, String title, String caption, HeatMap heatMap, int currPicCnt, File saveInDir, boolean createSvgs) {
        if (heatMap == null) {
            throw new IllegalArgumentException("Parameter heatMap cannot be null");
        }
        String srcName = PicFile.generateNameForImage(name) + ".png";
        this.xChart = null;
        this.heatMap = heatMap;
        this.init(saveInDir, srcName, name, title, caption, 0, 0, currPicCnt, createSvgs);
    }

    public static String generateName(XChart xchart) {
        return PicFile.createSafeFileName(xchart.getName()) + "_" + kImageCounter++;
    }

    public static String generateNameForImage(String title) {
        return PicFile.createSafeFileName(title) + "_" + kImageCounter++;
    }

    public static String createSafeFileName(String name) {
        name = name.trim();
        Object safename = name.replace('@', '_');
        safename = ((String)safename).replace('#', '_');
        safename = ((String)safename).replace(' ', '_');
        safename = ((String)safename).replace('%', '_');
        safename = ((String)safename).replace('$', '_');
        safename = ((String)safename).replace(':', '_');
        safename = ((String)safename).replace('*', '_');
        safename = ((String)safename).replace('\\', '_');
        safename = ((String)safename).replace('/', '_');
        if (((String)(safename = ((String)safename).replace('\u001c', '_'))).length() >= 125) {
            String ext = PicFile.getExtension((String)safename);
            safename = ((String)safename).substring(0, 125) + "." + ext;
        }
        return safename;
    }

    public static String getExtension(String f) {
        int pos = f.lastIndexOf(".");
        String ext = pos == -1 ? "" : f.substring(pos + 1);
        if (f.indexOf(".meta.") != -1) {
            return "meta." + ext;
        }
        return ext;
    }

    private void init(File saveInDir, String srcName, String name, String title, String caption, int width, int height, int currPicCnt, boolean createSvgs) {
        if (saveInDir == null) {
            throw new IllegalArgumentException("Parameter saveInDir cannot be null");
        }
        if (srcName == null) {
            throw new IllegalArgumentException("Parameter srcName cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name cannot be null");
        }
        if (title == null) {
            throw new IllegalArgumentException("Parameter title cannot be null");
        }
        this.fSavedFile = new File(saveInDir, srcName);
        if (createSvgs) {
            this.fSavedFileSvg = ImageUtil.getSvgFileFromImgFile(this.fSavedFile, true);
        }
        this.srcName = srcName;
        this.name = name;
        this.title = title;
        this.caption = caption;
        this.width = width;
        this.height = height;
        this.currPicCnt = currPicCnt;
        this.createSvgs = createSvgs;
    }

    public Div createIMG() throws IOException {
        this.save();
        Div image = HtmlFormat.Divs.image();
        IMG img = new IMG(this.srcName, this.name);
        img.addElement((Element)new BR());
        img.addElement((Element)new BR());
        String desc = "Fig " + this.currPicCnt + ": " + this.title;
        if (this.caption != null) {
            desc = desc + " &nbsp&nbsp <br> " + this.caption;
        }
        img.addElement((Element)HtmlFormat.caption(desc));
        image.addElement((Element)img);
        if (this.createSvgs) {
            StringElement line = HtmlFormat.Links.hyper("The same image", this.fSavedFileSvg, "in compressed SVG format", this.fSavedFileSvg.getParentFile());
            image.addElement((Element)new BR());
            image.addElement((Element)new BR());
            image.addElement((Element)line);
        }
        return image;
    }

    private void save() throws IOException {
        if (this.isSaved) {
            return;
        }
        if (this.xChart != null) {
            this.xChart.saveAsPNG(this.fSavedFile, this.width, this.height);
            if (this.createSvgs) {
                ImageUtil.saveAsSVG(this.xChart.getFreeChart(), this.fSavedFileSvg, this.width, this.height, true);
            }
            this.xChart = null;
        } else if (this.heatMap != null) {
            ImageUtil.saveReportPlotImage(this.heatMap, this.fSavedFile, "png");
            if (this.createSvgs) {
                ImageUtil.saveReportPlotImage(this.heatMap, this.fSavedFileSvg, "svg");
            }
            this.heatMap = null;
        }
        this.isSaved = true;
    }

    public File getFile() {
        if (!this.isSaved) {
            throw new IllegalStateException("Not yet saved");
        }
        return this.fSavedFile;
    }

    public File getSvgFile() {
        if (!this.isSaved) {
            throw new IllegalStateException("Not yet saved");
        }
        return this.fSavedFileSvg;
    }
}

