/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.math.RandomSeedGenerator;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateFactory;
import edu.mit.broad.genome.objects.TemplateImpl;
import edu.mit.broad.genome.objects.strucs.TemplateRandomizerType;
import org.apache.log4j.Logger;

public class TemplateFactoryRandomizer {
    private static final Logger klog = Logger.getLogger(TemplateFactoryRandomizer.class);

    public static Template[] createRandomTemplates(int num, Template origTemplate, TemplateRandomizerType rt, RandomSeedGenerator rst) {
        return TemplateFactoryRandomizer.createRandomTemplates(num, origTemplate, rt, rst, false);
    }

    public static Template[] createRandomTemplates(int num, Template origTemplate, TemplateRandomizerType rt, RandomSeedGenerator rst, boolean silent) {
        Template[] tss;
        if (!silent) {
            klog.debug((Object)("TemplateRandomizerType: " + rt.toString()));
        }
        if (rt == TemplateRandomizerType.NO_BALANCE) {
            tss = TemplateFactoryRandomizer.createRandomTemplates(num, origTemplate, rst);
        } else if (rt == TemplateRandomizerType.BALANCED_CLASS0) {
            tss = TemplateFactoryRandomizer.createRandomAuxBalancedTemplates(num, origTemplate, true, rst);
        } else if (rt == TemplateRandomizerType.BALANCED_CLASS1) {
            tss = TemplateFactoryRandomizer.createRandomAuxBalancedTemplates(num, origTemplate, false, rst);
        } else if (rt == TemplateRandomizerType.EQUALIZE_AND_BALANCE) {
            tss = TemplateFactoryRandomizer.createRandomAuxEqualizedAndBalancedTemplates(num, origTemplate, rst);
        } else {
            throw new IllegalArgumentException("Unknown RandomizerType: " + rt);
        }
        return tss;
    }

    public static Template[] createRandomTemplates(int num, Template origTemplate, RandomSeedGenerator rsgen) {
        Template[] templates = new Template[num];
        for (int i = 0; i < num; ++i) {
            templates[i] = TemplateFactoryRandomizer.createRandomTemplate(origTemplate, rsgen);
        }
        return templates;
    }

    public static Template createRandomTemplate(Template origTemplate, RandomSeedGenerator rsgen) {
        if (origTemplate.isContinuous()) {
            Vector rnd = TemplateFactoryRandomizer.createRandomTemplateContinuousV(origTemplate, rsgen);
            return TemplateFactory.createContinuousTemplate(origTemplate.getName(), rnd);
        }
        if (origTemplate.getNumClasses() != 2) {
            throw new IllegalArgumentException("Only 2 class templates rnd allowed: " + origTemplate.getNumClasses());
        }
        int[] inds = XMath.randomizeWithoutReplacement(origTemplate.getNumItems(), rsgen);
        Template.Item[] items = origTemplate.getItemsOrderedByProfilePos();
        Template.Item[] newItems = new Template.Item[items.length];
        TemplateImpl newT = new TemplateImpl(origTemplate.getName());
        for (int i = 0; i < items.length; ++i) {
            Template.Item real_item = items[i];
            Template.Item real_rnd_item = items[inds[i]];
            Template.Class cl = origTemplate.getClass(real_rnd_item);
            newItems[i] = TemplateImpl.ItemImpl.createItem(cl.getName(), real_item.getProfilePosition());
            newT.add(newItems[i]);
        }
        TemplateImpl.ClassImpl newClassA = new TemplateImpl.ClassImpl(origTemplate.getClass(0).getName());
        TemplateImpl.ClassImpl newClassB = new TemplateImpl.ClassImpl(origTemplate.getClass(1).getName());
        for (int i = 0; i < newItems.length; ++i) {
            if (newItems[i].getId().equals(newClassA.getName())) {
                newClassA.add(newItems[i]);
                continue;
            }
            if (newItems[i].getId().equals(newClassB.getName())) {
                newClassB.add(newItems[i]);
                continue;
            }
            throw new IllegalStateException("Unknown item class: " + newItems[i].getId());
        }
        newT.add(newClassA);
        newT.add(newClassB);
        newT.setClassOfInterestIndex(origTemplate.getClassOfInterestIndex());
        newT.setAux(origTemplate.isAux());
        newT.setContinuous(false);
        newT.makeImmutable();
        return newT;
    }

    public static Vector createRandomTemplateContinuousV(Template origContinuousTemplate, RandomSeedGenerator rsgen) {
        if (!origContinuousTemplate.isContinuous()) {
            throw new IllegalArgumentException("Only valid to call for continuous templates");
        }
        Vector shufv = new Vector(origContinuousTemplate.getNumItems());
        int[] inds = XMath.randomizeWithoutReplacement(origContinuousTemplate.getNumItems(), rsgen);
        int[] profilePos = origContinuousTemplate.getProfilePositionsOrdered();
        for (int i = 0; i < profilePos.length; ++i) {
            int rndProfilePos = profilePos[inds[i]];
            Template.Item item = origContinuousTemplate.getItemByProfilePos(rndProfilePos);
            shufv.setElement(i, Float.parseFloat(item.getId()));
        }
        return shufv;
    }

    public static Template createRandomAuxBalancedTemplate(Template orig, boolean balanceFirstClass, RandomSeedGenerator rsgen) {
        if (orig.getNumClasses() != 2) {
            throw new IllegalArgumentException("Balanced rnd only possible for 2 class templates");
        }
        if (balanceFirstClass) {
            Template.Class one = orig.getClass(0);
            int oneNum = one.getSize() / 2;
            int twoNum = one.getSize() - oneNum;
            Template.Class two = orig.getClass(1);
            return TemplateFactoryRandomizer.createRandomConstrainedTemplate(orig, one, oneNum, two, twoNum, rsgen);
        }
        Template.Class one = orig.getClass(0);
        Template.Class two = orig.getClass(1);
        int twoNum = two.getSize() / 2;
        int oneNum = one.getSize() - twoNum;
        return TemplateFactoryRandomizer.createRandomConstrainedTemplate(orig, one, oneNum, two, twoNum, rsgen);
    }

    public static Template[] createRandomAuxBalancedTemplates(int numrnd, Template orig, boolean balanceFirstClass, RandomSeedGenerator rsgen) {
        if (orig.getNumClasses() != 2) {
            throw new IllegalArgumentException("Only 2 class templates possible");
        }
        Template[] rndtss = new Template[numrnd];
        for (int i = 0; i < numrnd; ++i) {
            rndtss[i] = TemplateFactoryRandomizer.createRandomAuxBalancedTemplate(orig, balanceFirstClass, rsgen);
        }
        return rndtss;
    }

    public static Template[] createRandomAuxEqualizedAndBalancedTemplates(int numrnd, Template orig, RandomSeedGenerator rsgen) {
        if (orig.getNumClasses() != 2) {
            throw new IllegalArgumentException("Only 2 class templates possible");
        }
        Template[] rndtss = new Template[numrnd];
        for (int i = 0; i < numrnd; ++i) {
            Template.Class one = orig.getClass(0);
            int twoNum = one.getSize() / 2;
            int oneNum = one.getSize() - twoNum;
            Template.Class two = orig.getClass(1);
            rndtss[i] = TemplateFactoryRandomizer.createRandomConstrainedTemplate(orig, one, oneNum, two, twoNum, rsgen);
        }
        return rndtss;
    }

    public static Template createRandomConstrainedTemplate(Template orig, Template.Class c0, int numFromC0inC0, Template.Class c1, int numFromC1inC0, RandomSeedGenerator rsgen) {
        TemplateImpl.ItemImpl newitem;
        Template.Item item;
        int x1;
        TemplateImpl.ItemImpl newitem2;
        Template.Item item2;
        int x0;
        if (numFromC0inC0 > c0.getSize()) {
            throw new IllegalArgumentException("numFromC0inC0:   cannot be larger than size of templateclass 0: " + c0.getSize());
        }
        if (numFromC1inC0 > c1.getSize()) {
            throw new IllegalArgumentException("numFromC1inC0: " + numFromC1inC0 + " cannot be larger than size of templateclass 1: " + c1.getSize());
        }
        if (numFromC0inC0 + numFromC1inC0 != c0.getSize()) {
            throw new IllegalArgumentException("numFromC0inC0 + numFromC1inC0: " + (numFromC0inC0 + numFromC1inC0) + " not equal to size of class0: " + c0.getSize());
        }
        int[] inds0 = XMath.randomizeWithoutReplacement(c0.getSize(), rsgen);
        TemplateImpl newt = new TemplateImpl(orig.getName());
        TemplateImpl.ClassImpl newc0 = new TemplateImpl.ClassImpl(c0.getName());
        TemplateImpl.ClassImpl newc1 = new TemplateImpl.ClassImpl(c1.getName());
        String id0 = c0.getItem(0).getId();
        String id1 = c1.getItem(0).getId();
        for (x0 = 0; x0 < numFromC0inC0; ++x0) {
            item2 = c0.getItem(inds0[x0]);
            newitem2 = TemplateImpl.ItemImpl.createItem(id0, item2.getProfilePosition());
            newc0.add(newitem2);
            newt.add(newitem2);
        }
        while (x0 < inds0.length) {
            item2 = c0.getItem(inds0[x0]);
            newitem2 = TemplateImpl.ItemImpl.createItem(id1, item2.getProfilePosition());
            newc1.add(newitem2);
            newt.add(newitem2);
            ++x0;
        }
        int[] inds1 = XMath.randomizeWithoutReplacement(c1.getSize(), rsgen);
        for (x1 = 0; x1 < numFromC1inC0; ++x1) {
            item = c1.getItem(inds1[x1]);
            newitem = TemplateImpl.ItemImpl.createItem(id0, item.getProfilePosition());
            newc0.add(newitem);
            newt.add(newitem);
        }
        while (x1 < inds1.length) {
            item = c1.getItem(inds1[x1]);
            newitem = TemplateImpl.ItemImpl.createItem(id1, item.getProfilePosition());
            newc1.add(newitem);
            newt.add(newitem);
            ++x1;
        }
        newt.add(newc0);
        newt.add(newc1);
        newt.setClassOfInterestIndex(orig.getClassOfInterestIndex());
        if (orig.isAux()) {
            newt.setAux(true);
        }
        if (orig.isContinuous()) {
            newt.setContinuous(true);
        }
        newt.makeImmutable();
        return newt;
    }
}

