/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.models;

import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class NumberedProxyModel
extends AbstractTableModel {
    private final Logger log = Logger.getLogger(NumberedProxyModel.class);
    private TableModel fRealModel;
    private int fStartNumberingFromRowIndex;

    public NumberedProxyModel(TableModel model) {
        this(model, 0);
    }

    public NumberedProxyModel(TableModel model, int startNumberingFromRowIndex) {
        if (model == null) {
            throw new IllegalArgumentException("Param model cannot be null");
        }
        this.fRealModel = model;
        this.fStartNumberingFromRowIndex = startNumberingFromRowIndex;
    }

    @Override
    public int getColumnCount() {
        return this.fRealModel.getColumnCount() + 1;
    }

    @Override
    public int getRowCount() {
        return this.fRealModel.getRowCount();
    }

    @Override
    public String getColumnName(int col) {
        if (col == 0) {
            return " ";
        }
        return this.fRealModel.getColumnName(col - 1);
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < this.fStartNumberingFromRowIndex && col == 0) {
            return "";
        }
        if (col == 0) {
            return new Integer(row + 1 - this.fStartNumberingFromRowIndex).toString();
        }
        return this.fRealModel.getValueAt(row, col - 1);
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return String.class;
        }
        return this.fRealModel.getColumnClass(col - 1);
    }

    public boolean isEditable() {
        return false;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

