/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.alg.gsea.GeneSetScoringTable;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;
import org.apache.log4j.Logger;

public class GeneSetScoringTables {
    private static final Logger klog = Logger.getLogger(GeneSetScoringTables.class);

    public static GeneSetScoringTable[] createAllScoringTables() {
        return new GeneSetScoringTable[]{new Classic(), new Weighted(), new WeightedSquared(), new WeightedOnePointFive()};
    }

    public static GeneSetScoringTable lookupGeneSetScoringTable(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Cannot lookup for null object");
        }
        if (obj instanceof GeneSetScoringTable) {
            return (GeneSetScoringTable)obj;
        }
        GeneSetScoringTable[] all = GeneSetScoringTables.createAllScoringTables();
        for (int i = 0; i < all.length; ++i) {
            if (!all[i].getName().equalsIgnoreCase(obj.toString())) continue;
            return all[i];
        }
        throw new RuntimeException("Cannot lookup GeneSetScoringTable for: " + obj);
    }

    private static final float _abs(float score) {
        if (Float.isNaN(score) || Float.isInfinite(score)) {
            return 0.01f;
        }
        return Math.abs(score);
    }

    public static class WeightedDoubleSidedAs1
    extends AbstractScoringTable {
        private static final String NAME = "weighted_as_1";
        private float totalPosWeight_of_hits;
        private float totalNegWeight_of_hits;
        private float numPosScores;
        private float numNegScores;
        private float nhExpected;
        private float nhPosActual;
        private float nhNegActual;
        private float nhPos_by_nh;
        private float nhNeg_by_nh;
        private float miss_pos_score;
        private float miss_neg_score;
        private int maxPosRealRank;
        private GeneSet gset;
        private RankedList rankedList;
        static int cnt = 0;

        public void setReal(RankedList rl) {
            this.rankedList = rl;
        }

        public WeightedDoubleSidedAs1() {
        }

        public WeightedDoubleSidedAs1(GeneSet gset, RankedList rl, RankedList real) {
            this.gset = gset;
            this.rankedList = rl;
            this.nhExpected = gset.getNumMembers();
            if (this.nhExpected == 0.0f) {
                throw new IllegalArgumentException("Number of members in gene set cannot be 0: " + gset.getName());
            }
            if (real == null) {
                klog.warn((Object)("Null real_rl so assuming real: " + rl.getName()));
                this.maxPosRealRank = rl.getMetricWeightStruc().getTotalPosLength();
            } else {
                this.maxPosRealRank = real.getMetricWeightStruc().getTotalPosLength();
            }
            for (int i = 0; i < this.gset.getNumMembers(); ++i) {
                String name = this.gset.getMember(i);
                float score = rl.getScore(name);
                int rank = rl.getRank(name);
                if (XMath.isPositive(score)) {
                    if (rank <= this.maxPosRealRank) {
                        this.totalPosWeight_of_hits += score;
                        this.nhPosActual += 1.0f;
                        continue;
                    }
                    this.totalNegWeight_of_hits += 0.0f;
                    this.nhNegActual += 1.0f;
                    continue;
                }
                if (rank <= this.maxPosRealRank) {
                    this.totalPosWeight_of_hits += 0.0f;
                    this.nhPosActual += 1.0f;
                    continue;
                }
                this.totalNegWeight_of_hits += score;
                this.nhNegActual += 1.0f;
            }
            for (int r = 0; r < rl.getSize(); ++r) {
                float score = rl.getScore(r);
                if (XMath.isPositive(score) && r <= this.maxPosRealRank) {
                    this.numPosScores += 1.0f;
                    continue;
                }
                this.numNegScores += 1.0f;
            }
            if (this.nhPosActual + this.nhNegActual != this.nhExpected) {
                throw new IllegalArgumentException("nhPosActual: " + this.nhPosActual + " nhNegActual: " + this.nhNegActual + " nhExpected: " + this.nhExpected);
            }
            this.nhPos_by_nh = 1.0f;
            this.nhNeg_by_nh = 1.0f;
            this.miss_pos_score = this.nhPos_by_nh * (1.0f / (this.numPosScores - this.nhPosActual));
            this.miss_neg_score = this.nhNeg_by_nh * (1.0f / (this.numNegScores - this.nhNegActual));
            if (cnt % 250 == 0) {
                System.out.println("xover: " + this.maxPosRealRank + " nhPos_by_nh: " + this.nhPos_by_nh + " nhNeg_by_nh: " + this.nhNeg_by_nh);
            }
            ++cnt;
        }

        @Override
        public GeneSetScoringTable createTable(GeneSet gset, RankedList rl, RankedList real) {
            return new WeightedDoubleSidedAs1(gset, rl, real);
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public RankedList getRankedList() {
            return this.rankedList;
        }

        @Override
        public float getHitScore(String name) {
            float score = this.rankedList.getScore(name);
            int rank = this.rankedList.getRank(name);
            if (XMath.isPositive(score)) {
                if (rank <= this.maxPosRealRank) {
                    float weight = score / this.totalPosWeight_of_hits;
                    return weight * this.nhPos_by_nh;
                }
                return 0.0f;
            }
            if (rank <= this.maxPosRealRank) {
                return 0.0f;
            }
            float weight = score / this.totalNegWeight_of_hits;
            return weight * this.nhNeg_by_nh;
        }

        @Override
        public float getMissScore(String name) {
            float score = this.rankedList.getScore(name);
            if (XMath.isPositive(score)) {
                return this.miss_pos_score;
            }
            return this.miss_neg_score;
        }
    }

    public static class WeightedDoubleSidedAs
    extends AbstractScoringTable {
        private static final String NAME = "weighted_as";
        private float totalPosWeight_of_hits;
        private float totalNegWeight_of_hits;
        private float numPosScores;
        private float numNegScores;
        private float nhExpected;
        private float nhPosActual;
        private float nhNegActual;
        private float nhPos_by_nh;
        private float nhNeg_by_nh;
        private float miss_pos_score;
        private float miss_neg_score;
        private int maxPosRealRank;
        private GeneSet gset;
        private RankedList rankedList;
        static int cnt = 0;

        public void setReal(RankedList rl) {
            this.rankedList = rl;
        }

        public WeightedDoubleSidedAs() {
        }

        public WeightedDoubleSidedAs(GeneSet gset, RankedList rl, RankedList real) {
            this.gset = gset;
            this.rankedList = rl;
            this.nhExpected = gset.getNumMembers();
            if (this.nhExpected == 0.0f) {
                throw new IllegalArgumentException("Number of members in gene set cannot be 0: " + gset.getName());
            }
            if (real == null) {
                klog.warn((Object)("Null real_rl so assuming real: " + rl.getName()));
                this.maxPosRealRank = rl.getMetricWeightStruc().getTotalPosLength();
            } else {
                this.maxPosRealRank = real.getMetricWeightStruc().getTotalPosLength();
            }
            for (int i = 0; i < this.gset.getNumMembers(); ++i) {
                String name = this.gset.getMember(i);
                float score = rl.getScore(name);
                int rank = rl.getRank(name);
                if (XMath.isPositive(score)) {
                    if (rank <= this.maxPosRealRank) {
                        this.totalPosWeight_of_hits += score;
                        this.nhPosActual += 1.0f;
                        continue;
                    }
                    this.totalNegWeight_of_hits += 0.0f;
                    this.nhNegActual += 1.0f;
                    continue;
                }
                if (rank <= this.maxPosRealRank) {
                    this.totalPosWeight_of_hits += 0.0f;
                    this.nhPosActual += 1.0f;
                    continue;
                }
                this.totalNegWeight_of_hits += score;
                this.nhNegActual += 1.0f;
            }
            for (int r = 0; r < rl.getSize(); ++r) {
                float score = rl.getScore(r);
                if (XMath.isPositive(score) && r <= this.maxPosRealRank) {
                    this.numPosScores += 1.0f;
                    continue;
                }
                this.numNegScores += 1.0f;
            }
            if (this.nhPosActual + this.nhNegActual != this.nhExpected) {
                throw new IllegalArgumentException("nhPosActual: " + this.nhPosActual + " nhNegActual: " + this.nhNegActual + " nhExpected: " + this.nhExpected);
            }
            this.nhPos_by_nh = this.nhPosActual / this.nhExpected;
            this.nhNeg_by_nh = this.nhNegActual / this.nhExpected;
            this.miss_pos_score = this.nhPos_by_nh * (1.0f / (this.numPosScores - this.nhPosActual));
            this.miss_neg_score = this.nhNeg_by_nh * (1.0f / (this.numNegScores - this.nhNegActual));
            if (cnt % 250 == 0) {
                System.out.println("xover: " + this.maxPosRealRank + " nhPos_by_nh: " + this.nhPos_by_nh + " nhNeg_by_nh: " + this.nhNeg_by_nh);
            }
            ++cnt;
        }

        @Override
        public GeneSetScoringTable createTable(GeneSet gset, RankedList rl, RankedList real) {
            return new WeightedDoubleSidedAs(gset, rl, real);
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public RankedList getRankedList() {
            return this.rankedList;
        }

        @Override
        public float getHitScore(String name) {
            float score = this.rankedList.getScore(name);
            int rank = this.rankedList.getRank(name);
            if (XMath.isPositive(score)) {
                if (rank <= this.maxPosRealRank) {
                    float weight = score / this.totalPosWeight_of_hits;
                    return weight * this.nhPos_by_nh;
                }
                return 0.0f;
            }
            if (rank <= this.maxPosRealRank) {
                return 0.0f;
            }
            float weight = score / this.totalNegWeight_of_hits;
            return weight * this.nhNeg_by_nh;
        }

        @Override
        public float getMissScore(String name) {
            float score = this.rankedList.getScore(name);
            if (XMath.isPositive(score)) {
                return this.miss_pos_score;
            }
            return this.miss_neg_score;
        }
    }

    public static class WeightedOnePointFive
    extends AbstractScoringTable {
        private static final String NAME = "weighted_p1.5";
        private float totalWeight_sq;
        private float nhExpected;
        private float miss_score;
        private GeneSet gset;
        private RankedList rankedList;

        public WeightedOnePointFive() {
        }

        public WeightedOnePointFive(GeneSet gset, RankedList rl) {
            this.gset = gset;
            this.nhExpected = gset.getNumMembers();
            if (this.nhExpected == 0.0f) {
                throw new IllegalArgumentException("Number of members in gene set cannot be 0: " + gset.getName());
            }
            this.rankedList = rl;
            for (int i = 0; i < this.gset.getNumMembers(); ++i) {
                float score = this.rankedList.getScore(gset.getMember(i));
                this.totalWeight_sq = (float)((double)this.totalWeight_sq + Math.pow(score, 1.5));
            }
            float nTotal = this.rankedList.getSize();
            this.miss_score = 1.5f / (nTotal - this.nhExpected);
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public RankedList getRankedList() {
            return this.rankedList;
        }

        @Override
        public GeneSetScoringTable createTable(GeneSet gset, RankedList rl, RankedList realRankedList) {
            return new WeightedOnePointFive(gset, rl);
        }

        @Override
        public float getHitScore(String name) {
            float score = this.rankedList.getScore(name);
            float ss = (float)Math.pow(score, 0.5);
            return ss / this.totalWeight_sq;
        }

        @Override
        public float getMissScore(String name) {
            return this.miss_score;
        }
    }

    public static class WeightedSquared
    extends AbstractScoringTable {
        private static final String NAME = "weighted_p2";
        private float totalWeight_sq;
        private float nhExpected;
        private float miss_score;
        private GeneSet gset;
        private RankedList rankedList;

        public WeightedSquared() {
        }

        public WeightedSquared(GeneSet gset, RankedList rl) {
            this.gset = gset;
            this.nhExpected = gset.getNumMembers();
            if (this.nhExpected == 0.0f) {
                throw new IllegalArgumentException("Number of members in gene set cannot be 0: " + gset.getName());
            }
            this.rankedList = rl;
            for (int i = 0; i < this.gset.getNumMembers(); ++i) {
                float score = this.rankedList.getScore(gset.getMember(i));
                this.totalWeight_sq += score * score;
            }
            float nTotal = this.rankedList.getSize();
            this.miss_score = 1.0f / (nTotal - this.nhExpected);
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public RankedList getRankedList() {
            return this.rankedList;
        }

        @Override
        public GeneSetScoringTable createTable(GeneSet gset, RankedList rl, RankedList realRankedList) {
            return new WeightedSquared(gset, rl);
        }

        @Override
        public float getHitScore(String name) {
            float score = this.rankedList.getScore(name);
            return score * score / this.totalWeight_sq;
        }

        @Override
        public float getMissScore(String name) {
            return this.miss_score;
        }
    }

    public static class Weighted
    extends AbstractScoringTable {
        private static final String NAME = "weighted";
        private float totalWeight;
        private float nhExpected;
        private float miss_score;
        private GeneSet gset;
        private RankedList rankedList;

        public Weighted() {
        }

        public Weighted(GeneSet gset, RankedList rl) {
            this.gset = gset;
            this.nhExpected = gset.getNumMembers();
            if (this.nhExpected == 0.0f) {
                throw new IllegalArgumentException("Number of members in gene set cannot be 0: " + gset.getName());
            }
            this.rankedList = rl;
            for (int i = 0; i < this.gset.getNumMembers(); ++i) {
                float score = this.rankedList.getScore(gset.getMember(i));
                this.totalWeight += GeneSetScoringTables._abs(score);
            }
            float nTotal = this.rankedList.getSize();
            this.miss_score = 1.0f / (nTotal - this.nhExpected);
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public RankedList getRankedList() {
            return this.rankedList;
        }

        @Override
        public GeneSetScoringTable createTable(GeneSet gset, RankedList rl, RankedList realRankedList) {
            return new Weighted(gset, rl);
        }

        @Override
        public float getHitScore(String name) {
            float score = this.rankedList.getScore(name);
            score = GeneSetScoringTables._abs(score);
            return score / this.totalWeight;
        }

        @Override
        public float getMissScore(String name) {
            return this.miss_score;
        }
    }

    public static class Classic
    extends AbstractScoringTable {
        private static final String NAME = "classic";
        private float hitpoints;
        private float misspoints;
        private RankedList rankedList;

        public Classic() {
        }

        Classic(GeneSet gset, RankedList rl) {
            this.rankedList = rl;
            int ntrue = gset.getNumMembers();
            int totSize = rl.getSize();
            this.hitpoints = 1.0f / (float)ntrue;
            this.misspoints = 1.0f / ((float)totSize - (float)ntrue);
        }

        @Override
        public GeneSetScoringTable createTable(GeneSet gset, RankedList rl, RankedList realRankedList) {
            return new Classic(gset, rl);
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public RankedList getRankedList() {
            return this.rankedList;
        }

        @Override
        public float getHitScore(String name) {
            return this.hitpoints;
        }

        @Override
        public float getMissScore(String name) {
            return this.misspoints;
        }
    }

    static abstract class AbstractScoringTable
    implements GeneSetScoringTable {
        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof GeneSetScoringTable) {
                return this.getName().equalsIgnoreCase(((GeneSetScoringTable)obj).getName());
            }
            return false;
        }

        public String toString() {
            return this.getName();
        }
    }
}

